/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.disguise;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguisePlayerCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Disguise disguise;
        if (this.isNotPremium(sender)) {
            return true;
        }
        DisguisePermissions permissions = this.getPermissions(sender);
        if (!permissions.hasPermissions()) {
            DisguiseUtilities.sendMessage(sender, LibsMsg.NO_PERM, new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, permissions);
            return true;
        }
        if (args.length == 1) {
            DisguiseUtilities.sendMessage(sender, LibsMsg.DPLAYER_SUPPLY, new Object[0]);
            return true;
        }
        Player entityTarget = Bukkit.getPlayer((String)args[0]);
        if (entityTarget == null && args[0].contains("-")) {
            try {
                entityTarget = Bukkit.getEntity((UUID)UUID.fromString(args[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (entityTarget == null) {
            sender.sendMessage(LibsMsg.CANNOT_FIND_PLAYER.get(args[0]));
            return true;
        }
        Object[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        if (newArgs.length == 0) {
            this.sendCommandUsage(sender, permissions);
            return true;
        }
        try {
            disguise = DisguiseParser.parseDisguise(sender, (Entity)entityTarget, this.getPermNode(), DisguiseUtilities.split(StringUtils.join((Object[])newArgs, (String)" ")), permissions);
        }
        catch (DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        if (disguise.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            DisguiseUtilities.sendMessage(sender, LibsMsg.DISABLED_LIVING_TO_MISC, new Object[0]);
            return true;
        }
        if (DisguiseConfig.isNameOfPlayerShownAboveDisguise() && !entityTarget.hasPermission("libsdisguises.hidename") && disguise.getWatcher() instanceof LivingWatcher) {
            disguise.getWatcher().setCustomName(this.getDisplayName((CommandSender)entityTarget));
            if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                disguise.getWatcher().setCustomNameVisible(true);
            }
        }
        disguise.setEntity((Entity)entityTarget);
        if (!this.setViewDisguise(args) && DisguiseAPI.hasSelfDisguisePreference(disguise.getEntity()) && disguise.isSelfDisguiseVisible() == DisguiseConfig.isViewDisguises()) {
            disguise.setViewSelfDisguise(!disguise.isSelfDisguiseVisible());
        }
        disguise.startDisguise();
        if (disguise.isDisguiseInUse()) {
            sender.sendMessage(LibsMsg.DISG_PLAYER_AS_DISG.get(entityTarget instanceof Player ? entityTarget.getName() : DisguiseType.getType((Entity)entityTarget).toReadable(), disguise.getDisguiseName()));
        } else {
            sender.sendMessage(LibsMsg.DISG_PLAYER_AS_DISG_FAIL.get(entityTarget instanceof Player ? entityTarget.getName() : DisguiseType.getType((Entity)entityTarget).toReadable(), disguise.getDisguiseName()));
        }
        return true;
    }

    private boolean setViewDisguise(String[] strings) {
        for (String string : strings) {
            if (!string.equalsIgnoreCase("setSelfDisguiseVisible")) continue;
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getPreviousArgs(origArgs);
        DisguisePermissions perms = this.getPermissions(sender);
        if (args.length == 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (sender instanceof Player && !((Player)sender).canSee(player)) continue;
                tabs.add(player.getName());
            }
        } else {
            tabs.addAll(this.getTabDisguiseTypes(sender, perms, args, 1, this.getCurrentArg(origArgs)));
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, DisguisePermissions permissions) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(permissions);
        if (allowedDisguises.isEmpty()) {
            DisguiseUtilities.sendMessage(sender, LibsMsg.NO_PERM, new Object[0]);
            return;
        }
        DisguiseUtilities.sendMessage(sender, LibsMsg.D_HELP1, new Object[0]);
        DisguiseUtilities.sendMessage(sender, LibsMsg.CAN_USE_DISGS, StringUtils.join(allowedDisguises, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
        if (allowedDisguises.contains("player")) {
            DisguiseUtilities.sendMessage(sender, LibsMsg.D_HELP3, new Object[0]);
        }
        DisguiseUtilities.sendMessage(sender, LibsMsg.D_HELP4, new Object[0]);
        if (allowedDisguises.contains("dropped_item") || allowedDisguises.contains("falling_block")) {
            DisguiseUtilities.sendMessage(sender, LibsMsg.D_HELP5, new Object[0]);
        }
    }
}

