/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoTypes;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemBlock;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoSoundGroup;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.watchers.DisguiseMethods;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.inventory.ItemStack;

public class ParamInfoManager {
    private static List<ParamInfo> paramList;
    private static DisguiseMethods disguiseMethods;
    private static ParamInfoItemBlock paramInfoItemBlock;
    private static ParamInfoSoundGroup paramInfoSoundGroup;

    public static List<ParamInfo> getParamInfos() {
        return paramList;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        ParamInfo info = ParamInfoManager.getParamInfo(object.getClass());
        if (info == null) {
            throw new IllegalArgumentException(object.getClass() + " is not handled by ParamInfo!");
        }
        return info.toString(object);
    }

    public static ParamInfo getParamInfo(Method method) {
        if (method.getName().equals("setSoundGroup")) {
            return ParamInfoManager.getParamInfoSoundGroup();
        }
        if (method.getDeclaringClass() == FallingBlockWatcher.class && method.getParameterTypes()[0] == ItemStack.class) {
            return ParamInfoManager.getParamInfoItemBlock();
        }
        return ParamInfoManager.getParamInfo(method.getParameterTypes()[0]);
    }

    public static ParamInfo getParamInfo(Class c) {
        for (ParamInfo info : ParamInfoManager.getParamInfos()) {
            if (!info.isParam(c)) continue;
            return info;
        }
        return null;
    }

    public static ParamInfo getParamInfo(DisguisePerm disguiseType, String methodName) {
        return ParamInfoManager.getParamInfo(disguiseType.getType(), methodName);
    }

    public static ParamInfo getParamInfo(DisguiseType disguiseType, String methodName) {
        for (Method method : ParamInfoManager.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
            if (!method.getName().toLowerCase().equals(methodName.toLowerCase())) continue;
            return ParamInfoManager.getParamInfo(method);
        }
        return null;
    }

    public static Method[] getDisguiseWatcherMethods(@Nullable Class<? extends FlagWatcher> watcherClass) {
        if (watcherClass == null) {
            return new Method[0];
        }
        ArrayList<Method> methods = new ArrayList<Method>(disguiseMethods.getMethods(watcherClass));
        methods.sort((m1, m2) -> {
            int v2;
            int v1 = ParamInfoManager.getValue(m1);
            if (v1 != (v2 = ParamInfoManager.getValue(m2))) {
                return v1 - v2;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(m1.getName(), m2.getName());
        });
        for (String methodName : new String[]{"setSelfDisguiseVisible", "setHideHeldItemFromSelf", "setHideArmorFromSelf", "setHearSelfDisguise", "setHidePlayer", "setExpires", "setNotifyBar", "setBossBarColor", "setBossBarStyle", "setTallDisguisesVisible", "setDynamicName", "setSoundGroup"}) {
            try {
                Class<Object> cl = Boolean.TYPE;
                switch (methodName) {
                    case "setExpires": {
                        cl = Long.TYPE;
                        break;
                    }
                    case "setNotifyBar": {
                        cl = DisguiseConfig.NotifyBar.class;
                        break;
                    }
                    case "setBossBarColor": {
                        cl = BarColor.class;
                        break;
                    }
                    case "setBossBarStyle": {
                        cl = BarStyle.class;
                        break;
                    }
                    case "setSoundGroup": {
                        cl = String.class;
                        break;
                    }
                }
                methods.add(Disguise.class.getMethod(methodName, cl));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return methods.toArray(new Method[0]);
    }

    public static int getValue(Method method) {
        ChatColor methodColor = ChatColor.YELLOW;
        Class<?> declaring = method.getDeclaringClass();
        if (declaring == LivingWatcher.class) {
            return 1;
        }
        if (!FlagWatcher.class.isAssignableFrom(declaring) || declaring == FlagWatcher.class) {
            return 2;
        }
        return 0;
    }

    public static ParamInfoItemBlock getParamInfoItemBlock() {
        return paramInfoItemBlock;
    }

    public static ParamInfoSoundGroup getParamInfoSoundGroup() {
        return paramInfoSoundGroup;
    }

    static {
        ParamInfoTypes infoTypes = new ParamInfoTypes();
        paramList = infoTypes.getParamInfos();
        paramInfoItemBlock = infoTypes.getParamInfoBlock();
        paramInfoSoundGroup = paramList.stream().filter(p -> p instanceof ParamInfoSoundGroup).findAny().orElse(null);
        disguiseMethods = new DisguiseMethods();
    }
}

