/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.Arrays;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.plugin.PluginInformation;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LDUpdate
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("update", "update dev", "update release", "update!");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.update";
    }

    @Override
    public void onCommand(final CommandSender sender, final String[] args) {
        final UpdateChecker checker = LibsDisguises.getInstance().getUpdateChecker();
        if (checker.isDownloading()) {
            sender.sendMessage(LibsMsg.UPDATE_IN_PROGRESS.get(new Object[0]));
            return;
        }
        boolean releaseBuilds = checker.isUsingReleaseBuilds();
        if (args.length > 1) {
            if (args[1].equalsIgnoreCase("dev")) {
                releaseBuilds = false;
            } else if (args[1].equalsIgnoreCase("release")) {
                releaseBuilds = true;
            } else {
                sender.sendMessage(LibsMsg.LIBS_UPDATE_UNKNOWN_BRANCH.get(new Object[0]));
                return;
            }
            DisguiseConfig.setUsingReleaseBuilds(releaseBuilds);
        }
        if (checker.getUpdate() != null && checker.getUpdate().isReleaseBuild() == releaseBuilds && args.length <= 1) {
            if (checker.isServerLatestVersion()) {
                sender.sendMessage(LibsMsg.UPDATE_ON_LATEST.get(new Object[0]));
                return;
            }
            if (checker.isOnLatestUpdate(true)) {
                sender.sendMessage(LibsMsg.UPDATE_ALREADY_DOWNLOADED.get(new Object[0]));
                return;
            }
        }
        new BukkitRunnable(){

            public void run() {
                LibsMsg updateResult = null;
                if (checker.getUpdate() == null || args.length > 1 || checker.isOldUpdate()) {
                    updateResult = checker.doUpdateCheck();
                }
                if (checker.getUpdate() == null) {
                    sender.sendMessage(LibsMsg.UPDATE_FAILED.get(new Object[0]));
                    return;
                }
                if (checker.isOnLatestUpdate(true)) {
                    if (checker.getLastDownload() != null) {
                        sender.sendMessage(LibsMsg.UPDATE_ALREADY_DOWNLOADED.get(new Object[0]));
                    } else {
                        sender.sendMessage(LibsMsg.UPDATE_ON_LATEST.get(new Object[0]));
                    }
                    return;
                }
                if (!args[0].endsWith("!")) {
                    if (updateResult != null) {
                        sender.sendMessage(updateResult.get(new Object[0]));
                    } else {
                        for (String msg : checker.getUpdateMessage()) {
                            sender.sendMessage(msg);
                        }
                    }
                    return;
                }
                PluginInformation result = checker.doUpdate();
                if (result == null) {
                    sender.sendMessage(LibsMsg.UPDATE_FAILED.get(new Object[0]));
                    return;
                }
                for (String msg : checker.getUpdateMessage()) {
                    sender.sendMessage(msg);
                }
                if (sender instanceof Player) {
                    for (String msg : checker.getUpdateMessage()) {
                        DisguiseUtilities.getLogger().info(msg);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_UPDATE;
    }
}

