/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.command.CommandSender;

public class LDCount
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Collections.singletonList("count");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.count";
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        HashMap<DisguiseType, Integer> counts = new HashMap<DisguiseType, Integer>();
        for (Set<TargetedDisguise> disguises : DisguiseUtilities.getDisguises().values()) {
            for (Disguise disguise : disguises) {
                counts.compute(disguise.getType(), (a, b) -> (b != null ? b : 0) + 1);
            }
        }
        if (counts.isEmpty()) {
            sender.sendMessage(LibsMsg.NO_DISGUISES_IN_USE.get(new Object[0]));
        } else {
            sender.sendMessage(LibsMsg.ACTIVE_DISGUISES_COUNT.get(counts.values().stream().reduce(Integer::sum).get()));
            ArrayList types = new ArrayList(counts.keySet());
            types.sort((d1, d2) -> String.CASE_INSENSITIVE_ORDER.compare(TranslateType.DISGUISES.get(d1.toReadable()), TranslateType.DISGUISES.get(d2.toReadable())));
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < types.size(); ++i) {
                builder.append(LibsMsg.ACTIVE_DISGUISES_DISGUISE.get(TranslateType.DISGUISES.get(((DisguiseType)((Object)types.get(i))).toReadable()), counts.get(types.get(i))));
                if (i + 1 >= types.size()) continue;
                builder.append(LibsMsg.ACTIVE_DISGUISES_SEPERATOR.get(new Object[0]));
            }
            sender.sendMessage(LibsMsg.ACTIVE_DISGUISES.get(builder.toString()));
        }
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_COUNT;
    }
}

