/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsHandler;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class PacketHandlerSpawn
implements IPacketHandler {
    private PacketsHandler packetsHandler;

    public PacketHandlerSpawn(PacketsHandler packetsHandler) {
        this.packetsHandler = packetsHandler;
    }

    @Override
    public PacketType[] getHandledPackets() {
        return new PacketType[]{PacketType.Play.Server.NAMED_ENTITY_SPAWN, PacketType.Play.Server.SPAWN_ENTITY_LIVING, PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB, PacketType.Play.Server.SPAWN_ENTITY, PacketType.Play.Server.SPAWN_ENTITY_PAINTING};
    }

    @Override
    public void handle(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        packets.clear();
        if (disguise.getType() == DisguiseType.UNKNOWN) {
            return;
        }
        this.constructSpawnPackets(observer, packets, entity);
    }

    private void constructSpawnPackets(Player observer, LibsPackets packets, Entity disguisedEntity) {
        boolean delayedArmor;
        Disguise disguise = packets.getDisguise();
        if (disguise.getEntity() == null) {
            disguise.setEntity(disguisedEntity);
        }
        if (DisguiseConfig.isMiscDisguisesForLivingEnabled() && disguise.getWatcher() instanceof LivingWatcher) {
            ArrayList<WrappedAttribute> attributes = new ArrayList<WrappedAttribute>();
            WrappedAttribute.Builder builder = WrappedAttribute.newBuilder().attributeKey("generic.maxHealth");
            if (((LivingWatcher)disguise.getWatcher()).isMaxHealthSet()) {
                builder.baseValue(((LivingWatcher)disguise.getWatcher()).getMaxHealth());
            } else if (DisguiseConfig.isMaxHealthDeterminedByDisguisedEntity() && disguisedEntity instanceof Damageable) {
                builder.baseValue(((Damageable)disguisedEntity).getMaxHealth());
            } else {
                builder.baseValue(DisguiseValues.getDisguiseValues(disguise.getType()).getMaxHealth());
            }
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            builder.packet(packet);
            attributes.add(builder.build());
            packet.getIntegers().write(0, (Object)disguisedEntity.getEntityId());
            packet.getAttributeCollectionModifier().write(0, attributes);
            packets.addPacket(packet);
        }
        Location loc = disguisedEntity.getLocation().clone().add(0.0, DisguiseUtilities.getYModifier(disguisedEntity, disguise), 0.0);
        byte yaw = (byte)(loc.getYaw() * 256.0f / 360.0f);
        byte pitch = (byte)(loc.getPitch() * 256.0f / 360.0f);
        if (DisguiseConfig.isMovementPacketsEnabled()) {
            yaw = DisguiseUtilities.getYaw(disguise.getType(), disguisedEntity.getType(), yaw);
            pitch = DisguiseUtilities.getPitch(disguise.getType(), disguisedEntity.getType(), pitch);
        }
        if (disguise.getType() == DisguiseType.EXPERIENCE_ORB) {
            PacketContainer spawnOrb = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB);
            packets.addPacket(spawnOrb);
            StructureModifier mods = spawnOrb.getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)loc.getX());
            mods.write(2, (Object)(loc.getY() + 0.06));
            mods.write(3, (Object)loc.getZ());
            mods.write(4, (Object)1);
        } else if (disguise.getType() == DisguiseType.PAINTING) {
            PacketContainer spawnPainting = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_PAINTING);
            packets.addPacket(spawnPainting);
            StructureModifier mods = spawnPainting.getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)disguisedEntity.getUniqueId());
            mods.write(2, ReflectionManager.getBlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
            mods.write(3, (Object)ReflectionManager.getEnumDirection((int)loc.getYaw() % 4));
            int id = ((MiscDisguise)disguise).getData();
            mods.write(4, NmsVersion.v1_13.isSupported() ? Integer.valueOf(id) : ReflectionManager.getEnumArt(Art.values()[id]));
            PacketContainer teleportPainting = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
            packets.addPacket(teleportPainting);
            mods = teleportPainting.getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)loc.getX());
            mods.write(2, (Object)loc.getY());
            mods.write(3, (Object)loc.getZ());
            mods.write(4, (Object)yaw);
            mods.write(5, (Object)pitch);
        } else if (disguise.getType().isPlayer()) {
            WrappedDataWatcher newWatcher;
            boolean selfDisguise;
            boolean visibleOrNewCompat;
            PlayerDisguise playerDisguise = (PlayerDisguise)disguise;
            boolean bl = visibleOrNewCompat = playerDisguise.isNameVisible() || DisguiseConfig.isScoreboardDisguiseNames();
            WrappedGameProfile spawnProfile = visibleOrNewCompat ? playerDisguise.getGameProfile() : ReflectionManager.getGameProfileWithThisSkin(UUID.randomUUID(), visibleOrNewCompat ? playerDisguise.getProfileName() : "", playerDisguise.getGameProfile());
            int entityId = disguisedEntity.getEntityId();
            if (!playerDisguise.isDisplayedInTab() || !playerDisguise.isNameVisible()) {
                PacketContainer sendTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                sendTab.getModifier().write(0, (Object)ReflectionManager.getEnumPlayerInfoAction(0));
                List<Object> playerList = Collections.singletonList(ReflectionManager.getPlayerInfoData(sendTab.getHandle(), spawnProfile));
                sendTab.getModifier().write(1, playerList);
                packets.addPacket(sendTab);
                PacketContainer deleteTab = sendTab.shallowClone();
                deleteTab.getModifier().write(0, (Object)ReflectionManager.getEnumPlayerInfoAction(4));
                if (LibsPremium.getPaidInformation() == null || LibsPremium.getPaidInformation().getBuildNumber().matches("#[0-9]+")) {
                    packets.addDelayedPacket(deleteTab, DisguiseConfig.getPlayerDisguisesTablistExpires());
                }
            }
            PacketContainer spawnPlayer = new PacketContainer(PacketType.Play.Server.NAMED_ENTITY_SPAWN);
            spawnPlayer.getIntegers().write(0, (Object)entityId);
            spawnPlayer.getModifier().write(1, (Object)spawnProfile.getUUID());
            Location spawnAt = disguisedEntity.getLocation();
            boolean bl2 = selfDisguise = observer == disguisedEntity;
            if (selfDisguise) {
                newWatcher = DisguiseUtilities.createSanitizedDataWatcher(WrappedDataWatcher.getEntityWatcher((Entity)disguisedEntity), disguise.getWatcher());
            } else {
                newWatcher = new WrappedDataWatcher();
                spawnAt = observer.getLocation();
                spawnAt.add(spawnAt.getDirection().normalize().multiply(20));
            }
            StructureModifier doubles = spawnPlayer.getDoubles();
            doubles.write(0, (Object)spawnAt.getX());
            doubles.write(1, (Object)spawnAt.getY());
            doubles.write(2, (Object)spawnAt.getZ());
            StructureModifier bytes = spawnPlayer.getBytes();
            bytes.write(0, (Object)yaw);
            bytes.write(1, (Object)pitch);
            newWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(MetaIndex.ENTITY_META.getIndex(), WrappedDataWatcher.Registry.get(Byte.class)), (Object)32);
            packets.addPacket(spawnPlayer);
            if (NmsVersion.v1_15.isSupported()) {
                PacketContainer metaPacket = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{entityId, newWatcher, true}).createPacket(new Object[]{entityId, newWatcher, true});
                packets.addPacket(metaPacket);
            } else {
                spawnPlayer.getDataWatcherModifier().write(0, (Object)newWatcher);
            }
            if (!selfDisguise) {
                PacketContainer teleportPacket = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
                doubles = teleportPacket.getDoubles();
                teleportPacket.getIntegers().write(0, (Object)entityId);
                doubles.write(0, (Object)loc.getX());
                doubles.write(1, (Object)loc.getY());
                doubles.write(2, (Object)loc.getZ());
                bytes = teleportPacket.getBytes();
                bytes.write(0, (Object)yaw);
                bytes.write(1, (Object)pitch);
                packets.addDelayedPacket(teleportPacket, 3);
                PacketContainer metaPacket = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
                newWatcher = DisguiseUtilities.createSanitizedDataWatcher(WrappedDataWatcher.getEntityWatcher((Entity)disguisedEntity), disguise.getWatcher());
                metaPacket.getIntegers().write(0, (Object)entityId);
                metaPacket.getWatchableCollectionModifier().write(0, (Object)newWatcher.getWatchableObjects());
                this.packetsHandler.addCancel(disguise, observer);
                packets.addDelayedPacket(metaPacket, 7);
                packets.setRemoveMetaAt(7);
            }
        } else if (disguise.getType().isMob() || disguise.getType() == DisguiseType.ARMOR_STAND) {
            Vector vec = disguisedEntity.getVelocity();
            PacketContainer spawnEntity = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
            packets.addPacket(spawnEntity);
            StructureModifier mods = spawnEntity.getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)disguisedEntity.getUniqueId());
            mods.write(2, (Object)disguise.getType().getTypeId());
            double d1 = 3.9;
            double d2 = vec.getX();
            double d3 = vec.getY();
            double d4 = vec.getZ();
            if (d2 < -d1) {
                d2 = -d1;
            }
            if (d3 < -d1) {
                d3 = -d1;
            }
            if (d4 < -d1) {
                d4 = -d1;
            }
            if (d2 > d1) {
                d2 = d1;
            }
            if (d3 > d1) {
                d3 = d1;
            }
            if (d4 > d1) {
                d4 = d1;
            }
            mods.write(3, (Object)loc.getX());
            mods.write(4, (Object)loc.getY());
            mods.write(5, (Object)loc.getZ());
            mods.write(6, (Object)((int)(d2 * 8000.0)));
            mods.write(7, (Object)((int)(d3 * 8000.0)));
            mods.write(8, (Object)((int)(d4 * 8000.0)));
            mods.write(9, (Object)yaw);
            mods.write(10, (Object)pitch);
            mods.write(11, (Object)yaw);
            WrappedDataWatcher newWatcher = DisguiseUtilities.createSanitizedDataWatcher(WrappedDataWatcher.getEntityWatcher((Entity)disguisedEntity), disguise.getWatcher());
            if (NmsVersion.v1_15.isSupported()) {
                PacketContainer metaPacket = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{disguisedEntity.getEntityId(), newWatcher, true}).createPacket(new Object[]{disguisedEntity.getEntityId(), newWatcher, true});
                packets.addPacket(metaPacket);
            } else {
                spawnEntity.getDataWatcherModifier().write(0, (Object)newWatcher);
            }
        } else if (disguise.getType().isMisc()) {
            PacketContainer spawnEntity;
            int data = ((MiscDisguise)disguise).getData();
            double x = loc.getX();
            double y = loc.getY();
            double z = loc.getZ();
            if (disguise.getType() == DisguiseType.FALLING_BLOCK) {
                ItemStack block = ((FallingBlockWatcher)disguise.getWatcher()).getBlock();
                data = ReflectionManager.getCombinedIdByItemStack(block);
                if (((FallingBlockWatcher)disguise.getWatcher()).isGridLocked()) {
                    x = (double)loc.getBlockX() + 0.5;
                    y = loc.getBlockY();
                    z = (double)loc.getBlockZ() + 0.5;
                }
            } else if (disguise.getType() == DisguiseType.FISHING_HOOK && data == -1) {
                data = observer.getEntityId();
            } else if (disguise.getType() == DisguiseType.ITEM_FRAME) {
                data = ((int)loc.getYaw() % 360 + 720 + 45) / 90 % 4;
            }
            if (NmsVersion.v1_14.isSupported()) {
                Object entityType = ReflectionManager.getEntityType(disguise.getType().getEntityType());
                Object[] params = new Object[]{disguisedEntity.getEntityId(), disguisedEntity.getUniqueId(), x, y, z, Float.valueOf(loc.getPitch()), Float.valueOf(loc.getYaw()), entityType, data, ReflectionManager.getVec3D(disguisedEntity.getVelocity())};
                spawnEntity = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.SPAWN_ENTITY, params).createPacket(params);
            } else {
                int objectId = disguise.getType().getObjectId();
                Object nmsEntity = ReflectionManager.getNmsEntity(disguisedEntity);
                spawnEntity = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.SPAWN_ENTITY, new Object[]{nmsEntity, objectId, data}).createPacket(new Object[]{nmsEntity, objectId, data});
            }
            packets.addPacket(spawnEntity);
            if (DisguiseType.getType(disguisedEntity) != disguise.getType()) {
                StructureModifier ints = spawnEntity.getIntegers();
                ints.write(1, (Object)0);
                ints.write(2, (Object)0);
                ints.write(3, (Object)0);
                if (disguise.getType() == DisguiseType.DROPPED_ITEM) {
                    PacketContainer velocity = new PacketContainer(PacketType.Play.Server.ENTITY_VELOCITY);
                    velocity.getIntegers().write(0, (Object)disguisedEntity.getEntityId());
                    packets.addPacket(velocity);
                }
            }
            spawnEntity.getModifier().write(8, (Object)pitch);
            spawnEntity.getModifier().write(9, (Object)yaw);
            if (disguise.getType() == DisguiseType.ITEM_FRAME) {
                if (data % 2 == 0) {
                    spawnEntity.getModifier().write(4, (Object)(loc.getZ() + (double)(data == 0 ? -1 : 1)));
                } else {
                    spawnEntity.getModifier().write(2, (Object)(loc.getX() + (double)(data == 3 ? -1 : 1)));
                }
            }
        }
        if (packets.getPackets().size() <= 1 || disguise.isPlayerDisguise()) {
            PacketContainer rotateHead = new PacketContainer(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
            packets.addPacket(rotateHead);
            StructureModifier mods = rotateHead.getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)yaw);
        }
        if (disguise.getType() == DisguiseType.EVOKER_FANGS) {
            PacketContainer newPacket = new PacketContainer(PacketType.Play.Server.ENTITY_STATUS);
            StructureModifier mods = newPacket.getModifier();
            mods.write(0, (Object)disguise.getEntity().getEntityId());
            mods.write(1, (Object)4);
            packets.addPacket(newPacket);
        }
        boolean bl = delayedArmor = DisguiseConfig.isPlayerHideArmor() && disguise.isPlayerDisguise() && disguisedEntity != observer && disguisedEntity instanceof LivingEntity;
        if (delayedArmor) {
            packets.setSendArmor(true);
            packets.setRemoveMetaAt(7);
        }
        if (DisguiseConfig.isEquipmentPacketsEnabled() || delayedArmor) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack itemToSend;
                if (delayedArmor) {
                    itemToSend = new ItemStack(Material.AIR);
                } else {
                    itemToSend = disguise.getWatcher().getItemStack(slot);
                    if (itemToSend == null ? (itemToSend = ReflectionManager.getEquipment(slot, disguisedEntity)) == null || itemToSend.getType() == Material.AIR : itemToSend.getType() == Material.AIR) continue;
                }
                PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
                StructureModifier mods = packet.getModifier();
                mods.write(0, (Object)disguisedEntity.getEntityId());
                mods.write(1, (Object)ReflectionManager.createEnumItemSlot(slot));
                mods.write(2, ReflectionManager.getNmsItem(itemToSend));
                packets.addDelayedPacket(packet);
            }
        }
    }
}

