/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;

public class UpdateChecker {
    private final String resourceID;
    private String latestVersion;
    private int latestSnapshot;

    public UpdateChecker(String resourceID) {
        this.resourceID = resourceID;
    }

    public void checkSnapshotUpdate(int buildNumber) {
        Map<String, Object> lastBuild = this.fetchLastSnapshotBuild();
        if (lastBuild == null || !lastBuild.containsKey("id") || !lastBuild.containsKey("timestamp")) {
            return;
        }
        int newBuildNumber = Integer.parseInt((String)lastBuild.get("id"));
        if (newBuildNumber <= buildNumber) {
            return;
        }
        Date newBuildDate = new Date(((Number)lastBuild.get("timestamp")).longValue());
        this.latestSnapshot = newBuildNumber;
    }

    public void checkOfficialUpdate(String currentVersion) {
        String version = this.fetchSpigotVersion();
        if (version == null) {
            return;
        }
        if (!this.isNewerVersion(currentVersion, version)) {
            return;
        }
        this.latestVersion = version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchSpigotVersion() {
        try {
            URL url = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceID);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            try (InputStream input = con.getInputStream();){
                String version = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                if (version.isEmpty()) return null;
                String string = version;
                return string;
            }
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Failed to check for a update on spigot.");
        }
        return null;
    }

    private boolean isNewerVersion(String currentVersion, String newVersion) {
        return !currentVersion.replaceAll("(v)|(-SNAPSHOT)", "").equals(newVersion.replaceAll("(v)|(-SNAPSHOT)", ""));
    }

    private Map<String, Object> fetchLastSnapshotBuild() {
        try {
            Map jsonObject;
            URL url = new URL("https://ci.md-5.net/job/LibsDisguises/lastSuccessfulBuild/api/json");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            try (InputStream input = con.getInputStream();){
                String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                jsonObject = (Map)new Gson().fromJson(json, Map.class);
            }
            return jsonObject;
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Failed to check for a snapshot update on jenkins.");
            return null;
        }
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public int getLatestSnapshot() {
        return this.latestSnapshot;
    }
}

