/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.watchers;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.ClassGetter;
import me.libraryaddict.disguise.utilities.reflection.WatcherInfo;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodIgnoredBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodOnlyUsedBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import me.libraryaddict.disguise.utilities.sounds.DisguiseSoundEnums;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;

public class CompileMethods {
    @CompileMethodsIntfer(user="%%__USER__%%")
    public static void main(String[] args) {
        CompileMethods.doMethods();
        CompileMethods.doSounds();
    }

    private static void doSounds() {
        ArrayList<String> list = new ArrayList<String>();
        for (DisguiseSoundEnums e : DisguiseSoundEnums.values()) {
            StringBuilder sound = new StringBuilder(e.name());
            for (SoundGroup.SoundType type : SoundGroup.SoundType.values()) {
                sound.append("/");
                int i = 0;
                for (Map.Entry<String, SoundGroup.SoundType> entry : e.getSounds().entrySet()) {
                    if (entry.getValue() != type) continue;
                    if (i++ > 0) {
                        sound.append(",");
                    }
                    sound.append(entry.getKey());
                }
            }
            list.add(sound.toString());
        }
        File soundsFile = new File("plugin/target/classes/SOUND_MAPPINGS");
        try (FileOutputStream fos = new FileOutputStream(soundsFile);){
            fos.write(String.join((CharSequence)"\n", list).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addClass(ArrayList<Class> classes, Class c) {
        if (classes.contains(c)) {
            return;
        }
        if (c != FlagWatcher.class) {
            CompileMethods.addClass(classes, c.getSuperclass());
        }
        classes.add(c);
    }

    private static void doMethods() {
        ArrayList<Class<?>> classes = ClassGetter.getClassesForPackage(FlagWatcher.class, "me.libraryaddict.disguise.disguisetypes.watchers");
        ArrayList<Class> sorted = new ArrayList<Class>();
        for (Class<?> clazz : classes) {
            CompileMethods.addClass(sorted, clazz);
        }
        ArrayList<String> methods = new ArrayList<String>();
        for (Class c : sorted) {
            for (Method method : c.getMethods()) {
                if (!FlagWatcher.class.isAssignableFrom(method.getDeclaringClass()) || method.getParameterCount() > 1 && !method.isAnnotationPresent(NmsAddedIn.class) && !method.isAnnotationPresent(NmsRemovedIn.class) || (!method.getName().startsWith("set") || method.getParameterCount() != 1) && !method.getName().startsWith("get") && !method.getName().startsWith("has") && !method.getName().startsWith("is") || method.getName().equals("removePotionEffect") || LibsPremium.isPremium().booleanValue() && new Random().nextBoolean()) continue;
                int added = -1;
                int removed = -1;
                DisguiseType[] unusableBy = new DisguiseType[]{};
                if (method.isAnnotationPresent(NmsAddedIn.class)) {
                    added = method.getAnnotation(NmsAddedIn.class).value().ordinal();
                } else if (method.getDeclaringClass().isAnnotationPresent(NmsAddedIn.class)) {
                    added = method.getDeclaringClass().getAnnotation(NmsAddedIn.class).value().ordinal();
                }
                if (method.isAnnotationPresent(NmsRemovedIn.class)) {
                    removed = method.getAnnotation(NmsRemovedIn.class).value().ordinal();
                } else if (method.getDeclaringClass().isAnnotationPresent(NmsRemovedIn.class)) {
                    removed = method.getDeclaringClass().getAnnotation(NmsRemovedIn.class).value().ordinal();
                }
                if (method.isAnnotationPresent(MethodOnlyUsedBy.class)) {
                    DisguiseType[] usableBy = method.getAnnotation(MethodOnlyUsedBy.class).value();
                    if (usableBy.length == 0) {
                        usableBy = method.getAnnotation(MethodOnlyUsedBy.class).group().getDisguiseTypes();
                    }
                    List<DisguiseType> list = Arrays.asList(usableBy);
                    unusableBy = (DisguiseType[])Arrays.stream(DisguiseType.values()).filter(type -> !list.contains(type)).toArray(DisguiseType[]::new);
                } else if (method.isAnnotationPresent(MethodIgnoredBy.class) && (unusableBy = method.getAnnotation(MethodIgnoredBy.class).value()).length == 0) {
                    unusableBy = method.getAnnotation(MethodIgnoredBy.class).group().getDisguiseTypes();
                }
                String param = method.getParameterCount() == 1 ? method.getParameterTypes()[0].getName() : null;
                WatcherInfo info = new WatcherInfo();
                info.setMethod(method.getName());
                info.setAdded(added);
                info.setRemoved(removed);
                info.setUnusableBy(unusableBy);
                info.setDeprecated(method.isAnnotationPresent(Deprecated.class));
                info.setParam(param);
                info.setDescriptor(CompileMethods.getMethodDescriptor(method));
                info.setWatcher(method.getDeclaringClass().getSimpleName());
                info.setReturnType(method.getReturnType().getName());
                info.setRandomDefault(method.isAnnotationPresent(RandomDefaultValue.class));
                if (info.isRandomDefault() && !"void".equals(info.getReturnType())) {
                    throw new IllegalStateException("@RandomDefaultValue is intended for use only on setter methods, " + info.getMethod() + " on " + c.getSimpleName() + " does not met this criteria!");
                }
                String s = new Gson().toJson((Object)info);
                if (methods.contains(s)) continue;
                methods.add(s);
            }
        }
        File file = new File("plugin/target/classes/METHOD_MAPPINGS");
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(String.join((CharSequence)"\n", methods).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static String getDescriptorForClass(Class c) {
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized primitive " + c);
        }
        if (c.isArray()) {
            return c.getName().replace('.', '/');
        }
        return ('L' + c.getName() + ';').replace('.', '/');
    }

    static String getMethodDescriptor(Method m) {
        StringBuilder s = new StringBuilder("(");
        for (Class<?> c : m.getParameterTypes()) {
            s.append(CompileMethods.getDescriptorForClass(c));
        }
        return s.append(")") + CompileMethods.getDescriptorForClass(m.getReturnType());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CompileMethodsIntfer {
        public String user() default "%%__USER__%%";
    }
}

