/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LibsPackets {
    private final ArrayList<PacketContainer> packets = new ArrayList();
    private final HashMap<Integer, ArrayList<PacketContainer>> delayedPacketsMap = new HashMap();
    private final Disguise disguise;
    private boolean unhandled;
    private boolean skinHandling;

    public Disguise getDisguise() {
        return this.disguise;
    }

    public void addPacket(PacketContainer packet) {
        this.packets.add(packet);
    }

    public void addDelayedPacket(PacketContainer packet) {
        this.addDelayedPacket(packet, 2);
    }

    public void clear() {
        this.getPackets().clear();
    }

    public void addDelayedPacket(PacketContainer packet, int ticksDelayed) {
        if (!this.delayedPacketsMap.containsKey(ticksDelayed)) {
            this.delayedPacketsMap.put(ticksDelayed, new ArrayList());
        }
        this.delayedPacketsMap.get(ticksDelayed).add(packet);
    }

    public ArrayList<PacketContainer> getPackets() {
        return this.packets;
    }

    public void sendDelayed(Player observer) {
        for (Map.Entry<Integer, ArrayList<PacketContainer>> entry : this.getDelayedPacketsMap().entrySet()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                if (!this.getDisguise().isDisguiseInUse()) {
                    ArrayList packets = (ArrayList)entry.getValue();
                    if (packets.stream().noneMatch(p -> p.getType() == PacketType.Play.Server.PLAYER_INFO)) {
                        return;
                    }
                    packets.removeIf(p -> p.getType() != PacketType.Play.Server.PLAYER_INFO);
                }
                for (PacketContainer packet : (ArrayList)entry.getValue()) {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, packet.getType() == PacketType.Play.Server.ENTITY_EQUIPMENT);
                }
            }, (long)entry.getKey().intValue());
        }
    }

    private PacketContainer createPacket(EquipmentSlot slot) {
        ItemStack itemToSend = this.getDisguise().getWatcher().getItemStack(slot);
        if (itemToSend == null ? (itemToSend = ReflectionManager.getEquipment(slot, this.getDisguise().getEntity())) == null || itemToSend.getType() == Material.AIR : itemToSend.getType() == Material.AIR) {
            return null;
        }
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
        StructureModifier mods = packet.getModifier();
        mods.write(0, (Object)this.getDisguise().getEntity().getEntityId());
        if (NmsVersion.v1_16.isSupported()) {
            ArrayList<Pair> list = new ArrayList<Pair>();
            list.add(Pair.of((Object)ReflectionManager.createEnumItemSlot(slot), (Object)ReflectionManager.getNmsItem(itemToSend)));
            mods.write(1, list);
        } else {
            mods.write(1, (Object)ReflectionManager.createEnumItemSlot(slot));
            mods.write(2, ReflectionManager.getNmsItem(itemToSend));
        }
        return packet;
    }

    public HashMap<Integer, ArrayList<PacketContainer>> getDelayedPacketsMap() {
        return this.delayedPacketsMap;
    }

    public boolean isUnhandled() {
        return this.unhandled;
    }

    public boolean isSkinHandling() {
        return this.skinHandling;
    }

    public LibsPackets(Disguise disguise) {
        this.disguise = disguise;
    }

    public void setUnhandled(boolean unhandled) {
        this.unhandled = unhandled;
    }

    public void setSkinHandling(boolean skinHandling) {
        this.skinHandling = skinHandling;
    }
}

