/*
 * Decompiled with CFR 0.152.
 */
package libsdisg.shaded.net.kyori.adventure.text.minimessage;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import libsdisg.shaded.net.kyori.adventure.text.Component;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.Context;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.MiniMessage;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.MiniMessageParser;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.MiniMessageSerializer;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.transformation.TransformationRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MiniMessageImpl
implements MiniMessage {
    static final Consumer<List<String>> DEFAULT_ERROR_CONSUMER = message -> message.forEach(System.out::println);
    static final UnaryOperator<Component> DEFAULT_COMPACTING_METHOD = Component::compact;
    static final MiniMessage INSTANCE = new MiniMessageImpl(TransformationRegistry.standard(), TemplateResolver.empty(), false, null, DEFAULT_ERROR_CONSUMER, DEFAULT_COMPACTING_METHOD);
    private final boolean strict;
    private final Appendable debugOutput;
    private final Consumer<List<String>> parsingErrorMessageConsumer;
    private final UnaryOperator<Component> postProcessor;
    final MiniMessageParser parser;

    MiniMessageImpl(@NotNull TransformationRegistry registry, @NotNull TemplateResolver templateResolver, boolean strict, Appendable debugOutput, @NotNull Consumer<List<String>> parsingErrorMessageConsumer, @NotNull UnaryOperator<Component> postProcessor) {
        this.parser = new MiniMessageParser(registry, templateResolver);
        this.strict = strict;
        this.debugOutput = debugOutput;
        this.parsingErrorMessageConsumer = parsingErrorMessageConsumer;
        this.postProcessor = postProcessor;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String input) {
        return this.parser.parseFormat(input, this.newContext(input, null));
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String input, @NotNull TemplateResolver templateResolver) {
        return this.parser.parseFormat(input, this.newContext(input, Objects.requireNonNull(templateResolver, "templateResolver")));
    }

    @Override
    @NotNull
    public String serialize(@NotNull Component component) {
        return MiniMessageSerializer.serialize(component);
    }

    @Override
    @NotNull
    public String escapeTokens(@NotNull String input) {
        return this.parser.escapeTokens(input, this.newContext(input, null));
    }

    @Override
    @NotNull
    public String escapeTokens(@NotNull String input, @NotNull TemplateResolver templates) {
        return this.parser.escapeTokens(input, this.newContext(input, templates));
    }

    @Override
    @NotNull
    public String stripTokens(@NotNull String input) {
        return this.parser.stripTokens(input, this.newContext(input, null));
    }

    @Override
    @NotNull
    public String stripTokens(@NotNull String input, @NotNull TemplateResolver templates) {
        return this.parser.stripTokens(input, this.newContext(input, templates));
    }

    @NotNull
    private Context newContext(@NotNull String input, @Nullable TemplateResolver resolver) {
        if (resolver == null) {
            return Context.of(this.strict, this.debugOutput, input, this, TemplateResolver.empty(), this.postProcessor);
        }
        return Context.of(this.strict, this.debugOutput, input, this, resolver, this.postProcessor);
    }

    @NotNull
    public Consumer<List<String>> parsingErrorMessageConsumer() {
        return this.parsingErrorMessageConsumer;
    }

    @Override
    @NotNull
    public MiniMessage.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements MiniMessage.Builder {
        private TransformationRegistry registry = TransformationRegistry.standard();
        private TemplateResolver templateResolver = null;
        private boolean strict = false;
        private Appendable debug = null;
        private Consumer<List<String>> parsingErrorMessageConsumer = DEFAULT_ERROR_CONSUMER;
        private UnaryOperator<Component> postProcessor = DEFAULT_COMPACTING_METHOD;

        BuilderImpl() {
        }

        BuilderImpl(MiniMessageImpl serializer) {
            this.registry = serializer.parser.registry;
            this.templateResolver = serializer.parser.templateResolver;
            this.strict = serializer.strict;
            this.debug = serializer.debugOutput;
            this.parsingErrorMessageConsumer = serializer.parsingErrorMessageConsumer;
        }

        @Override
        @NotNull
        public MiniMessage.Builder transformations(@NotNull TransformationRegistry transformationRegistry) {
            this.registry = Objects.requireNonNull(transformationRegistry, "transformationRegistry");
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder transformations(@NotNull Consumer<TransformationRegistry.Builder> modifier) {
            TransformationRegistry.Builder builder = (TransformationRegistry.Builder)this.registry.toBuilder();
            modifier.accept(builder);
            this.registry = (TransformationRegistry)builder.build();
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder templateResolver(@Nullable TemplateResolver templateResolver) {
            this.templateResolver = templateResolver;
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder debug(@Nullable Appendable debugOutput) {
            this.debug = debugOutput;
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder parsingErrorMessageConsumer(@NotNull Consumer<List<String>> consumer) {
            this.parsingErrorMessageConsumer = Objects.requireNonNull(consumer, "consumer");
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder postProcessor(@NotNull UnaryOperator<Component> postProcessor) {
            this.postProcessor = Objects.requireNonNull(postProcessor, "postProcessor");
            return this;
        }

        @Override
        @NotNull
        public MiniMessage build() {
            return new MiniMessageImpl(this.registry, this.templateResolver == null ? TemplateResolver.empty() : this.templateResolver, this.strict, this.debug, this.parsingErrorMessageConsumer, this.postProcessor);
        }
    }
}

