/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.json;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import me.libraryaddict.disguise.disguisetypes.CustomDisguise;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;

public class SerializerDisguise
implements JsonDeserializer<Disguise>,
JsonSerializer<Disguise>,
InstanceCreator<Disguise> {
    public Disguise deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        TargetedDisguise disg;
        JsonObject obj = (JsonObject)json;
        DisguiseType type = DisguiseType.valueOf(obj.get("disguiseType").getAsString());
        if (type.isPlayer()) {
            disg = (TargetedDisguise)context.deserialize(json, PlayerDisguise.class);
        } else if (type.isMob()) {
            disg = (TargetedDisguise)context.deserialize(json, MobDisguise.class);
        } else if (type.isMisc()) {
            disg = (TargetedDisguise)context.deserialize(json, MiscDisguise.class);
        } else {
            return null;
        }
        try {
            Method method = FlagWatcher.class.getDeclaredMethod("setDisguise", TargetedDisguise.class);
            method.setAccessible(true);
            method.invoke((Object)disg.getWatcher(), disg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return disg;
    }

    public Disguise createInstance(Type type) {
        if (type == PlayerDisguise.class) {
            return new PlayerDisguise("SaveDisgError");
        }
        if (type == MobDisguise.class) {
            return new MobDisguise(DisguiseType.SHEEP);
        }
        if (type == MiscDisguise.class) {
            return new MiscDisguise(DisguiseType.BOAT);
        }
        return null;
    }

    public JsonElement serialize(Disguise src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.isCustomDisguise()) {
            return context.serialize((Object)src, CustomDisguise.class);
        }
        if (src.isPlayerDisguise()) {
            return context.serialize((Object)src, PlayerDisguise.class);
        }
        if (src.isMobDisguise()) {
            return context.serialize((Object)src, MobDisguise.class);
        }
        if (src.isMiscDisguise()) {
            return context.serialize((Object)src, MiscDisguise.class);
        }
        return null;
    }
}

