/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.disguise;

import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Disguise disguise;
        if (this.isNotPremium(sender)) {
            return true;
        }
        if (!(sender instanceof Entity)) {
            sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, this.getPermissions(sender));
            return true;
        }
        try {
            disguise = DisguiseParser.parseDisguise(sender, (Entity)sender, this.getPermNode(), DisguiseUtilities.split(StringUtils.join((Object[])args, (String)" ")), this.getPermissions(sender));
        }
        catch (DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        if (DisguiseConfig.isNameOfPlayerShownAboveDisguise() && !sender.hasPermission("libsdisguises.hidename") && disguise.getWatcher() instanceof LivingWatcher) {
            disguise.getWatcher().setCustomName(this.getDisplayName(sender));
            if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                disguise.getWatcher().setCustomNameVisible(true);
            }
        }
        disguise.setEntity((Entity)((Player)sender));
        if (!this.setViewDisguise(args) && DisguiseAPI.hasSelfDisguisePreference(disguise.getEntity()) && disguise.isSelfDisguiseVisible() == DisguiseConfig.isViewDisguises()) {
            disguise.setViewSelfDisguise(!disguise.isSelfDisguiseVisible());
        }
        disguise.startDisguise();
        if (disguise.isDisguiseInUse()) {
            sender.sendMessage(LibsMsg.DISGUISED.get(disguise.getDisguiseName()));
        } else {
            sender.sendMessage(LibsMsg.FAILED_DISGIUSE.get(disguise.getDisguiseName()));
        }
        return true;
    }

    private boolean setViewDisguise(String[] strings) {
        for (String string : strings) {
            if (!string.equalsIgnoreCase("setSelfDisguiseVisible")) continue;
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList tabs = new ArrayList();
        String[] args = this.getPreviousArgs(origArgs);
        DisguisePermissions perms = this.getPermissions(sender);
        return this.filterTabs(this.getTabDisguiseTypes(sender, perms, args, 0, this.getCurrentArg(origArgs)), origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, DisguisePermissions permissions) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(permissions);
        sender.sendMessage(LibsMsg.DISG_HELP1.get(new Object[0]));
        sender.sendMessage(LibsMsg.CAN_USE_DISGS.get(ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN))));
        if (allowedDisguises.contains("player")) {
            sender.sendMessage(LibsMsg.DISG_HELP2.get(new Object[0]));
        }
        sender.sendMessage(LibsMsg.DISG_HELP3.get(new Object[0]));
        if (allowedDisguises.contains("dropped_item") || allowedDisguises.contains("falling_block")) {
            sender.sendMessage(LibsMsg.DISG_HELP4.get(new Object[0]));
        }
    }
}

