/*
 * Decompiled with CFR 0.152.
 */
package net.cubespace.Yamler.Config;

import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigSection {
    private String fullPath;
    protected final Map<Object, Object> map = new LinkedHashMap<Object, Object>();

    public ConfigSection() {
        this.fullPath = "";
    }

    public ConfigSection(ConfigSection root, String key) {
        this.fullPath = !root.fullPath.equals("") ? root.fullPath + "." + key : key;
    }

    public ConfigSection create(String path) {
        int i2;
        if (path == null) {
            throw new IllegalArgumentException("Cannot create section at empty path");
        }
        int i1 = -1;
        ConfigSection section = this;
        while ((i1 = path.indexOf(46, i2 = i1 + 1)) != -1) {
            String node = path.substring(i2, i1);
            ConfigSection subSection = section.getConfigSection(node);
            if (subSection == null) {
                section = section.create(node);
                continue;
            }
            section = subSection;
        }
        String key = path.substring(i2);
        if (section == this) {
            ConfigSection result = new ConfigSection(this, key);
            this.map.put(key, result);
            return result;
        }
        return section.create(key);
    }

    private ConfigSection getConfigSection(String node) {
        return this.map.containsKey(node) && this.map.get(node) instanceof ConfigSection ? (ConfigSection)this.map.get(node) : null;
    }

    public void set(String path, Object value) {
        this.set(path, value, true);
    }

    public void set(String path, Object value, boolean searchForSubNodes) {
        if (path == null) {
            throw new IllegalArgumentException("Cannot set a value at empty path");
        }
        int i1 = -1;
        int i2 = 0;
        ConfigSection section = this;
        if (searchForSubNodes) {
            while ((i1 = path.indexOf(46, i2 = i1 + 1)) != -1) {
                String node = path.substring(i2, i1);
                ConfigSection subSection = section.getConfigSection(node);
                if (subSection == null) {
                    section = section.create(node);
                    continue;
                }
                section = subSection;
            }
        }
        String key = path.substring(i2);
        if (section == this) {
            if (value == null) {
                this.map.remove(key);
            } else {
                this.map.put(key, value);
            }
        } else {
            section.set(key, value);
        }
    }

    protected void mapChildrenValues(Map<Object, Object> output, ConfigSection section, boolean deep) {
        if (section != null) {
            for (Map.Entry<Object, Object> entry : section.map.entrySet()) {
                if (entry.getValue() instanceof ConfigSection) {
                    LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
                    output.put(entry.getKey(), result);
                    if (!deep) continue;
                    this.mapChildrenValues(result, (ConfigSection)entry.getValue(), true);
                    continue;
                }
                output.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<Object, Object> getValues(boolean deep) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        this.mapChildrenValues(result, this, deep);
        return result;
    }

    public void remove(String path) {
        this.set(path, null);
    }

    public boolean has(String path) {
        int i2;
        if (path == null) {
            throw new IllegalArgumentException("Cannot remove a Value at empty path");
        }
        int i1 = -1;
        ConfigSection section = this;
        while ((i1 = path.indexOf(46, i2 = i1 + 1)) != -1) {
            String node = path.substring(i2, i1);
            ConfigSection subSection = section.getConfigSection(node);
            if (subSection == null) {
                return false;
            }
            section = subSection;
        }
        String key = path.substring(i2);
        if (section == this) {
            return this.map.containsKey(key);
        }
        return section.has(key);
    }

    public <T> T get(String path) {
        int i2;
        if (path == null) {
            throw new IllegalArgumentException("Cannot remove a Value at empty path");
        }
        int i1 = -1;
        ConfigSection section = this;
        while ((i1 = path.indexOf(46, i2 = i1 + 1)) != -1) {
            String node = path.substring(i2, i1);
            ConfigSection subSection = section.getConfigSection(node);
            if (subSection == null) {
                section = section.create(node);
                continue;
            }
            section = subSection;
        }
        String key = path.substring(i2);
        if (section == this) {
            return (T)this.map.get(key);
        }
        return section.get(key);
    }

    public Map getRawMap() {
        return this.map;
    }

    public static ConfigSection convertFromMap(Map config) {
        ConfigSection configSection = new ConfigSection();
        configSection.map.putAll(config);
        return configSection;
    }
}

