/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.util;

import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisDataException;
import java.beans.ConstructorProperties;
import java.util.List;

public class LuaManager {
    private final RedisBungee plugin;

    public Script createScript(String script) {
        try (Jedis jedis = this.plugin.getPool().getResource();){
            String hash = jedis.scriptLoad(script);
            Script script2 = new Script(script, hash);
            return script2;
        }
    }

    @ConstructorProperties(value={"plugin"})
    public LuaManager(RedisBungee plugin) {
        this.plugin = plugin;
    }

    public class Script {
        private final String script;
        private final String hashed;

        public Object eval(List<String> keys, List<String> args) {
            Object data;
            block15: {
                try (Jedis jedis = LuaManager.this.plugin.getPool().getResource();){
                    try {
                        data = jedis.evalsha(this.hashed, keys, args);
                    }
                    catch (JedisDataException e) {
                        if (e.getMessage().startsWith("NOSCRIPT")) {
                            data = jedis.eval(this.script, keys, args);
                            break block15;
                        }
                        throw e;
                    }
                }
            }
            return data;
        }

        @ConstructorProperties(value={"script", "hashed"})
        public Script(String script, String hashed) {
            this.script = script;
            this.hashed = hashed;
        }
    }
}

