/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.common.annotations.VisibleForTesting;
import com.imaginarycode.minecraft.redisbungee.DataManager;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Pipeline;
import java.util.HashMap;
import java.util.UUID;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;

@VisibleForTesting
public class RedisUtil {
    protected static void createPlayer(ProxiedPlayer player, Pipeline pipeline, boolean fireEvent) {
        RedisUtil.createPlayer(player.getPendingConnection(), pipeline, fireEvent);
        if (player.getServer() != null) {
            pipeline.hset("player:" + player.getUniqueId().toString(), "server", player.getServer().getInfo().getName());
        }
    }

    protected static void createPlayer(PendingConnection connection, Pipeline pipeline, boolean fireEvent) {
        HashMap<String, String> playerData = new HashMap<String, String>(4);
        playerData.put("online", "0");
        playerData.put("ip", connection.getAddress().getAddress().getHostAddress());
        playerData.put("proxy", RedisBungee.getConfiguration().getServerId());
        pipeline.sadd("proxy:" + RedisBungee.getApi().getServerId() + ":usersOnline", connection.getUniqueId().toString());
        pipeline.hmset("player:" + connection.getUniqueId().toString(), playerData);
        if (fireEvent) {
            pipeline.publish("redisbungee-data", RedisBungee.getGson().toJson(new DataManager.DataManagerMessage<DataManager.LoginPayload>(connection.getUniqueId(), DataManager.DataManagerMessage.Action.JOIN, new DataManager.LoginPayload(connection.getAddress().getAddress()))));
        }
    }

    public static void cleanUpPlayer(String player, Jedis rsc) {
        rsc.srem("proxy:" + RedisBungee.getApi().getServerId() + ":usersOnline", player);
        rsc.hdel("player:" + player, "server");
        rsc.hdel("player:" + player, "ip");
        rsc.hdel("player:" + player, "proxy");
        long timestamp = System.currentTimeMillis();
        rsc.hset("player:" + player, "online", String.valueOf(timestamp));
        rsc.publish("redisbungee-data", RedisBungee.getGson().toJson(new DataManager.DataManagerMessage<DataManager.LogoutPayload>(UUID.fromString(player), DataManager.DataManagerMessage.Action.LEAVE, new DataManager.LogoutPayload(timestamp))));
    }

    public static void cleanUpPlayer(String player, Pipeline rsc) {
        rsc.srem("proxy:" + RedisBungee.getApi().getServerId() + ":usersOnline", player);
        rsc.hdel("player:" + player, "server");
        rsc.hdel("player:" + player, "ip");
        rsc.hdel("player:" + player, "proxy");
        long timestamp = System.currentTimeMillis();
        rsc.hset("player:" + player, "online", String.valueOf(timestamp));
        rsc.publish("redisbungee-data", RedisBungee.getGson().toJson(new DataManager.DataManagerMessage<DataManager.LogoutPayload>(UUID.fromString(player), DataManager.DataManagerMessage.Action.LEAVE, new DataManager.LogoutPayload(timestamp))));
    }

    public static boolean canUseLua(String redisVersion) {
        String[] args = redisVersion.split("\\.");
        if (args.length < 2) {
            return false;
        }
        int major = Integer.parseInt(args[0]);
        int minor = Integer.parseInt(args[1]);
        return major >= 3 || major == 2 && minor >= 6;
    }

    private RedisUtil() {
    }
}

