/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.imaginarycode.minecraft.redisbungee.DataManager;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeCommandSender;
import com.imaginarycode.minecraft.redisbungee.RedisUtil;
import com.imaginarycode.minecraft.redisbungee.events.PubSubMessageEvent;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Pipeline;
import com.imaginarycode.minecraft.redisbungee.util.RedisCallable;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class RedisBungeeListener
implements Listener {
    private static final BaseComponent[] ALREADY_LOGGED_IN = new ComponentBuilder("You are already logged on to this server.").color(ChatColor.RED).append("\n\nIt may help to try logging in again in a few minutes.\nIf this does not resolve your issue, please contact staff.").color(ChatColor.GRAY).create();
    private static final BaseComponent[] ONLINE_MODE_RECONNECT = new ComponentBuilder("Whoops! You need to reconnect.").color(ChatColor.RED).append("\n\nWe found someone online using your username. They were kicked and you may reconnect.\nIf this does not work, please contact staff.").color(ChatColor.GRAY).create();
    private final RedisBungee plugin;
    private final List<InetAddress> exemptAddresses;
    private static final List<String> ASYNC_PING_EVENT_HOSTILE = ImmutableList.of((Object)"ServerListPlus");

    @EventHandler(priority=-64)
    public void onLogin(final LoginEvent event) {
        event.registerIntent((Plugin)this.plugin);
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, (Runnable)new RedisCallable<Void>(this.plugin){

            @Override
            protected Void call(Jedis jedis) {
                ProxiedPlayer player;
                if (event.isCancelled()) {
                    event.completeIntent((Plugin)RedisBungeeListener.this.plugin);
                    return null;
                }
                if (RedisBungeeListener.this.plugin.getProxy().getConfig().isOnlineMode() && (player = RedisBungeeListener.this.plugin.getProxy().getPlayer(event.getConnection().getName())) != null) {
                    event.setCancelled(true);
                    event.setCancelReason(TextComponent.toLegacyText((BaseComponent[])ONLINE_MODE_RECONNECT));
                    event.completeIntent((Plugin)RedisBungeeListener.this.plugin);
                    return null;
                }
                for (String s : RedisBungeeListener.this.plugin.getServerIds()) {
                    if (!jedis.sismember("proxy:" + s + ":usersOnline", event.getConnection().getUniqueId().toString()).booleanValue()) continue;
                    event.setCancelled(true);
                    event.setCancelReason(TextComponent.toLegacyText((BaseComponent[])ALREADY_LOGGED_IN));
                    event.completeIntent((Plugin)RedisBungeeListener.this.plugin);
                    return null;
                }
                Pipeline pipeline = jedis.pipelined();
                RedisBungeeListener.this.plugin.getUuidTranslator().persistInfo(event.getConnection().getName(), event.getConnection().getUniqueId(), pipeline);
                RedisUtil.createPlayer(event.getConnection(), pipeline, false);
                pipeline.sync();
                event.completeIntent((Plugin)RedisBungeeListener.this.plugin);
                return null;
            }
        });
    }

    @EventHandler
    public void onPostLogin(final PostLoginEvent event) {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, (Runnable)new RedisCallable<Void>(this.plugin){

            @Override
            protected Void call(Jedis jedis) {
                jedis.publish("redisbungee-data", RedisBungee.getGson().toJson(new DataManager.DataManagerMessage<DataManager.LoginPayload>(event.getPlayer().getUniqueId(), DataManager.DataManagerMessage.Action.JOIN, new DataManager.LoginPayload(event.getPlayer().getAddress().getAddress()))));
                return null;
            }
        });
    }

    @EventHandler
    public void onPlayerDisconnect(final PlayerDisconnectEvent event) {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, (Runnable)new RedisCallable<Void>(this.plugin){

            @Override
            protected Void call(Jedis jedis) {
                Pipeline pipeline = jedis.pipelined();
                RedisUtil.cleanUpPlayer(event.getPlayer().getUniqueId().toString(), pipeline);
                pipeline.sync();
                return null;
            }
        });
    }

    @EventHandler
    public void onServerChange(final ServerConnectedEvent event) {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, (Runnable)new RedisCallable<Void>(this.plugin){

            @Override
            protected Void call(Jedis jedis) {
                jedis.hset("player:" + event.getPlayer().getUniqueId().toString(), "server", event.getServer().getInfo().getName());
                jedis.publish("redisbungee-data", RedisBungee.getGson().toJson(new DataManager.DataManagerMessage<DataManager.ServerChangePayload>(event.getPlayer().getUniqueId(), DataManager.DataManagerMessage.Action.SERVER_CHANGE, new DataManager.ServerChangePayload(event.getServer().getInfo().getName()))));
                return null;
            }
        });
    }

    @EventHandler(priority=-64)
    public void onPing(final ProxyPingEvent event) {
        if (this.exemptAddresses.contains(event.getConnection().getAddress().getAddress())) {
            return;
        }
        ServerInfo forced = AbstractReconnectHandler.getForcedHost((PendingConnection)event.getConnection());
        if (forced != null && event.getConnection().getListener().isPingPassthrough()) {
            return;
        }
        boolean runAsync = true;
        for (String s : ASYNC_PING_EVENT_HOSTILE) {
            if (ProxyServer.getInstance().getPluginManager().getPlugin(s) == null) continue;
            runAsync = false;
            break;
        }
        if (runAsync) {
            event.registerIntent((Plugin)this.plugin);
            this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ServerPing old = event.getResponse();
                    ServerPing reply = new ServerPing();
                    reply.setPlayers(new ServerPing.Players(old.getPlayers().getMax(), RedisBungeeListener.this.plugin.getCount(), old.getPlayers().getSample()));
                    reply.setDescription(old.getDescription());
                    reply.setFavicon(old.getFaviconObject());
                    reply.setVersion(old.getVersion());
                    event.setResponse(reply);
                    event.completeIntent((Plugin)RedisBungeeListener.this.plugin);
                }
            });
        } else {
            ServerPing old = event.getResponse();
            ServerPing reply = new ServerPing();
            reply.setPlayers(new ServerPing.Players(old.getPlayers().getMax(), this.plugin.getCount(), old.getPlayers().getSample()));
            reply.setDescription(old.getDescription());
            reply.setFavicon(old.getFaviconObject());
            reply.setVersion(old.getVersion());
            event.setResponse(reply);
        }
    }

    @EventHandler
    public void onPluginMessage(final PluginMessageEvent event) {
        if (event.getTag().equals("RedisBungee") && event.getSender() instanceof Server) {
            final byte[] data = Arrays.copyOf(event.getData(), event.getData().length);
            this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
                    String subchannel = in.readUTF();
                    ByteArrayDataOutput out = ByteStreams.newDataOutput();
                    switch (subchannel) {
                        case "PlayerList": {
                            out.writeUTF("PlayerList");
                            Set<Object> original = Collections.emptySet();
                            String type = in.readUTF();
                            if (type.equals("ALL")) {
                                out.writeUTF("ALL");
                                original = RedisBungeeListener.this.plugin.getPlayers();
                            } else {
                                try {
                                    original = RedisBungeeListener.this.plugin.getPlayersOnServer(type);
                                }
                                catch (IllegalArgumentException ignored) {
                                    // empty catch block
                                }
                            }
                            HashSet<String> players = new HashSet<String>();
                            for (UUID uUID : original) {
                                players.add(RedisBungeeListener.this.plugin.getUuidTranslator().getNameFromUuid(uUID, false));
                            }
                            out.writeUTF(Joiner.on((char)',').join(players));
                            break;
                        }
                        case "PlayerCount": {
                            out.writeUTF("PlayerCount");
                            String type = in.readUTF();
                            if (type.equals("ALL")) {
                                out.writeUTF("ALL");
                                out.writeInt(RedisBungeeListener.this.plugin.getCount());
                                break;
                            }
                            out.writeUTF(type);
                            try {
                                out.writeInt(RedisBungeeListener.this.plugin.getPlayersOnServer(type).size());
                            }
                            catch (IllegalArgumentException e) {
                                out.writeInt(0);
                            }
                            break;
                        }
                        case "LastOnline": {
                            String user = in.readUTF();
                            out.writeUTF("LastOnline");
                            out.writeUTF(user);
                            out.writeLong(RedisBungee.getApi().getLastOnline(RedisBungeeListener.this.plugin.getUuidTranslator().getTranslatedUuid(user, true)));
                            break;
                        }
                        case "ServerPlayers": {
                            boolean includesUsers;
                            String string = in.readUTF();
                            out.writeUTF("ServerPlayers");
                            Multimap<String, UUID> multimap = RedisBungee.getApi().getServerToPlayers();
                            switch (string) {
                                case "COUNT": {
                                    includesUsers = false;
                                    break;
                                }
                                case "PLAYERS": {
                                    includesUsers = true;
                                    break;
                                }
                                default: {
                                    return;
                                }
                            }
                            out.writeUTF(string);
                            if (includesUsers) {
                                HashMultimap human = HashMultimap.create();
                                for (Map.Entry entry : multimap.entries()) {
                                    human.put(entry.getKey(), (Object)RedisBungeeListener.this.plugin.getUuidTranslator().getNameFromUuid((UUID)entry.getValue(), false));
                                }
                                RedisBungeeListener.this.serializeMultimap((Multimap<String, String>)((Multimap)human), true, out);
                                break;
                            }
                            HashMultimap flunk = HashMultimap.create();
                            for (Map.Entry entry : multimap.entries()) {
                                flunk.put(entry.getKey(), (Object)((UUID)entry.getValue()).toString());
                            }
                            RedisBungeeListener.this.serializeMultimap((Multimap<String, String>)((Multimap)flunk), false, out);
                            break;
                        }
                        case "Proxy": {
                            out.writeUTF("Proxy");
                            out.writeUTF(RedisBungee.getConfiguration().getServerId());
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    ((Server)event.getSender()).sendData("RedisBungee", out.toByteArray());
                }
            });
        }
    }

    private void serializeMultimap(Multimap<String, String> collection, boolean includeNames, ByteArrayDataOutput output) {
        output.writeInt(collection.size());
        for (Map.Entry entry : collection.asMap().entrySet()) {
            output.writeUTF((String)entry.getKey());
            if (includeNames) {
                this.serializeCollection((Collection)entry.getValue(), output);
                continue;
            }
            output.writeInt(((Collection)entry.getValue()).size());
        }
    }

    private void serializeCollection(Collection<?> collection, ByteArrayDataOutput output) {
        output.writeInt(collection.size());
        for (Object o : collection) {
            output.writeUTF(o.toString());
        }
    }

    @EventHandler
    public void onPubSubMessage(PubSubMessageEvent event) {
        if (event.getChannel().equals("redisbungee-allservers") || event.getChannel().equals("redisbungee-" + RedisBungee.getApi().getServerId())) {
            String message = event.getMessage();
            if (message.startsWith("/")) {
                message = message.substring(1);
            }
            this.plugin.getLogger().info("Invoking command via PubSub: /" + message);
            this.plugin.getProxy().getPluginManager().dispatchCommand((CommandSender)RedisBungeeCommandSender.instance, message);
        }
    }

    @ConstructorProperties(value={"plugin", "exemptAddresses"})
    public RedisBungeeListener(RedisBungee plugin, List<InetAddress> exemptAddresses) {
        this.plugin = plugin;
        this.exemptAddresses = exemptAddresses;
    }
}

