/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.common.net.InetAddresses;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.events.PlayerChangedServerNetworkEvent;
import com.imaginarycode.minecraft.redisbungee.events.PlayerJoinedNetworkEvent;
import com.imaginarycode.minecraft.redisbungee.events.PlayerLeftNetworkEvent;
import com.imaginarycode.minecraft.redisbungee.events.PubSubMessageEvent;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.util.InternalCache;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class DataManager
implements Listener {
    private final RedisBungee plugin;
    private final InternalCache<UUID, String> serverCache = DataManager.createCache();
    private final InternalCache<UUID, String> proxyCache = DataManager.createCache(TimeUnit.MINUTES.toMillis(60L));
    private final InternalCache<UUID, InetAddress> ipCache = DataManager.createCache(TimeUnit.MINUTES.toMillis(60L));
    private final InternalCache<UUID, Long> lastOnlineCache = DataManager.createCache(TimeUnit.MINUTES.toMillis(60L));
    private final JsonParser parser = new JsonParser();

    public DataManager(RedisBungee plugin) {
        this.plugin = plugin;
        plugin.getProxy().getScheduler().schedule((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                DataManager.this.proxyCache.cleanup();
                DataManager.this.ipCache.cleanup();
                DataManager.this.lastOnlineCache.cleanup();
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private static <K, V> InternalCache<K, V> createCache() {
        return new InternalCache();
    }

    private static <K, V> InternalCache<K, V> createCache(long entryWriteExpiry) {
        return new InternalCache(entryWriteExpiry);
    }

    public String getServer(final UUID uuid) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(uuid);
        if (player != null) {
            return player.getServer() != null ? player.getServer().getInfo().getName() : null;
        }
        try {
            return this.serverCache.get(uuid, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    try (Jedis tmpRsc = DataManager.this.plugin.getPool().getResource();){
                        String string = tmpRsc.hget("player:" + uuid, "server");
                        return string;
                    }
                }
            });
        }
        catch (ExecutionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to get server", e);
            throw new RuntimeException("Unable to get server for " + uuid, e);
        }
    }

    public String getProxy(final UUID uuid) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(uuid);
        if (player != null) {
            return RedisBungee.getConfiguration().getServerId();
        }
        try {
            return this.proxyCache.get(uuid, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    try (Jedis tmpRsc = DataManager.this.plugin.getPool().getResource();){
                        String string = tmpRsc.hget("player:" + uuid, "proxy");
                        return string;
                    }
                }
            });
        }
        catch (ExecutionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to get proxy", e);
            throw new RuntimeException("Unable to get proxy for " + uuid, e);
        }
    }

    public InetAddress getIp(final UUID uuid) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(uuid);
        if (player != null) {
            return player.getAddress().getAddress();
        }
        try {
            return this.ipCache.get(uuid, new Callable<InetAddress>(){

                @Override
                public InetAddress call() throws Exception {
                    try (Jedis tmpRsc = DataManager.this.plugin.getPool().getResource();){
                        String result = tmpRsc.hget("player:" + uuid, "ip");
                        InetAddress inetAddress = result == null ? null : InetAddresses.forString((String)result);
                        return inetAddress;
                    }
                }
            });
        }
        catch (ExecutionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to get IP", e);
            throw new RuntimeException("Unable to get IP for " + uuid, e);
        }
    }

    public long getLastOnline(final UUID uuid) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(uuid);
        if (player != null) {
            return 0L;
        }
        try {
            return this.lastOnlineCache.get(uuid, new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    try (Jedis tmpRsc = DataManager.this.plugin.getPool().getResource();){
                        String result = tmpRsc.hget("player:" + uuid, "online");
                        Long l = result == null ? -1L : Long.valueOf(result);
                        return l;
                    }
                }
            });
        }
        catch (ExecutionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to get last time online", e);
            throw new RuntimeException("Unable to get last time online for " + uuid, e);
        }
    }

    private void invalidate(UUID uuid) {
        this.ipCache.invalidate(uuid);
        this.lastOnlineCache.invalidate(uuid);
        this.serverCache.invalidate(uuid);
        this.proxyCache.invalidate(uuid);
    }

    @EventHandler
    public void onPostLogin(PostLoginEvent event) {
        this.invalidate(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        this.invalidate(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPubSubMessage(PubSubMessageEvent event) {
        if (!event.getChannel().equals("redisbungee-data")) {
            return;
        }
        JsonObject jsonObject = this.parser.parse(event.getMessage()).getAsJsonObject();
        String source = jsonObject.get("source").getAsString();
        if (source.equals(RedisBungee.getConfiguration().getServerId())) {
            return;
        }
        DataManagerMessage.Action action = DataManagerMessage.Action.valueOf(jsonObject.get("action").getAsString());
        switch (action) {
            case JOIN: {
                final DataManagerMessage message1 = (DataManagerMessage)RedisBungee.getGson().fromJson((JsonElement)jsonObject, new TypeToken<DataManagerMessage<LoginPayload>>(){}.getType());
                this.proxyCache.put(message1.getTarget(), message1.getSource());
                this.lastOnlineCache.put(message1.getTarget(), 0L);
                this.ipCache.put(message1.getTarget(), ((LoginPayload)message1.getPayload()).getAddress());
                this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        DataManager.this.plugin.getProxy().getPluginManager().callEvent((Event)new PlayerJoinedNetworkEvent(message1.getTarget()));
                    }
                });
                break;
            }
            case LEAVE: {
                final DataManagerMessage message2 = (DataManagerMessage)RedisBungee.getGson().fromJson((JsonElement)jsonObject, new TypeToken<DataManagerMessage<LogoutPayload>>(){}.getType());
                this.invalidate(message2.getTarget());
                this.lastOnlineCache.put(message2.getTarget(), ((LogoutPayload)message2.getPayload()).getTimestamp());
                this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        DataManager.this.plugin.getProxy().getPluginManager().callEvent((Event)new PlayerLeftNetworkEvent(message2.getTarget()));
                    }
                });
                break;
            }
            case SERVER_CHANGE: {
                final DataManagerMessage message3 = (DataManagerMessage)RedisBungee.getGson().fromJson((JsonElement)jsonObject, new TypeToken<DataManagerMessage<ServerChangePayload>>(){}.getType());
                final String oldServer = this.serverCache.put(message3.getTarget(), ((ServerChangePayload)message3.getPayload()).getServer());
                this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        DataManager.this.plugin.getProxy().getPluginManager().callEvent((Event)new PlayerChangedServerNetworkEvent(message3.getTarget(), oldServer, ((ServerChangePayload)message3.getPayload()).getServer()));
                    }
                });
            }
        }
    }

    static class LogoutPayload {
        private final long timestamp;

        public long getTimestamp() {
            return this.timestamp;
        }

        @ConstructorProperties(value={"timestamp"})
        public LogoutPayload(long timestamp) {
            this.timestamp = timestamp;
        }
    }

    static class ServerChangePayload {
        private final String server;

        public String getServer() {
            return this.server;
        }

        @ConstructorProperties(value={"server"})
        public ServerChangePayload(String server) {
            this.server = server;
        }
    }

    static class LoginPayload {
        private final InetAddress address;

        public InetAddress getAddress() {
            return this.address;
        }

        @ConstructorProperties(value={"address"})
        public LoginPayload(InetAddress address) {
            this.address = address;
        }
    }

    static class DataManagerMessage<T> {
        private final UUID target;
        private final String source = RedisBungee.getApi().getServerId();
        private final Action action;
        private final T payload;

        public UUID getTarget() {
            return this.target;
        }

        public String getSource() {
            return this.source;
        }

        public Action getAction() {
            return this.action;
        }

        public T getPayload() {
            return this.payload;
        }

        @ConstructorProperties(value={"target", "action", "payload"})
        public DataManagerMessage(UUID target, Action action, T payload) {
            this.target = target;
            this.action = action;
            this.payload = payload;
        }

        static enum Action {
            JOIN,
            LEAVE,
            SERVER_CHANGE;

        }
    }
}

