/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.internal.jedis;

import com.imaginarycode.minecraft.redisbungee.internal.jedis.HostAndPort;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisClusterConnectionHandler;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisPool;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisConnectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JedisSlotBasedConnectionHandler
extends JedisClusterConnectionHandler {
    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes) {
        super(nodes);
    }

    @Override
    public Jedis getConnection() {
        List<JedisPool> pools = this.getShuffledNodesPool();
        for (JedisPool pool : pools) {
            Jedis jedis = null;
            try {
                jedis = pool.getResource();
                if (jedis == null) continue;
                String result = jedis.ping();
                if (result.equalsIgnoreCase("pong")) {
                    return jedis;
                }
                pool.returnBrokenResource(jedis);
            }
            catch (JedisConnectionException ex) {
                if (jedis == null) continue;
                pool.returnBrokenResource(jedis);
            }
        }
        throw new JedisConnectionException("no reachable node in cluster");
    }

    @Override
    public void assignSlotToNode(int slot, HostAndPort targetNode) {
        super.assignSlotToNode(slot, targetNode);
    }

    @Override
    public Jedis getConnectionFromSlot(int slot) {
        JedisPool connectionPool = (JedisPool)this.slots.get(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        return this.getConnection();
    }

    private List<JedisPool> getShuffledNodesPool() {
        ArrayList<JedisPool> pools = new ArrayList<JedisPool>();
        pools.addAll(this.nodes.values());
        Collections.shuffle(pools);
        return pools;
    }
}

