/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.internal.jedis;

import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisClusterConnectionHandler;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisAskDataException;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisClusterException;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisClusterMaxRedirectionsException;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisConnectionException;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisMovedDataException;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisRedirectionException;
import com.imaginarycode.minecraft.redisbungee.internal.jedisutil.JedisClusterCRC16;

public abstract class JedisClusterCommand<T> {
    private JedisClusterConnectionHandler connectionHandler;
    private int commandTimeout;
    private int redirections;

    public JedisClusterCommand(JedisClusterConnectionHandler connectionHandler, int timeout, int maxRedirections) {
        this.connectionHandler = connectionHandler;
        this.commandTimeout = timeout;
        this.redirections = maxRedirections;
    }

    public abstract T execute(Jedis var1);

    public T run(String key) {
        if (key == null) {
            throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
        }
        return this.runWithRetries(key, this.redirections, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T runWithRetries(String key, int redirections, boolean tryRandomNode, boolean asking) {
        if (redirections <= 0) {
            throw new JedisClusterMaxRedirectionsException("Too many Cluster redirections?");
        }
        Jedis connection = null;
        try {
            connection = tryRandomNode ? this.connectionHandler.getConnection() : this.connectionHandler.getConnectionFromSlot(JedisClusterCRC16.getSlot(key));
            if (asking) {
                connection.asking();
                asking = false;
            }
            T t = this.execute(connection);
            return t;
        }
        catch (JedisConnectionException jce) {
            if (tryRandomNode) {
                throw jce;
            }
            this.releaseConnection(connection, true);
            connection = null;
            T t = this.runWithRetries(key, redirections--, true, asking);
            return t;
        }
        catch (JedisRedirectionException jre) {
            if (jre instanceof JedisAskDataException) {
                asking = true;
            } else if (jre instanceof JedisMovedDataException) {
                // empty if block
            }
            this.connectionHandler.assignSlotToNode(jre.getSlot(), jre.getTargetNode());
            this.releaseConnection(connection, false);
            connection = null;
            T t = this.runWithRetries(key, redirections - 1, false, asking);
            return t;
        }
        finally {
            this.releaseConnection(connection, false);
        }
    }

    private void releaseConnection(Jedis connection, boolean broken) {
        if (connection != null) {
            if (broken) {
                this.connectionHandler.returnBrokenConnection(connection);
            } else {
                this.connectionHandler.returnConnection(connection);
            }
        }
    }
}

