/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.internal.jedis;

import com.imaginarycode.minecraft.redisbungee.internal.jedis.AdvancedBinaryJedisCommands;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.BasicCommands;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.BinaryClient;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.BinaryJedisCommands;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.BinaryJedisPubSub;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.BinaryScriptingCommands;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.BitOP;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.BitPosParams;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Client;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.DebugParams;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisMonitor;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisShardInfo;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.MultiKeyBinaryCommands;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Pipeline;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.PipelineBlock;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Protocol;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.ScanParams;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.ScanResult;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.SortingParams;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Transaction;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.TransactionBlock;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Tuple;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.ZParams;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisDataException;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisException;
import com.imaginarycode.minecraft.redisbungee.internal.jedisutil.JedisByteHashMap;
import com.imaginarycode.minecraft.redisbungee.internal.jedisutil.SafeEncoder;
import java.io.Closeable;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BinaryJedis
implements BasicCommands,
BinaryJedisCommands,
MultiKeyBinaryCommands,
AdvancedBinaryJedisCommands,
BinaryScriptingCommands,
Closeable {
    protected Client client = null;

    public BinaryJedis(String host) {
        URI uri = URI.create(host);
        if (uri.getScheme() != null && uri.getScheme().equals("redis")) {
            this.client = new Client(uri.getHost(), uri.getPort());
            this.client.auth(uri.getUserInfo().split(":", 2)[1]);
            this.client.getStatusCodeReply();
            this.client.select(Integer.parseInt(uri.getPath().split("/", 2)[1]));
            this.client.getStatusCodeReply();
        } else {
            this.client = new Client(host);
        }
    }

    public BinaryJedis(String host, int port) {
        this.client = new Client(host, port);
    }

    public BinaryJedis(String host, int port, int timeout) {
        this.client = new Client(host, port);
        this.client.setTimeout(timeout);
    }

    public BinaryJedis(JedisShardInfo shardInfo) {
        this.client = new Client(shardInfo.getHost(), shardInfo.getPort());
        this.client.setTimeout(shardInfo.getTimeout());
        this.client.setPassword(shardInfo.getPassword());
    }

    public BinaryJedis(URI uri) {
        this.client = new Client(uri.getHost(), uri.getPort());
        this.client.auth(uri.getUserInfo().split(":", 2)[1]);
        this.client.getStatusCodeReply();
        this.client.select(Integer.parseInt(uri.getPath().split("/", 2)[1]));
        this.client.getStatusCodeReply();
    }

    @Override
    public String ping() {
        this.checkIsInMulti();
        this.client.ping();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(byte[] key, byte[] value) {
        this.checkIsInMulti();
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        this.checkIsInMulti();
        this.client.set(key, value, nxxx, expx, time);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] get(byte[] key) {
        this.checkIsInMulti();
        this.client.get(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String quit() {
        this.checkIsInMulti();
        this.client.quit();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Boolean exists(byte[] key) {
        this.checkIsInMulti();
        this.client.exists(key);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long del(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long del(byte[] key) {
        this.checkIsInMulti();
        this.client.del(new byte[][]{key});
        return this.client.getIntegerReply();
    }

    @Override
    public String type(byte[] key) {
        this.checkIsInMulti();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String flushDB() {
        this.checkIsInMulti();
        this.client.flushDB();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        this.checkIsInMulti();
        this.client.keys(pattern);
        HashSet<byte[]> keySet = new HashSet<byte[]>(this.client.getBinaryMultiBulkReply());
        return keySet;
    }

    @Override
    public byte[] randomBinaryKey() {
        this.checkIsInMulti();
        this.client.randomKey();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String rename(byte[] oldkey, byte[] newkey) {
        this.checkIsInMulti();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long renamenx(byte[] oldkey, byte[] newkey) {
        this.checkIsInMulti();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long dbSize() {
        this.checkIsInMulti();
        this.client.dbSize();
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(byte[] key, int seconds) {
        this.checkIsInMulti();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        this.checkIsInMulti();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(byte[] key) {
        this.checkIsInMulti();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String select(int index) {
        this.checkIsInMulti();
        this.client.select(index);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long move(byte[] key, int dbIndex) {
        this.checkIsInMulti();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    @Override
    public String flushAll() {
        this.checkIsInMulti();
        this.client.flushAll();
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        this.checkIsInMulti();
        this.client.getSet(key, value);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.mget(keys);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        this.checkIsInMulti();
        this.client.setnx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(byte[] key, int seconds, byte[] value) {
        this.checkIsInMulti();
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String mset(byte[] ... keysvalues) {
        this.checkIsInMulti();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long msetnx(byte[] ... keysvalues) {
        this.checkIsInMulti();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(byte[] key, long integer) {
        this.checkIsInMulti();
        this.client.decrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(byte[] key) {
        this.checkIsInMulti();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(byte[] key, long integer) {
        this.checkIsInMulti();
        this.client.incrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Double incrByFloat(byte[] key, double integer) {
        this.checkIsInMulti();
        this.client.incrByFloat(key, integer);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Long incr(byte[] key) {
        this.checkIsInMulti();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        this.checkIsInMulti();
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] substr(byte[] key, int start, int end) {
        this.checkIsInMulti();
        this.client.substr(key, start, end);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        this.checkIsInMulti();
        this.client.hset(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] hget(byte[] key, byte[] field) {
        this.checkIsInMulti();
        this.client.hget(key, field);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        this.checkIsInMulti();
        this.client.hsetnx(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.checkIsInMulti();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        this.checkIsInMulti();
        this.client.hmget(key, fields);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long hincrBy(byte[] key, byte[] field, long value) {
        this.checkIsInMulti();
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        this.checkIsInMulti();
        this.client.hincrByFloat(key, field, value);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Boolean hexists(byte[] key, byte[] field) {
        this.checkIsInMulti();
        this.client.hexists(key, field);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long hdel(byte[] key, byte[] ... fields) {
        this.checkIsInMulti();
        this.client.hdel(key, fields);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(byte[] key) {
        this.checkIsInMulti();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        this.checkIsInMulti();
        this.client.hkeys(key);
        List<byte[]> lresult = this.client.getBinaryMultiBulkReply();
        return new HashSet<byte[]>(lresult);
    }

    public List<byte[]> hvals(byte[] key) {
        this.checkIsInMulti();
        this.client.hvals(key);
        List<byte[]> lresult = this.client.getBinaryMultiBulkReply();
        return lresult;
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        this.checkIsInMulti();
        this.client.hgetAll(key);
        List<byte[]> flatHash = this.client.getBinaryMultiBulkReply();
        JedisByteHashMap hash = new JedisByteHashMap();
        Iterator<byte[]> iterator = flatHash.iterator();
        while (iterator.hasNext()) {
            hash.put(iterator.next(), iterator.next());
        }
        return hash;
    }

    @Override
    public Long rpush(byte[] key, byte[] ... strings) {
        this.checkIsInMulti();
        this.client.rpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(byte[] key, byte[] ... strings) {
        this.checkIsInMulti();
        this.client.lpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(byte[] key) {
        this.checkIsInMulti();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> lrange(byte[] key, long start, long end) {
        this.checkIsInMulti();
        this.client.lrange(key, start, end);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public String ltrim(byte[] key, long start, long end) {
        this.checkIsInMulti();
        this.client.ltrim(key, start, end);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] lindex(byte[] key, long index) {
        this.checkIsInMulti();
        this.client.lindex(key, index);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String lset(byte[] key, long index, byte[] value) {
        this.checkIsInMulti();
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(byte[] key, long count, byte[] value) {
        this.checkIsInMulti();
        this.client.lrem(key, count, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] lpop(byte[] key) {
        this.checkIsInMulti();
        this.client.lpop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] rpop(byte[] key) {
        this.checkIsInMulti();
        this.client.rpop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        this.checkIsInMulti();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long sadd(byte[] key, byte[] ... members) {
        this.checkIsInMulti();
        this.client.sadd(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        this.checkIsInMulti();
        this.client.smembers(key);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new HashSet<byte[]>(members);
    }

    @Override
    public Long srem(byte[] key, byte[] ... member) {
        this.checkIsInMulti();
        this.client.srem(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] spop(byte[] key) {
        this.checkIsInMulti();
        this.client.spop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.checkIsInMulti();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(byte[] key) {
        this.checkIsInMulti();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        this.checkIsInMulti();
        this.client.sismember(key, member);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Set<byte[]> sinter(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sinter(keys);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new HashSet<byte[]>(members);
    }

    @Override
    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> sunion(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sunion(keys);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new HashSet<byte[]>(members);
    }

    @Override
    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> sdiff(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sdiff(keys);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new HashSet<byte[]>(members);
    }

    @Override
    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] srandmember(byte[] key) {
        this.checkIsInMulti();
        this.client.srandmember(key);
        return this.client.getBinaryBulkReply();
    }

    public List<byte[]> srandmember(byte[] key, int count) {
        this.checkIsInMulti();
        this.client.srandmember(key, count);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        this.checkIsInMulti();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        this.checkIsInMulti();
        this.client.zaddBinary(key, scoreMembers);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrange(byte[] key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrange(key, start, end);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new LinkedHashSet<byte[]>(members);
    }

    @Override
    public Long zrem(byte[] key, byte[] ... members) {
        this.checkIsInMulti();
        this.client.zrem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(byte[] key, double score, byte[] member) {
        this.checkIsInMulti();
        this.client.zincrby(key, score, member);
        String newscore = this.client.getBulkReply();
        return Double.valueOf(newscore);
    }

    @Override
    public Long zrank(byte[] key, byte[] member) {
        this.checkIsInMulti();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        this.checkIsInMulti();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrevrange(key, start, end);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new LinkedHashSet<byte[]>(members);
    }

    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrangeWithScores(key, start, end);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrevrangeWithScores(key, start, end);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    @Override
    public Long zcard(byte[] key) {
        this.checkIsInMulti();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(byte[] key, byte[] member) {
        this.checkIsInMulti();
        this.client.zscore(key, member);
        String score = this.client.getBulkReply();
        return score != null ? new Double(score) : null;
    }

    public Transaction multi() {
        this.client.multi();
        return new Transaction(this.client);
    }

    @Deprecated
    public List<Object> multi(TransactionBlock jedisTransaction) {
        List<Object> results = null;
        jedisTransaction.setClient(this.client);
        this.client.multi();
        jedisTransaction.execute();
        results = jedisTransaction.exec();
        return results;
    }

    protected void checkIsInMulti() {
        if (this.client.isInMulti()) {
            throw new JedisDataException("Cannot use Jedis when in Multi. Please use JedisTransaction instead.");
        }
    }

    public void connect() {
        this.client.connect();
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public void resetState() {
        if (this.client.isConnected()) {
            this.client.resetState();
            this.client.getAll();
        }
    }

    @Override
    public String watch(byte[] ... keys) {
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String unwatch() {
        this.client.unwatch();
        return this.client.getStatusCodeReply();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        this.checkIsInMulti();
        this.client.sort(key);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        this.checkIsInMulti();
        this.client.sort(key, sortingParameters);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        this.checkIsInMulti();
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray(timeout));
        this.client.blpop((byte[][])args.toArray((T[])new byte[args.size()][]));
        this.client.setTimeoutInfinite();
        List<byte[]> multiBulkReply = this.client.getBinaryMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    @Override
    public Long sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        this.checkIsInMulti();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long sort(byte[] key, byte[] dstkey) {
        this.checkIsInMulti();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        this.checkIsInMulti();
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray(timeout));
        this.client.brpop((byte[][])args.toArray((T[])new byte[args.size()][]));
        this.client.setTimeoutInfinite();
        List<byte[]> multiBulkReply = this.client.getBinaryMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    @Override
    public List<byte[]> blpop(byte[] arg) {
        this.checkIsInMulti();
        byte[][] args = new byte[][]{arg};
        this.client.blpop(args);
        this.client.setTimeoutInfinite();
        List<byte[]> multiBulkReply = this.client.getBinaryMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    @Override
    public List<byte[]> brpop(byte[] arg) {
        this.checkIsInMulti();
        byte[][] args = new byte[][]{arg};
        this.client.brpop(args);
        this.client.setTimeoutInfinite();
        List<byte[]> multiBulkReply = this.client.getBinaryMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    @Override
    public List<byte[]> blpop(byte[] ... args) {
        this.checkIsInMulti();
        this.client.blpop(args);
        this.client.setTimeoutInfinite();
        List<byte[]> multiBulkReply = this.client.getBinaryMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    @Override
    public List<byte[]> brpop(byte[] ... args) {
        this.checkIsInMulti();
        this.client.brpop(args);
        this.client.setTimeoutInfinite();
        List<byte[]> multiBulkReply = this.client.getBinaryMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    @Override
    public String auth(String password) {
        this.checkIsInMulti();
        this.client.auth(password);
        return this.client.getStatusCodeReply();
    }

    @Deprecated
    public List<Object> pipelined(PipelineBlock jedisPipeline) {
        jedisPipeline.setClient(this.client);
        jedisPipeline.execute();
        return jedisPipeline.syncAndReturnAll();
    }

    public Pipeline pipelined() {
        Pipeline pipeline = new Pipeline();
        pipeline.setClient(this.client);
        return pipeline;
    }

    @Override
    public Long zcount(byte[] key, double min, double max) {
        return this.zcount(key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public Long zcount(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMulti();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        return this.zrangeByScore(key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max);
        return new LinkedHashSet<byte[]>(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        return this.zrangeByScore(key, Protocol.toByteArray(min), Protocol.toByteArray(max), offset, count);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max, offset, count);
        return new LinkedHashSet<byte[]>(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zrangeByScoreWithScores(key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        return this.zrangeByScoreWithScores(key, Protocol.toByteArray(min), Protocol.toByteArray(max), offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    private Set<Tuple> getBinaryTupledSet() {
        this.checkIsInMulti();
        List<byte[]> membersWithScores = this.client.getBinaryMultiBulkReply();
        LinkedHashSet<Tuple> set = new LinkedHashSet<Tuple>();
        Iterator<byte[]> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            set.add(new Tuple(iterator.next(), Double.valueOf(SafeEncoder.encode(iterator.next()))));
        }
        return set;
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        return this.zrevrangeByScore(key, Protocol.toByteArray(max), Protocol.toByteArray(min));
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min);
        return new LinkedHashSet<byte[]>(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        return this.zrevrangeByScore(key, Protocol.toByteArray(max), Protocol.toByteArray(min), offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        return new LinkedHashSet<byte[]>(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        return this.zrevrangeByScoreWithScores(key, Protocol.toByteArray(max), Protocol.toByteArray(min));
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        return this.zrevrangeByScoreWithScores(key, Protocol.toByteArray(max), Protocol.toByteArray(min), offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    @Override
    public Long zremrangeByRank(byte[] key, long start, long end) {
        this.checkIsInMulti();
        this.client.zremrangeByRank(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(byte[] key, double start, double end) {
        return this.zremrangeByScore(key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    @Override
    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        this.checkIsInMulti();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMulti();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.checkIsInMulti();
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMulti();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.checkIsInMulti();
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public String save() {
        this.client.save();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String bgsave() {
        this.client.bgsave();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String bgrewriteaof() {
        this.client.bgrewriteaof();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lastsave() {
        this.client.lastsave();
        return this.client.getIntegerReply();
    }

    @Override
    public String shutdown() {
        this.client.shutdown();
        String status = null;
        try {
            status = this.client.getStatusCodeReply();
        }
        catch (JedisException ex) {
            status = null;
        }
        return status;
    }

    @Override
    public String info() {
        this.client.info();
        return this.client.getBulkReply();
    }

    @Override
    public String info(String section) {
        this.client.info(section);
        return this.client.getBulkReply();
    }

    public void monitor(JedisMonitor jedisMonitor) {
        this.client.monitor();
        this.client.getStatusCodeReply();
        jedisMonitor.proceed(this.client);
    }

    @Override
    public String slaveof(String host, int port) {
        this.client.slaveof(host, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String slaveofNoOne() {
        this.client.slaveofNoOne();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<byte[]> configGet(byte[] pattern) {
        this.client.configGet(pattern);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public String configResetStat() {
        this.client.configResetStat();
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] configSet(byte[] parameter, byte[] value) {
        this.client.configSet(parameter, value);
        return this.client.getBinaryBulkReply();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public Long strlen(byte[] key) {
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    public void sync() {
        this.client.sync();
    }

    @Override
    public Long lpushx(byte[] key, byte[] ... string) {
        this.client.lpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public Long persist(byte[] key) {
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long rpushx(byte[] key, byte[] ... string) {
        this.client.rpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] echo(byte[] string) {
        this.client.echo(string);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String debug(DebugParams params) {
        this.client.debug(params);
        return this.client.getStatusCodeReply();
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        this.client.setTimeoutInfinite();
        byte[] reply = this.client.getBinaryBulkReply();
        this.client.rollbackTimeout();
        return reply;
    }

    @Override
    public Boolean setbit(byte[] key, long offset, boolean value) {
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean setbit(byte[] key, long offset, byte[] value) {
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean getbit(byte[] key, long offset) {
        this.client.getbit(key, offset);
        return this.client.getIntegerReply() == 1L;
    }

    public Long bitpos(byte[] key, boolean value) {
        return this.bitpos(key, value, new BitPosParams());
    }

    public Long bitpos(byte[] key, boolean value, BitPosParams params) {
        this.client.bitpos(key, value, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Long setrange(byte[] key, long offset, byte[] value) {
        this.client.setrange(key, offset, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        this.client.getrange(key, startOffset, endOffset);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    @Override
    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        this.client.setTimeoutInfinite();
        jedisPubSub.proceed(this.client, channels);
        this.client.rollbackTimeout();
    }

    @Override
    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        this.client.setTimeoutInfinite();
        jedisPubSub.proceedWithPatterns(this.client, patterns);
        this.client.rollbackTimeout();
    }

    @Override
    public Long getDB() {
        return this.client.getDB();
    }

    @Override
    public Object eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        this.client.setTimeoutInfinite();
        this.client.eval(script, Protocol.toByteArray(keys.size()), this.getParams(keys, args));
        return this.client.getOne();
    }

    private byte[][] getParams(List<byte[]> keys, List<byte[]> args) {
        int i;
        int keyCount = keys.size();
        int argCount = args.size();
        byte[][] params = new byte[keyCount + args.size()][];
        for (i = 0; i < keyCount; ++i) {
            params[i] = keys.get(i);
        }
        for (i = 0; i < argCount; ++i) {
            params[keyCount + i] = args.get(i);
        }
        return params;
    }

    @Override
    public Object eval(byte[] script, byte[] keyCount, byte[] ... params) {
        this.client.setTimeoutInfinite();
        this.client.eval(script, keyCount, params);
        return this.client.getOne();
    }

    @Override
    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        this.client.setTimeoutInfinite();
        this.client.eval(script, SafeEncoder.encode(Integer.toString(keyCount)), params);
        return this.client.getOne();
    }

    @Override
    public Object eval(byte[] script) {
        this.client.setTimeoutInfinite();
        this.client.eval(script, 0, (byte[][])new byte[0][]);
        return this.client.getOne();
    }

    @Override
    public Object evalsha(byte[] sha1) {
        this.client.setTimeoutInfinite();
        this.client.evalsha(sha1, 0, (byte[][])new byte[0][]);
        return this.client.getOne();
    }

    @Override
    public Object evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        int i;
        int keyCount = keys == null ? 0 : keys.size();
        int argCount = args == null ? 0 : args.size();
        byte[][] params = new byte[keyCount + argCount][];
        for (i = 0; i < keyCount; ++i) {
            params[i] = keys.get(i);
        }
        for (i = 0; i < argCount; ++i) {
            params[keyCount + i] = args.get(i);
        }
        return this.evalsha(sha1, keyCount, params);
    }

    @Override
    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        this.client.setTimeoutInfinite();
        this.client.evalsha(sha1, keyCount, params);
        return this.client.getOne();
    }

    @Override
    public String scriptFlush() {
        this.client.scriptFlush();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Long> scriptExists(byte[] ... sha1) {
        this.client.scriptExists(sha1);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public byte[] scriptLoad(byte[] script) {
        this.client.scriptLoad(script);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String scriptKill() {
        this.client.scriptKill();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String slowlogReset() {
        this.client.slowlogReset();
        return this.client.getBulkReply();
    }

    @Override
    public Long slowlogLen() {
        this.client.slowlogLen();
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> slowlogGetBinary() {
        this.client.slowlogGet();
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> slowlogGetBinary(long entries) {
        this.client.slowlogGet(entries);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long objectRefcount(byte[] key) {
        this.client.objectRefcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] objectEncoding(byte[] key) {
        this.client.objectEncoding(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long objectIdletime(byte[] key) {
        this.client.objectIdletime(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(byte[] key) {
        this.client.bitcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(byte[] key, long start, long end) {
        this.client.bitcount(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.client.bitop(op, destKey, srcKeys);
        return this.client.getIntegerReply();
    }

    public byte[] dump(byte[] key) {
        this.checkIsInMulti();
        this.client.dump(key);
        return this.client.getBinaryBulkReply();
    }

    public String restore(byte[] key, int ttl, byte[] serializedValue) {
        this.checkIsInMulti();
        this.client.restore(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Deprecated
    public Long pexpire(byte[] key, int milliseconds) {
        return this.pexpire(key, (long)milliseconds);
    }

    public Long pexpire(byte[] key, long milliseconds) {
        this.checkIsInMulti();
        this.client.pexpire(key, milliseconds);
        return this.client.getIntegerReply();
    }

    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.checkIsInMulti();
        this.client.pexpireAt(key, millisecondsTimestamp);
        return this.client.getIntegerReply();
    }

    public Long pttl(byte[] key) {
        this.checkIsInMulti();
        this.client.pttl(key);
        return this.client.getIntegerReply();
    }

    public String psetex(byte[] key, int milliseconds, byte[] value) {
        this.checkIsInMulti();
        this.client.psetex(key, milliseconds, value);
        return this.client.getStatusCodeReply();
    }

    public String set(byte[] key, byte[] value, byte[] nxxx) {
        this.checkIsInMulti();
        this.client.set(key, value, nxxx);
        return this.client.getStatusCodeReply();
    }

    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, int time) {
        this.checkIsInMulti();
        this.client.set(key, value, nxxx, expx, time);
        return this.client.getStatusCodeReply();
    }

    public String clientKill(byte[] client) {
        this.checkIsInMulti();
        this.client.clientKill(client);
        return this.client.getStatusCodeReply();
    }

    public String clientGetname() {
        this.checkIsInMulti();
        this.client.clientGetname();
        return this.client.getBulkReply();
    }

    public String clientList() {
        this.checkIsInMulti();
        this.client.clientList();
        return this.client.getBulkReply();
    }

    public String clientSetname(byte[] name) {
        this.checkIsInMulti();
        this.client.clientSetname(name);
        return this.client.getBulkReply();
    }

    public List<String> time() {
        this.checkIsInMulti();
        this.client.time();
        return this.client.getMultiBulkReply();
    }

    public String migrate(byte[] host, int port, byte[] key, int destinationDb, int timeout) {
        this.checkIsInMulti();
        this.client.migrate(host, port, key, destinationDb, timeout);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long waitReplicas(int replicas, long timeout) {
        this.checkIsInMulti();
        this.client.waitReplicas(replicas, timeout);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pfadd(byte[] key, byte[] ... elements) {
        this.checkIsInMulti();
        this.client.pfadd(key, elements);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(byte[] key) {
        this.checkIsInMulti();
        this.client.pfcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.checkIsInMulti();
        this.client.pfmerge(destkey, sourcekeys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long pfcount(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.pfcount(keys);
        return this.client.getIntegerReply();
    }

    public ScanResult<byte[]> scan(byte[] cursor) {
        return this.scan(cursor, new ScanParams());
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.scan(cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        List rawResults = (List)result.get(1);
        return new ScanResult<byte[]>(newcursor, rawResults);
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.hscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        ArrayList results = new ArrayList();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new AbstractMap.SimpleEntry(iterator.next(), iterator.next()));
        }
        return new ScanResult<Map.Entry<byte[], byte[]>>(newcursor, results);
    }

    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        return this.sscan(key, cursor, new ScanParams());
    }

    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.sscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        List rawResults = (List)result.get(1);
        return new ScanResult<byte[]>(newcursor, rawResults);
    }

    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        return this.zscan(key, cursor, new ScanParams());
    }

    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.zscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        ArrayList<Tuple> results = new ArrayList<Tuple>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new Tuple((byte[])iterator.next(), Double.valueOf(SafeEncoder.encode((byte[])iterator.next()))));
        }
        return new ScanResult<Tuple>(newcursor, results);
    }
}

