/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import net.md_5.bungee.api.config.ServerInfo;

public class RedisBungeeAPI {
    private final RedisBungee plugin;
    private final List<String> reservedChannels;

    RedisBungeeAPI(RedisBungee plugin) {
        this.plugin = plugin;
        this.reservedChannels = ImmutableList.of((Object)"redisbungee-allservers", (Object)("redisbungee-" + plugin.getServerId()), (Object)"redisbungee-data");
    }

    public final int getPlayerCount() {
        return this.plugin.getCount();
    }

    public final long getLastOnline(@NonNull UUID player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        return this.plugin.getDataManager().getLastOnline(player);
    }

    public final ServerInfo getServerFor(@NonNull UUID player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        String server = this.plugin.getDataManager().getServer(player);
        return this.plugin.getProxy().getServerInfo(server);
    }

    public final Set<UUID> getPlayersOnline() {
        return this.plugin.getPlayers();
    }

    public final Collection<String> getHumanPlayersOnline() {
        return Collections2.transform((Collection)((ImmutableSet)this.getPlayersOnline()).asList(), (Function)new Function<UUID, String>(){

            public String apply(UUID uuid) {
                return RedisBungeeAPI.this.getNameFromUuid(uuid, false);
            }
        });
    }

    public final Multimap<String, UUID> getServerToPlayers() {
        return this.plugin.serversToPlayers();
    }

    public final Set<UUID> getPlayersOnServer(@NonNull String server) {
        if (server == null) {
            throw new NullPointerException("server");
        }
        return this.plugin.getPlayersOnServer(server);
    }

    public final boolean isPlayerOnline(@NonNull UUID player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        return this.getLastOnline(player) == 0L;
    }

    public final InetAddress getPlayerIp(@NonNull UUID player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        return this.plugin.getDataManager().getIp(player);
    }

    public final String getProxy(@NonNull UUID player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        return this.plugin.getDataManager().getProxy(player);
    }

    public final void sendProxyCommand(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        this.plugin.sendProxyCommand("allservers", command);
    }

    public final void sendProxyCommand(@NonNull String proxyId, @NonNull String command) {
        if (proxyId == null) {
            throw new NullPointerException("proxyId");
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        this.plugin.sendProxyCommand(proxyId, command);
    }

    public final void sendChannelMessage(@NonNull String channel, @NonNull String message) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.plugin.sendChannelMessage(channel, message);
    }

    public final String getServerId() {
        return this.plugin.getServerId();
    }

    public final List<String> getAllServers() {
        return this.plugin.getServerIds();
    }

    public final void registerPubSubChannels(String ... channels) {
        RedisBungee.getPubSubListener().addChannel(channels);
    }

    public final void unregisterPubSubChannels(String ... channels) {
        for (String channel : channels) {
            Preconditions.checkArgument((!this.reservedChannels.contains(channel) ? 1 : 0) != 0, (Object)"attempting to unregister internal channel");
        }
        RedisBungee.getPubSubListener().removeChannel(channels);
    }

    public final String getNameFromUuid(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid");
        }
        return this.getNameFromUuid(uuid, true);
    }

    public final String getNameFromUuid(@NonNull UUID uuid, boolean expensiveLookups) {
        if (uuid == null) {
            throw new NullPointerException("uuid");
        }
        return this.plugin.getUuidTranslator().getNameFromUuid(uuid, expensiveLookups);
    }

    public final UUID getUuidFromName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.getUuidFromName(name, true);
    }

    public final UUID getUuidFromName(@NonNull String name, boolean expensiveLookups) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.plugin.getUuidTranslator().getTranslatedUuid(name, expensiveLookups);
    }
}

