/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.imaginarycode.minecraft.redisbungee.DataManager;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeCommands;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeListener;
import com.imaginarycode.minecraft.redisbungee.RedisUtil;
import com.imaginarycode.minecraft.redisbungee.events.PubSubMessageEvent;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisPool;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisPoolConfig;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisPubSub;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisConnectionException;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisException;
import com.imaginarycode.minecraft.redisbungee.internal.okhttp.OkHttpClient;
import com.imaginarycode.minecraft.redisbungee.util.NameFetcher;
import com.imaginarycode.minecraft.redisbungee.util.UUIDTranslator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import lombok.NonNull;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public final class RedisBungee
extends Plugin {
    private static Configuration configuration;
    private static Gson gson;
    private static RedisBungeeAPI api;
    private static PubSubListener psl;
    private JedisPool pool;
    private UUIDTranslator uuidTranslator;
    private String serverId;
    private DataManager dataManager;
    private ExecutorService service;
    private static OkHttpClient httpClient;
    private List<String> serverIds;
    private AtomicInteger nagAboutServers = new AtomicInteger();
    private ScheduledTask integrityCheck;
    private ScheduledTask heartbeatTask;

    public static RedisBungeeAPI getApi() {
        return api;
    }

    static Configuration getConfiguration() {
        return configuration;
    }

    static PubSubListener getPubSubListener() {
        return psl;
    }

    final List<String> getServerIds() {
        return this.serverIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<String> getCurrentServerIds() {
        Jedis jedis = this.pool.getResource();
        try {
            int nag = this.nagAboutServers.decrementAndGet();
            if (nag <= 0) {
                this.nagAboutServers.set(10);
            }
            ImmutableList.Builder servers = ImmutableList.builder();
            Map<String, String> heartbeats = jedis.hgetAll("heartbeats");
            for (Map.Entry<String, String> entry : heartbeats.entrySet()) {
                try {
                    long stamp = Long.parseLong(entry.getValue());
                    if (System.currentTimeMillis() < stamp + 30000L) {
                        servers.add((Object)entry.getKey());
                        continue;
                    }
                    if (nag > 0) continue;
                    this.getLogger().severe(entry.getKey() + " is " + (System.currentTimeMillis() - stamp) + "ms behind! (Time not synchronized or server down?)");
                }
                catch (NumberFormatException ignored) {}
            }
            ImmutableList immutableList = servers.build();
            return immutableList;
        }
        catch (JedisConnectionException e) {
            this.getLogger().log(Level.SEVERE, "Unable to fetch all server IDs", e);
            if (jedis != null) {
                this.pool.returnBrokenResource(jedis);
            }
            List<String> list = Collections.singletonList(this.serverId);
            return list;
        }
        finally {
            this.pool.returnResource(jedis);
        }
    }

    final Multimap<String, UUID> serversToPlayers() {
        ImmutableMultimap.Builder multimapBuilder = ImmutableMultimap.builder();
        for (UUID p : this.getPlayers()) {
            String name = this.dataManager.getServer(p);
            if (name == null) continue;
            multimapBuilder.put((Object)name, (Object)p);
        }
        return multimapBuilder.build();
    }

    final int getCount() {
        int c = 0;
        if (this.pool != null) {
            Jedis rsc = this.pool.getResource();
            try {
                for (String i : this.getServerIds()) {
                    c = (int)((long)c + rsc.scard("proxy:" + i + ":usersOnline"));
                }
            }
            catch (JedisConnectionException e) {
                this.getLogger().log(Level.SEVERE, "Unable to get connection from pool - did your Redis server go away?", e);
                if (rsc != null) {
                    this.pool.returnBrokenResource(rsc);
                }
                throw new RuntimeException("Unable to get total player count", e);
            }
            finally {
                this.pool.returnResource(rsc);
            }
        }
        return c;
    }

    final Set<UUID> getLocalPlayers() {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (ProxiedPlayer pp : this.getProxy().getPlayers()) {
            setBuilder = setBuilder.add((Object)pp.getUniqueId());
        }
        return setBuilder.build();
    }

    final Collection<String> getLocalPlayersAsUuidStrings() {
        return Collections2.transform(this.getLocalPlayers(), (Function)Functions.toStringFunction());
    }

    final Set<UUID> getPlayers() {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder().addAll(this.getLocalPlayers());
        if (this.pool != null) {
            Jedis rsc = this.pool.getResource();
            try {
                Set<String> users;
                ArrayList<String> keys = new ArrayList<String>();
                for (String i : this.getServerIds()) {
                    if (i.equals(this.serverId)) continue;
                    keys.add("proxy:" + i + ":usersOnline");
                }
                if (!keys.isEmpty() && (users = rsc.sunion(keys.toArray(new String[keys.size()]))) != null && !users.isEmpty()) {
                    for (String user : users) {
                        try {
                            setBuilder = setBuilder.add((Object)UUID.fromString(user));
                        }
                        catch (IllegalArgumentException ignored) {}
                    }
                }
            }
            catch (JedisConnectionException e) {
                this.getLogger().log(Level.SEVERE, "Unable to get connection from pool - did your Redis server go away?", e);
                if (rsc != null) {
                    this.pool.returnBrokenResource(rsc);
                }
                throw new RuntimeException("Unable to get all players online", e);
            }
            finally {
                this.pool.returnResource(rsc);
            }
        }
        return setBuilder.build();
    }

    final Set<UUID> getPlayersOnServer(@NonNull String server) {
        if (server == null) {
            throw new NullPointerException("server");
        }
        Preconditions.checkArgument((boolean)this.getProxy().getServers().containsKey(server), (Object)"server does not exist");
        return ImmutableSet.copyOf((Collection)this.serversToPlayers().get((Object)server));
    }

    final void sendProxyCommand(@NonNull String proxyId, @NonNull String command) {
        if (proxyId == null) {
            throw new NullPointerException("proxyId");
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        Preconditions.checkArgument((this.getServerIds().contains(proxyId) || proxyId.equals("allservers") ? 1 : 0) != 0, (Object)"proxyId is invalid");
        this.sendChannelMessage("redisbungee-" + proxyId, command);
    }

    final void sendChannelMessage(String channel, String message) {
        Jedis jedis = this.pool.getResource();
        try {
            jedis.publish(channel, message);
        }
        catch (JedisConnectionException e) {
            this.getLogger().log(Level.SEVERE, "Unable to get connection from pool - did your Redis server go away?", e);
            if (jedis != null) {
                this.pool.returnBrokenResource(jedis);
            }
            throw new RuntimeException("Unable to publish channel message", e);
        }
        finally {
            this.pool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnable() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load/save config", e);
        }
        catch (JedisConnectionException e) {
            throw new RuntimeException("Unable to connect to your Redis server!", e);
        }
        if (this.pool != null) {
            Jedis tmpRsc = this.pool.getResource();
            try {
                tmpRsc.hset("heartbeats", this.serverId, String.valueOf(System.currentTimeMillis()));
            }
            finally {
                this.pool.returnResource(tmpRsc);
            }
            this.serverIds = this.getCurrentServerIds();
            this.uuidTranslator = new UUIDTranslator(this);
            this.heartbeatTask = this.getProxy().getScheduler().schedule((Plugin)this, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Jedis rsc = RedisBungee.this.pool.getResource();
                    try {
                        rsc.hset("heartbeats", RedisBungee.this.serverId, String.valueOf(System.currentTimeMillis()));
                    }
                    catch (JedisConnectionException e) {
                        RedisBungee.this.getLogger().log(Level.SEVERE, "Unable to update heartbeat - did your Redis server go away?", e);
                        RedisBungee.this.pool.returnBrokenResource(rsc);
                    }
                    finally {
                        RedisBungee.this.pool.returnResource(rsc);
                    }
                    RedisBungee.this.serverIds = RedisBungee.this.getCurrentServerIds();
                }
            }, 0L, 3L, TimeUnit.SECONDS);
            this.dataManager = new DataManager(this);
            if (configuration.getBoolean("register-bungee-commands", true)) {
                this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.GlistCommand(this));
                this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.FindCommand(this));
                this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.LastSeenCommand(this));
                this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.IpCommand(this));
            }
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.SendToAll(this));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.ServerId(this));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.ServerIds());
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.PlayerProxyCommand(this));
            api = new RedisBungeeAPI(this);
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new RedisBungeeListener(this));
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this.dataManager);
            psl = new PubSubListener();
            this.getProxy().getScheduler().runAsync((Plugin)this, (Runnable)psl);
            this.integrityCheck = this.getProxy().getScheduler().schedule((Plugin)this, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Jedis tmpRsc = RedisBungee.this.pool.getResource();
                    try {
                        HashSet<String> players = new HashSet<String>(RedisBungee.this.getLocalPlayersAsUuidStrings());
                        Set<String> redisCollection = tmpRsc.smembers("proxy:" + RedisBungee.this.serverId + ":usersOnline");
                        for (String member : redisCollection) {
                            if (players.contains(member)) continue;
                            boolean found = false;
                            for (String proxyId : RedisBungee.this.getServerIds()) {
                                if (proxyId.equals(RedisBungee.this.serverId) || !tmpRsc.sismember("proxy:" + proxyId + ":usersOnline", member).booleanValue()) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                RedisUtil.cleanUpPlayer(member, tmpRsc);
                                RedisBungee.this.getLogger().warning("Player found in set that was not found locally and globally: " + member);
                                continue;
                            }
                            tmpRsc.srem("proxy:" + RedisBungee.this.serverId + ":usersOnline", member);
                            RedisBungee.this.getLogger().warning("Player found in set that was not found locally, but is on another proxy: " + member);
                        }
                        for (String player : players) {
                            if (redisCollection.contains(player)) continue;
                            RedisBungee.this.getLogger().warning("Player " + player + " is on the proxy but not in Redis.");
                            tmpRsc.sadd("proxy:" + RedisBungee.this.serverId + ":usersOnline", player);
                        }
                    }
                    finally {
                        RedisBungee.this.pool.returnResource(tmpRsc);
                    }
                }
            }, 0L, 1L, TimeUnit.MINUTES);
        }
        this.getProxy().registerChannel("RedisBungee");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisable() {
        if (this.pool != null) {
            psl.poison();
            this.getProxy().getScheduler().cancel((Plugin)this);
            this.integrityCheck.cancel();
            this.heartbeatTask.cancel();
            this.getProxy().getPluginManager().unregisterListeners((Plugin)this);
            this.getLogger().info("Waiting for all tasks to finish.");
            this.service.shutdown();
            try {
                if (!this.service.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.service.shutdownNow();
                }
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            Jedis tmpRsc = this.pool.getResource();
            try {
                tmpRsc.hdel("heartbeats", this.serverId);
                if (tmpRsc.scard("proxy:" + this.serverId + ":usersOnline") > 0L) {
                    Set<String> players = tmpRsc.smembers("proxy:" + this.serverId + ":usersOnline");
                    for (String member : players) {
                        RedisUtil.cleanUpPlayer(member, tmpRsc);
                    }
                }
            }
            finally {
                this.pool.returnResource(tmpRsc);
            }
            this.pool.destroy();
        }
    }

    private void loadConfig() throws IOException, JedisConnectionException {
        File file;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
            file.createNewFile();
            try (InputStream in = this.getResourceAsStream("example_config.yml");
                 FileOutputStream out = new FileOutputStream(file);){
                ByteStreams.copy((InputStream)in, (OutputStream)out);
            }
        }
        configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
        final String redisServer = configuration.getString("redis-server", "localhost");
        final int redisPort = configuration.getInt("redis-port", 6379);
        String redisPassword = configuration.getString("redis-password");
        this.serverId = configuration.getString("server-id");
        if (redisPassword != null && (redisPassword.isEmpty() || redisPassword.equals("none"))) {
            redisPassword = null;
        }
        if (this.serverId == null || this.serverId.isEmpty()) {
            throw new RuntimeException("server-id is not specified in the configuration or is empty");
        }
        if (redisServer != null && !redisServer.isEmpty()) {
            final String finalRedisPassword = redisPassword;
            FutureTask<JedisPool> task = new FutureTask<JedisPool>(new Callable<JedisPool>(){

                @Override
                public JedisPool call() throws Exception {
                    JedisPoolConfig config = new JedisPoolConfig();
                    config.setMaxTotal(configuration.getInt("max-redis-connections", 8));
                    config.setJmxEnabled(false);
                    return new JedisPool(config, redisServer, redisPort, 0, finalRedisPassword);
                }
            });
            this.getProxy().getScheduler().runAsync((Plugin)this, task);
            try {
                this.pool = task.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Unable to create Redis pool", e);
            }
            Jedis rsc = null;
            try {
                rsc = this.pool.getResource();
                rsc.ping();
                File crashFile = new File(this.getDataFolder(), "restarted_from_crash.txt");
                if (crashFile.exists()) {
                    crashFile.delete();
                } else if (rsc.hexists("heartbeats", this.serverId).booleanValue()) {
                    try {
                        Long value = Long.valueOf(rsc.hget("heartbeats", this.serverId));
                        if (value != null && System.currentTimeMillis() < value + 20000L) {
                            this.getLogger().severe("You have launched a possible imposter BungeeCord instance. Another instance is already running.");
                            this.getLogger().severe("For data consistency reasons, RedisBungee will now disable itself.");
                            this.getLogger().severe("If this instance is coming up from a crash, create a file in your RedisBungee plugins directory with the name 'restarted_from_crash.txt' and RedisBungee will not perform this check.");
                            throw new RuntimeException("Possible imposter instance!");
                        }
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                }
                FutureTask<Void> task2 = new FutureTask<Void>(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        RedisBungee.this.service = Executors.newFixedThreadPool(16);
                        httpClient = new OkHttpClient();
                        NameFetcher.setHttpClient(httpClient);
                        return null;
                    }
                });
                this.getProxy().getScheduler().runAsync((Plugin)this, task2);
                try {
                    task2.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("Unable to create executor", e);
                }
                this.getLogger().log(Level.INFO, "Successfully connected to Redis.");
            }
            catch (JedisConnectionException e) {
                if (rsc != null) {
                    this.pool.returnBrokenResource(rsc);
                }
                this.pool.destroy();
                this.pool = null;
                rsc = null;
                throw e;
            }
            finally {
                if (rsc != null && this.pool != null) {
                    this.pool.returnResource(rsc);
                }
            }
        }
        throw new RuntimeException("No redis server specified!");
    }

    public static Gson getGson() {
        return gson;
    }

    public JedisPool getPool() {
        return this.pool;
    }

    public UUIDTranslator getUuidTranslator() {
        return this.uuidTranslator;
    }

    public String getServerId() {
        return this.serverId;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public ExecutorService getService() {
        return this.service;
    }

    public static OkHttpClient getHttpClient() {
        return httpClient;
    }

    static {
        gson = new Gson();
        psl = null;
    }

    class JedisPubSubHandler
    extends JedisPubSub {
        JedisPubSubHandler() {
        }

        @Override
        public void onMessage(final String s, final String s2) {
            if (s2.trim().length() == 0) {
                return;
            }
            RedisBungee.this.getProxy().getScheduler().runAsync((Plugin)RedisBungee.this, new Runnable(){

                @Override
                public void run() {
                    RedisBungee.this.getProxy().getPluginManager().callEvent((Event)new PubSubMessageEvent(s, s2));
                }
            });
        }

        @Override
        public void onPMessage(String s, String s2, String s3) {
        }

        @Override
        public void onSubscribe(String s, int i) {
        }

        @Override
        public void onUnsubscribe(String s, int i) {
        }

        @Override
        public void onPUnsubscribe(String s, int i) {
        }

        @Override
        public void onPSubscribe(String s, int i) {
        }
    }

    class PubSubListener
    implements Runnable {
        private Jedis rsc;
        private JedisPubSubHandler jpsh;

        private PubSubListener() {
        }

        @Override
        public void run() {
            try {
                this.rsc = RedisBungee.this.pool.getResource();
                this.jpsh = new JedisPubSubHandler();
                this.rsc.subscribe(this.jpsh, "redisbungee-" + RedisBungee.this.serverId, "redisbungee-allservers", "redisbungee-data");
            }
            catch (JedisException | ClassCastException runtimeException) {
                // empty catch block
            }
        }

        public void addChannel(String ... channel) {
            this.jpsh.subscribe(channel);
        }

        public void removeChannel(String ... channel) {
            this.jpsh.unsubscribe(channel);
        }

        public void poison() {
            this.jpsh.unsubscribe();
        }
    }
}

