/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.events.PlayerChangedServerNetworkEvent;
import com.imaginarycode.minecraft.redisbungee.events.PlayerJoinedNetworkEvent;
import com.imaginarycode.minecraft.redisbungee.events.PlayerLeftNetworkEvent;
import com.imaginarycode.minecraft.redisbungee.events.PubSubMessageEvent;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisConnectionException;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class DataManager
implements Listener {
    private final RedisBungee plugin;
    private final ConcurrentMap<UUID, String> serverCache = new ConcurrentHashMap<UUID, String>(192, 0.65f, 4);
    private final ConcurrentMap<UUID, String> proxyCache = new ConcurrentHashMap<UUID, String>(192, 0.65f, 4);
    private final ConcurrentMap<UUID, InetAddress> ipCache = new ConcurrentHashMap<UUID, InetAddress>(192, 0.65f, 4);
    private final ConcurrentMap<UUID, Long> lastOnlineCache = new ConcurrentHashMap<UUID, Long>(192, 0.65f, 4);
    private final JsonParser parser = new JsonParser();

    public String getServer(UUID uuid) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(uuid);
        if (player != null) {
            return player.getServer() != null ? player.getServer().getInfo().getName() : null;
        }
        String server = (String)this.serverCache.get(uuid);
        if (server != null) {
            return server;
        }
        Jedis tmpRsc = this.plugin.getPool().getResource();
        try {
            server = tmpRsc.hget("player:" + uuid, "server");
            if (server == null) {
                String string = null;
                return string;
            }
            this.serverCache.put(uuid, server);
            String string = server;
            return string;
        }
        catch (JedisConnectionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to get connection from pool - did your Redis server go away?", e);
            if (tmpRsc != null) {
                this.plugin.getPool().returnBrokenResource(tmpRsc);
            }
            throw new RuntimeException("Unable to get server for " + uuid, e);
        }
        finally {
            this.plugin.getPool().returnResource(tmpRsc);
        }
    }

    public String getProxy(UUID uuid) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(uuid);
        if (player != null) {
            return this.plugin.getServerId();
        }
        String server = (String)this.proxyCache.get(uuid);
        if (server != null) {
            return server;
        }
        Jedis tmpRsc = this.plugin.getPool().getResource();
        try {
            server = tmpRsc.hget("player:" + uuid, "proxy");
            if (server == null) {
                String string = null;
                return string;
            }
            this.proxyCache.put(uuid, server);
            String string = server;
            return string;
        }
        catch (JedisConnectionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to get connection from pool - did your Redis server go away?", e);
            if (tmpRsc != null) {
                this.plugin.getPool().returnBrokenResource(tmpRsc);
            }
            throw new RuntimeException("Unable to get server for " + uuid, e);
        }
        finally {
            this.plugin.getPool().returnResource(tmpRsc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getIp(UUID uuid) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(uuid);
        if (player != null) {
            return player.getAddress().getAddress();
        }
        InetAddress address = (InetAddress)this.ipCache.get(uuid);
        if (address != null) {
            return address;
        }
        Jedis tmpRsc = this.plugin.getPool().getResource();
        try {
            String result = tmpRsc.hget("player:" + uuid, "ip");
            if (result != null) {
                address = InetAddress.getByName(result);
                if (address == null) {
                    InetAddress inetAddress = null;
                    return inetAddress;
                }
                this.ipCache.put(uuid, address);
                InetAddress inetAddress = address;
                return inetAddress;
            }
            InetAddress inetAddress = null;
            return inetAddress;
        }
        catch (JedisConnectionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to get connection from pool - did your Redis server go away?", e);
            if (tmpRsc != null) {
                this.plugin.getPool().returnBrokenResource(tmpRsc);
            }
            throw new RuntimeException("Unable to get server for " + uuid, e);
        }
        catch (UnknownHostException e) {
            InetAddress inetAddress = null;
            return inetAddress;
        }
        finally {
            this.plugin.getPool().returnResource(tmpRsc);
        }
    }

    public long getLastOnline(UUID uuid) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(uuid);
        if (player != null) {
            return 0L;
        }
        Long time = (Long)this.lastOnlineCache.get(uuid);
        if (time != null) {
            return time;
        }
        Jedis tmpRsc = this.plugin.getPool().getResource();
        try {
            String result = tmpRsc.hget("player:" + uuid, "online");
            if (result != null) {
                block17: {
                    try {
                        time = Long.valueOf(result);
                        if (time != null) break block17;
                        long l = -1L;
                        return l;
                    }
                    catch (NumberFormatException e) {
                        this.plugin.getLogger().info("I found a funny number for when " + uuid + " was last online!");
                        boolean found = false;
                        for (String proxyId : this.plugin.getServerIds()) {
                            if (proxyId.equals(this.plugin.getServerId()) || !tmpRsc.sismember("proxy:" + proxyId + ":usersOnline", uuid.toString()).booleanValue()) continue;
                            found = true;
                            break;
                        }
                        long value = 0L;
                        if (!found) {
                            value = System.currentTimeMillis();
                            this.plugin.getLogger().info(uuid + " isn't online. Setting to current time.");
                        } else {
                            this.plugin.getLogger().info(uuid + " is online. Setting to 0. Please check your BungeeCord instances.");
                            this.plugin.getLogger().info("If they are working properly, and this error does not resolve in a few minutes, please let Tux know!");
                        }
                        tmpRsc.hset("player:" + uuid, "online", Long.toString(value));
                        long l = value;
                        return l;
                    }
                }
                this.lastOnlineCache.put(uuid, time);
                long l = time;
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (JedisConnectionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to get connection from pool - did your Redis server go away?", e);
            if (tmpRsc != null) {
                this.plugin.getPool().returnBrokenResource(tmpRsc);
            }
            throw new RuntimeException("Unable to get server for " + uuid, e);
        }
        finally {
            this.plugin.getPool().returnResource(tmpRsc);
        }
    }

    private void invalidate(UUID uuid) {
        this.ipCache.remove(uuid);
        this.lastOnlineCache.remove(uuid);
        this.serverCache.remove(uuid);
        this.proxyCache.remove(uuid);
    }

    @EventHandler
    public void onPostLogin(PostLoginEvent event) {
        this.invalidate(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        this.invalidate(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPubSubMessage(PubSubMessageEvent event) {
        if (!event.getChannel().equals("redisbungee-data")) {
            return;
        }
        JsonObject jsonObject = this.parser.parse(event.getMessage()).getAsJsonObject();
        String source = jsonObject.get("source").getAsString();
        if (source.equals(this.plugin.getServerId())) {
            return;
        }
        DataManagerMessage.Action action = DataManagerMessage.Action.valueOf(jsonObject.get("action").getAsString());
        switch (action) {
            case JOIN: {
                final DataManagerMessage message1 = (DataManagerMessage)RedisBungee.getGson().fromJson((JsonElement)jsonObject, new TypeToken<DataManagerMessage<LoginPayload>>(){}.getType());
                this.proxyCache.put(message1.getTarget(), message1.getSource());
                this.lastOnlineCache.put(message1.getTarget(), 0L);
                this.ipCache.put(message1.getTarget(), ((LoginPayload)message1.getPayload()).getAddress());
                this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        DataManager.this.plugin.getProxy().getPluginManager().callEvent((Event)new PlayerJoinedNetworkEvent(message1.getTarget()));
                    }
                });
                break;
            }
            case LEAVE: {
                final DataManagerMessage message2 = (DataManagerMessage)RedisBungee.getGson().fromJson((JsonElement)jsonObject, new TypeToken<DataManagerMessage<LogoutPayload>>(){}.getType());
                this.invalidate(message2.getTarget());
                this.lastOnlineCache.put(message2.getTarget(), ((LogoutPayload)message2.getPayload()).getTimestamp());
                this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        DataManager.this.plugin.getProxy().getPluginManager().callEvent((Event)new PlayerLeftNetworkEvent(message2.getTarget()));
                    }
                });
                break;
            }
            case SERVER_CHANGE: {
                final DataManagerMessage message3 = (DataManagerMessage)RedisBungee.getGson().fromJson((JsonElement)jsonObject, new TypeToken<DataManagerMessage<ServerChangePayload>>(){}.getType());
                final String oldServer = this.serverCache.put(message3.getTarget(), ((ServerChangePayload)message3.getPayload()).getServer());
                this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        DataManager.this.plugin.getProxy().getPluginManager().callEvent((Event)new PlayerChangedServerNetworkEvent(message3.getTarget(), oldServer, ((ServerChangePayload)message3.getPayload()).getServer()));
                    }
                });
            }
        }
    }

    @ConstructorProperties(value={"plugin"})
    public DataManager(RedisBungee plugin) {
        this.plugin = plugin;
    }

    static class LogoutPayload {
        private final long timestamp;

        public long getTimestamp() {
            return this.timestamp;
        }

        @ConstructorProperties(value={"timestamp"})
        public LogoutPayload(long timestamp) {
            this.timestamp = timestamp;
        }
    }

    static class ServerChangePayload {
        private final String server;

        public String getServer() {
            return this.server;
        }

        @ConstructorProperties(value={"server"})
        public ServerChangePayload(String server) {
            this.server = server;
        }
    }

    static class LoginPayload {
        private final InetAddress address;

        public InetAddress getAddress() {
            return this.address;
        }

        @ConstructorProperties(value={"address"})
        public LoginPayload(InetAddress address) {
            this.address = address;
        }
    }

    static class DataManagerMessage<T> {
        private final UUID target;
        private final String source = RedisBungee.getApi().getServerId();
        private final Action action;
        private final T payload;

        public UUID getTarget() {
            return this.target;
        }

        public String getSource() {
            return this.source;
        }

        public Action getAction() {
            return this.action;
        }

        public T getPayload() {
            return this.payload;
        }

        @ConstructorProperties(value={"target", "action", "payload"})
        public DataManagerMessage(UUID target, Action action, T payload) {
            this.target = target;
            this.action = action;
            this.payload = payload;
        }

        static enum Action {
            JOIN,
            LEAVE,
            SERVER_CHANGE;

        }
    }
}

