/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.PacketsManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerMain
extends PacketAdapter {
    private LibsDisguises libsDisguises;

    public PacketListenerMain(LibsDisguises plugin, ArrayList<PacketType> packetsToListen) {
        super((Plugin)plugin, ListenerPriority.HIGH, packetsToListen);
        this.libsDisguises = plugin;
    }

    public void onPacketSending(PacketEvent event) {
        PacketContainer[][] packets;
        if (event.isCancelled()) {
            return;
        }
        if (event.getPlayer().getName().contains("UNKNOWN[")) {
            return;
        }
        final Player observer = event.getPlayer();
        StructureModifier entityModifer = event.getPacket().getEntityModifier(observer.getWorld());
        Entity entity = (Entity)entityModifer.read(PacketType.Play.Server.COLLECT == event.getPacketType() ? 1 : 0);
        if (entity == observer) {
            return;
        }
        try {
            packets = PacketsManager.transformPacket(event.getPacket(), event.getPlayer(), entity);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            event.setCancelled(true);
            return;
        }
        if (packets == null) {
            return;
        }
        event.setCancelled(true);
        try {
            for (PacketContainer packet : packets[0]) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, false);
            }
            final PacketContainer[] delayed = packets[1];
            if (delayed.length == 0) {
                return;
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.libsDisguises, new Runnable(){

                @Override
                public void run() {
                    try {
                        for (PacketContainer packet : delayed) {
                            ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, false);
                        }
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }, 2L);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }
}

