/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.google.common.base.Optional;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.UUID;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.LibsProfileLookupCaller;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.EulerAngle;

public class ReflectionManager {
    private static final String bukkitVersion = Bukkit.getServer().getClass().getName().split("\\.")[3];
    private static final Class<?> craftItemClass;
    private static Method damageAndIdleSoundMethod;
    private static final Field entitiesField;
    private static final Constructor<?> boundingBoxConstructor;
    private static final Method setBoundingBoxMethod;
    private static final Method ihmGet;
    private static final Field pingField;
    private static final Field trackerField;
    public static final Field entityCountField;

    public static Object createEntityInstance(String entityName) {
        try {
            Object entityObject;
            Class entityClass = ReflectionManager.getNmsClass("Entity" + entityName);
            Object world = ReflectionManager.getWorldServer((World)Bukkit.getWorlds().get(0));
            switch (entityName) {
                case "Player": {
                    Object minecraftServer = ReflectionManager.getNmsMethod("MinecraftServer", "getServer", new Class[0]).invoke(null, new Object[0]);
                    Object playerinteractmanager = ReflectionManager.getNmsClass("PlayerInteractManager").getDeclaredConstructor(ReflectionManager.getNmsClass("World")).newInstance(world);
                    WrappedGameProfile gameProfile = ReflectionManager.getGameProfile(null, "Steve");
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("MinecraftServer"), ReflectionManager.getNmsClass("WorldServer"), gameProfile.getHandleType(), playerinteractmanager.getClass()).newInstance(minecraftServer, world, gameProfile.getHandle(), playerinteractmanager);
                    break;
                }
                case "EnderPearl": {
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityLiving")).newInstance(world, ReflectionManager.createEntityInstance("Cow"));
                    break;
                }
                case "Potion": {
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), Double.TYPE, Double.TYPE, Double.TYPE, ReflectionManager.getNmsClass("ItemStack")).newInstance(world, 0.0, 0.0, 0.0, ReflectionManager.getNmsItem(new ItemStack(Material.SPLASH_POTION)));
                    break;
                }
                default: {
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World")).newInstance(world);
                }
            }
            return entityObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getMobEffectList(int id) {
        Method nmsMethod = ReflectionManager.getNmsMethod("MobEffectList", "fromId", Integer.TYPE);
        try {
            return nmsMethod.invoke(null, id);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object createMobEffect(PotionEffect effect) {
        return ReflectionManager.createMobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public static Object createMobEffect(int id, int duration, int amplification, boolean ambient, boolean particles) {
        try {
            return ReflectionManager.getNmsClass("MobEffect").getDeclaredConstructor(ReflectionManager.getNmsClass("MobEffectList"), Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE).newInstance(ReflectionManager.getMobEffectList(id), duration, amplification, ambient, particles);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FakeBoundingBox getBoundingBox(Entity entity) {
        try {
            Object boundingBox = ReflectionManager.getNmsMethod("Entity", "getBoundingBox", new Class[0]).invoke(ReflectionManager.getNmsEntity(entity), new Object[0]);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            int stage = 0;
            block10: for (Field field : boundingBox.getClass().getDeclaredFields()) {
                if (!field.getType().getSimpleName().equals("double")) continue;
                switch (++stage) {
                    case 1: {
                        x -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 2: {
                        y -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 3: {
                        z -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 4: {
                        x += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 5: {
                        y += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 6: {
                        z += field.getDouble(boundingBox);
                        continue block10;
                    }
                    default: {
                        throw new Exception("Error while setting the bounding box, more doubles than I thought??");
                    }
                }
            }
            return new FakeBoundingBox(x, y, z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Entity getBukkitEntity(Object nmsEntity) {
        try {
            return (Entity)ReflectionManager.getNmsMethod("Entity", "getBukkitEntity", new Class[0]).invoke(nmsEntity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack getBukkitItem(Object nmsItem) {
        try {
            return (ItemStack)craftItemClass.getMethod("asBukkitCopy", ReflectionManager.getNmsClass("ItemStack")).invoke(null, nmsItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getBukkitVersion() {
        return bukkitVersion;
    }

    public static Class<?> getCraftClass(String className) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + ReflectionManager.getBukkitVersion() + "." + className);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getCraftConstructor(ReflectionManager.getCraftClass(className), parameters);
    }

    public static String getCraftSound(Sound sound) {
        try {
            return (String)ReflectionManager.getCraftClass("CraftSound").getMethod("getSound", Sound.class).invoke(null, sound);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getEntityTrackerEntry(Entity target) throws Exception {
        Object world = ReflectionManager.getWorldServer(target.getWorld());
        Object tracker = trackerField.get(world);
        Object trackedEntities = entitiesField.get(tracker);
        return ihmGet.invoke(trackedEntities, target.getEntityId());
    }

    public static Object getMinecraftServer() {
        try {
            return ReflectionManager.getCraftMethod("CraftServer", "getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getEnumArt(Art art) {
        try {
            Object enumArt = ReflectionManager.getCraftClass("CraftArt").getMethod("BukkitToNotch", Art.class).invoke(null, art);
            for (Field field : enumArt.getClass().getDeclaredFields()) {
                if (field.getType() != String.class) continue;
                return (String)field.get(enumArt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Object getBlockPosition(int x, int y, int z) {
        try {
            return ReflectionManager.getNmsClass("BlockPosition").getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(x, y, z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enum getEnumDirection(int direction) {
        try {
            return (Enum)ReflectionManager.getNmsMethod("EnumDirection", "fromType2", Integer.TYPE).invoke(null, direction);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enum getEnumPlayerInfoAction(int action) {
        try {
            return (Enum)ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo$EnumPlayerInfoAction").getEnumConstants()[action];
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerInfoData(Object playerInfoPacket, WrappedGameProfile gameProfile) {
        try {
            Object playerListName = ReflectionManager.getNmsClass("ChatComponentText").getDeclaredConstructor(String.class).newInstance(gameProfile.getName());
            return ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo$PlayerInfoData").getDeclaredConstructor(ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo"), gameProfile.getHandleType(), Integer.TYPE, ReflectionManager.getNmsClass("EnumGamemode"), ReflectionManager.getNmsClass("IChatBaseComponent")).newInstance(playerInfoPacket, gameProfile.getHandle(), 0, ReflectionManager.getNmsClass("EnumGamemode").getEnumConstants()[1], playerListName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getGameProfile(Player player) {
        return WrappedGameProfile.fromPlayer((Player)player);
    }

    public static WrappedGameProfile getGameProfile(UUID uuid, String playerName) {
        try {
            return new WrappedGameProfile(uuid != null ? uuid : UUID.randomUUID(), playerName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getClonedProfile(WrappedGameProfile gameProfile) {
        return ReflectionManager.getGameProfileWithThisSkin(null, gameProfile.getName(), gameProfile);
    }

    public static WrappedGameProfile getGameProfileWithThisSkin(UUID uuid, String playerName, WrappedGameProfile profileWithSkin) {
        try {
            WrappedGameProfile gameProfile = new WrappedGameProfile(uuid != null ? uuid : UUID.randomUUID(), playerName);
            gameProfile.getProperties().putAll(profileWithSkin.getProperties());
            return gameProfile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Class getNmsClass(String className) {
        try {
            return Class.forName("net.minecraft.server." + ReflectionManager.getBukkitVersion() + "." + className);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getNmsConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getNmsConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getNmsConstructor(ReflectionManager.getNmsClass(className), parameters);
    }

    public static Object getNmsEntity(Entity entity) {
        try {
            return ReflectionManager.getCraftClass("entity.CraftEntity").getMethod("getHandle", new Class[0]).invoke((Object)entity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(Class clazz, String fieldName) {
        try {
            Field declaredField = clazz.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return declaredField;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(String className, String fieldName) {
        return ReflectionManager.getNmsField(ReflectionManager.getNmsClass(className), fieldName);
    }

    public static Object getNmsItem(ItemStack itemstack) {
        try {
            return craftItemClass.getDeclaredMethod("asNMSCopy", ItemStack.class).invoke(null, itemstack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getCraftMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass(className), methodName, parameters);
    }

    public static Method getCraftMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass(className), methodName, parameters);
    }

    public static double getPing(Player player) {
        try {
            return pingField.getInt(ReflectionManager.getNmsEntity((Entity)player));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public static float[] getSize(Entity entity) {
        try {
            float length = ReflectionManager.getNmsField("Entity", "length").getFloat(ReflectionManager.getNmsEntity(entity));
            float width = ReflectionManager.getNmsField("Entity", "width").getFloat(ReflectionManager.getNmsEntity(entity));
            float height = ((Float)ReflectionManager.getNmsMethod("Entity", "getHeadHeight", new Class[0]).invoke(ReflectionManager.getNmsEntity(entity), new Object[0])).floatValue();
            return new float[]{length, width, height};
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getSkullBlob(WrappedGameProfile gameProfile) {
        try {
            Object minecraftServer = ReflectionManager.getNmsMethod("MinecraftServer", "getServer", new Class[0]).invoke(null, new Object[0]);
            for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getDeclaredMethods()) {
                if (!method.getReturnType().getSimpleName().equals("MinecraftSessionService")) continue;
                Object session = method.invoke(minecraftServer, new Object[0]);
                return WrappedGameProfile.fromHandle((Object)session.getClass().getDeclaredMethod("fillProfileProperties", gameProfile.getHandleType(), Boolean.TYPE).invoke(session, gameProfile.getHandle(), true));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Float getSoundModifier(Object entity) {
        try {
            damageAndIdleSoundMethod.setAccessible(true);
            return (Float)damageAndIdleSoundMethod.invoke(entity, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static WrappedGameProfile grabProfileAddUUID(String playername) {
        try {
            Object minecraftServer = ReflectionManager.getNmsMethod("MinecraftServer", "getServer", new Class[0]).invoke(null, new Object[0]);
            for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getDeclaredMethods()) {
                if (!method.getReturnType().getSimpleName().equals("GameProfileRepository")) continue;
                Object profileRepo = method.invoke(minecraftServer, new Object[0]);
                Object agent = Class.forName("com.mojang.authlib.Agent").getDeclaredField("MINECRAFT").get(null);
                LibsProfileLookupCaller callback = new LibsProfileLookupCaller();
                profileRepo.getClass().getDeclaredMethod("findProfilesByNames", String[].class, agent.getClass(), Class.forName("com.mojang.authlib.ProfileLookupCallback")).invoke(profileRepo, new String[]{playername}, agent, callback);
                if (callback.getGameProfile() != null) {
                    return callback.getGameProfile();
                }
                return ReflectionManager.getGameProfile(null, playername);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void removePlayer(Player player) {
    }

    public static void setBoundingBox(Entity entity, FakeBoundingBox newBox) {
        try {
            Location loc = entity.getLocation();
            Object boundingBox = boundingBoxConstructor.newInstance(loc.getX() - newBox.getX(), loc.getY() - newBox.getY(), loc.getZ() - newBox.getZ(), loc.getX() + newBox.getX(), loc.getY() + newBox.getY(), loc.getZ() + newBox.getZ());
            setBoundingBoxMethod.invoke(ReflectionManager.getNmsEntity(entity), boundingBox);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Enum getSoundCategory(String category) {
        Method method = ReflectionManager.getNmsMethod("SoundCategory", "a", String.class);
        try {
            Enum invoke = (Enum)method.invoke(null, category.toLowerCase());
            if (invoke == null) {
                Class clazz = ReflectionManager.getNmsClass("SoundCategory");
                Enum[] enums = clazz != null ? (Enum[])clazz.getEnumConstants() : null;
                for (Enum anEnum : enums != null ? enums : new Enum[]{}) {
                    if (!anEnum.name().equals(category.toUpperCase())) continue;
                    return anEnum;
                }
            }
            return invoke;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Enum getSoundCategory(DisguiseType disguiseType) {
        if (disguiseType == DisguiseType.PLAYER) {
            return ReflectionManager.getSoundCategory("player");
        }
        Class entityClass = disguiseType.getEntityType().getEntityClass();
        if (Monster.class.isAssignableFrom(entityClass)) {
            return ReflectionManager.getSoundCategory("hostile");
        }
        if (Ambient.class.isAssignableFrom(entityClass)) {
            return ReflectionManager.getSoundCategory("ambient");
        }
        return ReflectionManager.getSoundCategory("neutral");
    }

    public static Enum createEnumItemSlot(EquipmentSlot slot) {
        T[] enums;
        Class clazz = ReflectionManager.getNmsClass("EnumItemSlot");
        T[] TArray = enums = clazz != null ? clazz.getEnumConstants() : null;
        if (enums == null) {
            return null;
        }
        switch (slot) {
            case HAND: {
                return (Enum)enums[0];
            }
            case OFF_HAND: {
                return (Enum)enums[1];
            }
            case FEET: {
                return (Enum)enums[2];
            }
            case LEGS: {
                return (Enum)enums[3];
            }
            case CHEST: {
                return (Enum)enums[4];
            }
            case HEAD: {
                return (Enum)enums[5];
            }
        }
        return null;
    }

    public static EquipmentSlot createEquipmentSlot(Object enumItemSlot) {
        try {
            Enum nmsSlot = (Enum)enumItemSlot;
            switch (nmsSlot.name()) {
                case "MAINHAND": {
                    return EquipmentSlot.HAND;
                }
                case "OFFHAND": {
                    return EquipmentSlot.OFF_HAND;
                }
                case "FEET": {
                    return EquipmentSlot.FEET;
                }
                case "LEGS": {
                    return EquipmentSlot.LEGS;
                }
                case "CHEST": {
                    return EquipmentSlot.CHEST;
                }
                case "HEAD": {
                    return EquipmentSlot.HEAD;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemStack getEquipment(EquipmentSlot slot, Entity disguisedEntity) {
        if (!(disguisedEntity instanceof LivingEntity)) {
            return null;
        }
        switch (slot) {
            case HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInMainHand();
            }
            case OFF_HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInOffHand();
            }
            case FEET: {
                return ((LivingEntity)disguisedEntity).getEquipment().getBoots();
            }
            case LEGS: {
                return ((LivingEntity)disguisedEntity).getEquipment().getLeggings();
            }
            case CHEST: {
                return ((LivingEntity)disguisedEntity).getEquipment().getChestplate();
            }
            case HEAD: {
                return ((LivingEntity)disguisedEntity).getEquipment().getHelmet();
            }
        }
        return null;
    }

    public static String convertSoundEffectToString(Object soundEffect) {
        try {
            Field f_getMinecraftKey = ReflectionManager.getNmsField("SoundEffect", "b");
            f_getMinecraftKey.setAccessible(true);
            MinecraftKey key = MinecraftKey.fromHandle((Object)f_getMinecraftKey.get(soundEffect));
            return key.getKey();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getCraftSoundEffect(String sound) {
        try {
            return ReflectionManager.getCraftMethod("CraftSound", "getSoundEffect", String.class).invoke(null, sound);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object convertInvalidItem(Object value) {
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            if (!opt.isPresent()) {
                return value;
            }
            Object val = opt.get();
            if (val instanceof ItemStack) {
                return Optional.of((Object)ReflectionManager.getNmsItem((ItemStack)val));
            }
            if (val instanceof BlockPosition) {
                BlockPosition pos = (BlockPosition)val;
                try {
                    return Optional.of(ReflectionManager.getNmsConstructor("BlockPosition", Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(pos.getX(), pos.getY(), pos.getZ()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (value instanceof EulerAngle) {
            EulerAngle angle = (EulerAngle)value;
            try {
                return ReflectionManager.getNmsConstructor("Vector3f", Float.TYPE, Float.TYPE, Float.TYPE).newInstance(Float.valueOf((float)angle.getX()), Float.valueOf((float)angle.getY()), Float.valueOf((float)angle.getZ()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (value instanceof BlockFace) {
            return ReflectionManager.getEnumDirection(((BlockFace)value).ordinal());
        }
        return value;
    }

    private static Object createDataWatcherItem(int id, Object value) {
        Optional opt;
        if (value == null) {
            return null;
        }
        WrappedDataWatcher.Serializer serializer = (value = ReflectionManager.convertInvalidItem(value)) instanceof Optional ? WrappedDataWatcher.Registry.get((opt = (Optional)value).isPresent() ? opt.get().getClass() : UUID.class, (boolean)true) : WrappedDataWatcher.Registry.get(value.getClass());
        if (serializer == null) {
            throw new IllegalArgumentException("Unable to find Serializer for " + value + "! Are you running the latest version of ProtocolLib?");
        }
        WrappedDataWatcher.WrappedDataWatcherObject watcherObject = new WrappedDataWatcher.WrappedDataWatcherObject(id, serializer);
        Constructor construct = ReflectionManager.getNmsConstructor("DataWatcher$Item", ReflectionManager.getNmsClass("DataWatcherObject"), Object.class);
        try {
            return construct.newInstance(watcherObject.getHandle(), value);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WrappedWatchableObject createWatchable(int index, Object obj) {
        return new WrappedWatchableObject(ReflectionManager.createDataWatcherItem(index, obj));
    }

    public static EntityEquipment createEntityEquipment(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        Constructor construct = ReflectionManager.getCraftConstructor("inventory.CraftEntityEquipment", ReflectionManager.getCraftClass("entity.CraftLivingEntity"));
        try {
            return (EntityEquipment)construct.newInstance((LivingEntity)entity);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getCombinedId(int id, int data) {
        return id + (data << 12);
    }

    public static Pair<Integer, Integer> getFromCombinedId(int combinedId) {
        int j = combinedId & 0xFFF;
        int k = combinedId >> 12 & 0xF;
        return new ImmutablePair((Object)j, (Object)k);
    }

    public static Object getWorldServer(World w) {
        try {
            return ReflectionManager.getCraftMethod("CraftWorld", "getHandle", new Class[0]).invoke((Object)w, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerInteractManager(World w) {
        Object worldServer = ReflectionManager.getWorldServer(w);
        try {
            return ReflectionManager.getNmsConstructor("PlayerInteractManager", ReflectionManager.getNmsClass("World")).newInstance(worldServer);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        for (Method method : ReflectionManager.getNmsClass("EntityLiving").getDeclaredMethods()) {
            try {
                if (method.getReturnType() != Float.TYPE || !Modifier.isProtected(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
                Object entity = ReflectionManager.createEntityInstance("Cow");
                method.setAccessible(true);
                float value = ((Float)method.invoke(entity, new Object[0])).floatValue();
                if (value != 0.4f) continue;
                damageAndIdleSoundMethod = method;
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        craftItemClass = ReflectionManager.getCraftClass("inventory.CraftItemStack");
        pingField = ReflectionManager.getNmsField("EntityPlayer", "ping");
        trackerField = ReflectionManager.getNmsField("WorldServer", "tracker");
        entitiesField = ReflectionManager.getNmsField("EntityTracker", "trackedEntities");
        ihmGet = ReflectionManager.getNmsMethod("IntHashMap", "get", Integer.TYPE);
        boundingBoxConstructor = ReflectionManager.getNmsConstructor("AxisAlignedBB", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
        setBoundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "a", ReflectionManager.getNmsClass("AxisAlignedBB"));
        entityCountField = ReflectionManager.getNmsField("Entity", "entityCount");
        entityCountField.setAccessible(true);
    }
}

