/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.PacketsManager;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class DisguiseUtilities {
    public static final Random random = new Random();
    private static HashSet<String> addedByPlugins = new HashSet();
    private static LinkedHashMap<String, Disguise> clonedDisguises = new LinkedHashMap();
    private static HashMap<UUID, HashSet<TargetedDisguise>> disguisesInUse = new HashMap();
    private static HashMap<Integer, HashSet<TargetedDisguise>> futureDisguises = new HashMap();
    private static HashMap<String, WrappedGameProfile> gameProfiles = new HashMap();
    private static LibsDisguises libsDisguises;
    private static HashMap<String, ArrayList<Object>> runnables;
    private static HashSet<UUID> selfDisguised;
    private static Thread mainThread;
    private static PacketContainer spawnChunk;

    public static boolean addClonedDisguise(String key, Disguise disguise) {
        if (DisguiseConfig.getMaxClonedDisguises() > 0) {
            if (clonedDisguises.containsKey(key)) {
                clonedDisguises.remove(key);
            } else if (DisguiseConfig.getMaxClonedDisguises() == clonedDisguises.size()) {
                clonedDisguises.remove(clonedDisguises.keySet().iterator().next());
            }
            if (DisguiseConfig.getMaxClonedDisguises() > clonedDisguises.size()) {
                clonedDisguises.put(key, disguise);
                return true;
            }
        }
        return false;
    }

    public static void addDisguise(UUID entityId, TargetedDisguise disguise) {
        if (!DisguiseUtilities.getDisguises().containsKey(entityId)) {
            DisguiseUtilities.getDisguises().put(entityId, new HashSet());
        }
        DisguiseUtilities.getDisguises().get(entityId).add(disguise);
        DisguiseUtilities.checkConflicts(disguise, null);
        if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS && disguise.isModifyBoundingBox()) {
            DisguiseUtilities.doBoundingBox(disguise);
        }
    }

    public static void addFutureDisguise(final int entityId, final TargetedDisguise disguise) {
        if (!futureDisguises.containsKey(entityId)) {
            futureDisguises.put(entityId, new HashSet());
        }
        futureDisguises.get(entityId).add(disguise);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                if (futureDisguises.containsKey(entityId) && ((HashSet)futureDisguises.get(entityId)).contains(disguise)) {
                    for (World world : Bukkit.getWorlds()) {
                        for (Entity entity : world.getEntities()) {
                            if (entity.getEntityId() != entityId) continue;
                            UUID uniqueId = entity.getUniqueId();
                            for (TargetedDisguise disguise2 : (HashSet)futureDisguises.remove(entityId)) {
                                DisguiseUtilities.addDisguise(uniqueId, disguise2);
                            }
                            return;
                        }
                    }
                    ((HashSet)futureDisguises.get(entityId)).remove(disguise);
                    if (((HashSet)futureDisguises.get(entityId)).isEmpty()) {
                        futureDisguises.remove(entityId);
                    }
                }
            }
        };
        runnable.runTaskLater((Plugin)libsDisguises, 20L);
    }

    public static void addGameProfile(String string, WrappedGameProfile gameProfile) {
        DisguiseUtilities.getGameProfiles().put(string, gameProfile);
        DisguiseUtilities.getAddedByPlugins().add(string.toLowerCase());
    }

    public static void checkConflicts(TargetedDisguise disguise, String name) {
        if (DisguiseAPI.isDisguiseInUse(disguise)) {
            Iterator<TargetedDisguise> disguiseItel = DisguiseUtilities.getDisguises().get(disguise.getEntity().getUniqueId()).iterator();
            while (disguiseItel.hasNext()) {
                TargetedDisguise d = disguiseItel.next();
                if (d == disguise) continue;
                if (d.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                        if (name != null) {
                            d.removePlayer(name);
                            continue;
                        }
                        for (String playername : disguise.getObservers()) {
                            d.silentlyRemovePlayer(playername);
                        }
                        continue;
                    }
                    if (disguise.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
                    if (name != null) {
                        if (disguise.getObservers().contains(name)) continue;
                        d.removePlayer(name);
                        continue;
                    }
                    for (String playername : new ArrayList<String>(d.getObservers())) {
                        if (disguise.getObservers().contains(playername)) continue;
                        d.silentlyRemovePlayer(playername);
                    }
                    continue;
                }
                if (d.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
                if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    if (name != null) {
                        d.addPlayer(name);
                        continue;
                    }
                    for (String playername : disguise.getObservers()) {
                        d.silentlyAddPlayer(playername);
                    }
                    continue;
                }
                if (disguise.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
                disguiseItel.remove();
                d.removeDisguise();
            }
        }
    }

    public static void destroyEntity(TargetedDisguise disguise) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        try {
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity());
            if (entityTrackerEntry == null) {
                return;
            }
            Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
            trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
            PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
            destroyPacket.getIntegerArrays().write(0, (Object)new int[]{disguise.getEntity().getEntityId()});
            for (Object p : trackedPlayers) {
                Player player = (Player)ReflectionManager.getBukkitEntity(p);
                if (player != disguise.getEntity() && !disguise.canSee(player)) continue;
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, destroyPacket);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void doBoundingBox(TargetedDisguise disguise) {
        Entity entity = disguise.getEntity();
        if (entity != null) {
            if (DisguiseUtilities.isDisguiseInUse(disguise)) {
                DisguiseValues disguiseValues = DisguiseValues.getDisguiseValues(disguise.getType());
                FakeBoundingBox disguiseBox = disguiseValues.getAdultBox();
                if (disguiseValues.getBabyBox() != null && (disguise.getWatcher() instanceof AgeableWatcher && ((AgeableWatcher)disguise.getWatcher()).isBaby() || disguise.getWatcher() instanceof ZombieWatcher && ((ZombieWatcher)disguise.getWatcher()).isBaby())) {
                    disguiseBox = disguiseValues.getBabyBox();
                }
                ReflectionManager.setBoundingBox(entity, disguiseBox);
            } else {
                DisguiseValues entityValues = DisguiseValues.getDisguiseValues(DisguiseType.getType(entity.getType()));
                FakeBoundingBox entityBox = entityValues.getAdultBox();
                if (entityValues.getBabyBox() != null && (entity instanceof Ageable && !((Ageable)entity).isAdult() || entity instanceof Zombie && ((Zombie)entity).isBaby())) {
                    entityBox = entityValues.getBabyBox();
                }
                ReflectionManager.setBoundingBox(entity, entityBox);
            }
        }
    }

    public static HashSet<String> getAddedByPlugins() {
        return addedByPlugins;
    }

    public static int getChunkCord(int blockCord) {
        int cord = (int)Math.floor((double)blockCord / 16.0) - 17;
        cord -= cord % 8;
        return cord;
    }

    public static PacketContainer[] getBedChunkPacket(Location newLoc, Location oldLoc) {
        StructureModifier modifier;
        int i = 0;
        PacketContainer[] packets = new PacketContainer[(newLoc != null ? 1 : 0) + (oldLoc != null ? 1 : 0)];
        if (oldLoc != null) {
            PacketContainer despawn = new PacketContainer(PacketType.Play.Server.UNLOAD_CHUNK);
            modifier = despawn.getModifier();
            modifier.write(0, (Object)DisguiseUtilities.getChunkCord(oldLoc.getBlockX()));
            modifier.write(1, (Object)DisguiseUtilities.getChunkCord(oldLoc.getBlockZ()));
            packets[i++] = despawn;
        }
        if (newLoc != null) {
            PacketContainer spawn = spawnChunk.shallowClone();
            modifier = spawn.getModifier();
            modifier.write(0, (Object)DisguiseUtilities.getChunkCord(newLoc.getBlockX()));
            modifier.write(1, (Object)DisguiseUtilities.getChunkCord(newLoc.getBlockZ()));
            packets[i++] = spawn;
        }
        return packets;
    }

    public static PacketContainer[] getBedPackets(Location sleepingLocation, Location playerLocation, PlayerDisguise disguise) {
        int entity = disguise.getEntity().getEntityId();
        PlayerWatcher watcher = disguise.getWatcher();
        PacketContainer setBed = new PacketContainer(PacketType.Play.Server.BED);
        int bX = DisguiseUtilities.getChunkCord(playerLocation.getBlockX()) * 16 + 1 + watcher.getSleepingDirection().getModX();
        int bZ = DisguiseUtilities.getChunkCord(playerLocation.getBlockZ()) * 16 + 1 + watcher.getSleepingDirection().getModZ();
        setBed.getIntegers().write(0, (Object)entity);
        setBed.getBlockPositionModifier().write(0, (Object)new BlockPosition(bX, 0, bZ));
        PacketContainer teleport = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        StructureModifier doubles = teleport.getDoubles();
        teleport.getIntegers().write(0, (Object)entity);
        doubles.write(0, (Object)sleepingLocation.getX());
        doubles.write(1, (Object)(PacketsManager.getYModifier(disguise.getEntity(), disguise) + sleepingLocation.getY()));
        doubles.write(2, (Object)sleepingLocation.getZ());
        return new PacketContainer[]{setBed, teleport};
    }

    public static Disguise getClonedDisguise(String key) {
        if (clonedDisguises.containsKey(key)) {
            return clonedDisguises.get(key).clone();
        }
        return null;
    }

    public static PacketContainer getDestroyPacket(int ... ids) {
        PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        destroyPacket.getIntegerArrays().write(0, (Object)ids);
        return destroyPacket;
    }

    public static TargetedDisguise getDisguise(Player observer, Entity entity) {
        UUID entityId = entity.getUniqueId();
        if (futureDisguises.containsKey(entity.getEntityId())) {
            for (TargetedDisguise disguise : futureDisguises.remove(entity.getEntityId())) {
                DisguiseUtilities.addDisguise(entityId, disguise);
            }
        }
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            for (TargetedDisguise disguise : DisguiseUtilities.getDisguises().get(entityId)) {
                if (!disguise.canSee(observer)) continue;
                return disguise;
            }
        }
        return null;
    }

    public static HashMap<UUID, HashSet<TargetedDisguise>> getDisguises() {
        return disguisesInUse;
    }

    public static TargetedDisguise[] getDisguises(UUID entityId) {
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            HashSet<TargetedDisguise> disguises = DisguiseUtilities.getDisguises().get(entityId);
            return disguises.toArray(new TargetedDisguise[disguises.size()]);
        }
        return new TargetedDisguise[0];
    }

    public static HashMap<Integer, HashSet<TargetedDisguise>> getFutureDisguises() {
        return futureDisguises;
    }

    public static WrappedGameProfile getGameProfile(String playerName) {
        return gameProfiles.get(playerName.toLowerCase());
    }

    public static HashMap<String, WrappedGameProfile> getGameProfiles() {
        return gameProfiles;
    }

    public static TargetedDisguise getMainDisguise(UUID entityId) {
        TargetedDisguise toReturn = null;
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            for (TargetedDisguise disguise : DisguiseUtilities.getDisguises().get(entityId)) {
                if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    return disguise;
                }
                toReturn = disguise;
            }
        }
        return toReturn;
    }

    public static List<Player> getPerverts(Disguise disguise) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (disguise.getEntity() == null) {
            throw new IllegalStateException("The entity for the disguisetype " + disguise.getType().name() + " is null!");
        }
        ArrayList<Player> players = new ArrayList<Player>();
        try {
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity());
            if (entityTrackerEntry != null) {
                Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                for (Object p : trackedPlayers) {
                    Player player = (Player)ReflectionManager.getBukkitEntity(p);
                    if (!((TargetedDisguise)disguise).canSee(player)) continue;
                    players.add(player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return players;
    }

    public static WrappedGameProfile getProfileFromMojang(final PlayerDisguise disguise) {
        final String nameToFetch = disguise.getSkin() != null ? disguise.getSkin() : disguise.getName();
        final boolean remove = DisguiseUtilities.getAddedByPlugins().contains(nameToFetch.toLowerCase());
        return DisguiseUtilities.getProfileFromMojang(nameToFetch, new LibsProfileLookup(){

            @Override
            public void onLookup(WrappedGameProfile gameProfile) {
                if (remove) {
                    DisguiseUtilities.getAddedByPlugins().remove(nameToFetch.toLowerCase());
                }
                if (!(!DisguiseAPI.isDisguiseInUse(disguise) || gameProfile.getName().equals(disguise.getSkin() != null ? disguise.getSkin() : disguise.getName()) && gameProfile.getProperties().isEmpty())) {
                    disguise.setGameProfile(gameProfile);
                    DisguiseUtilities.refreshTrackers(disguise);
                }
            }
        }, LibsDisguises.getInstance().getConfig().getBoolean("ContactMojangServers", true));
    }

    private static boolean isHashSet(Object obj) {
        if (obj instanceof HashSet) {
            return true;
        }
        if (obj instanceof Set) {
            return false;
        }
        throw new IllegalArgumentException("Object passed was not either a hashset or set!");
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, LibsProfileLookup runnableIfCantReturn) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, true);
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, LibsProfileLookup runnableIfCantReturn, boolean contactMojang) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, contactMojang);
    }

    private static WrappedGameProfile getProfileFromMojang(final String origName, Object runnable, boolean contactMojang) {
        final String playerName = origName.toLowerCase();
        if (gameProfiles.containsKey(playerName)) {
            if (gameProfiles.get(playerName) != null) {
                return gameProfiles.get(playerName);
            }
        } else if (Pattern.matches("([A-Za-z0-9_]){1,16}", origName)) {
            WrappedGameProfile gameProfile;
            DisguiseUtilities.getAddedByPlugins().add(playerName);
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player != null && !(gameProfile = ReflectionManager.getGameProfile(player)).getProperties().isEmpty()) {
                gameProfiles.put(playerName, gameProfile);
                return gameProfile;
            }
            if (contactMojang) {
                gameProfiles.put(playerName, null);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)libsDisguises, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            final WrappedGameProfile gameProfile = DisguiseUtilities.lookupGameProfile(origName);
                            Bukkit.getScheduler().runTask((Plugin)libsDisguises, new Runnable(){

                                @Override
                                public void run() {
                                    if (gameProfile.getProperties().isEmpty()) {
                                        return;
                                    }
                                    if (gameProfiles.containsKey(playerName) && gameProfiles.get(playerName) == null) {
                                        gameProfiles.put(playerName, gameProfile);
                                    }
                                    if (runnables.containsKey(playerName)) {
                                        for (Object obj : (ArrayList)runnables.remove(playerName)) {
                                            if (obj instanceof Runnable) {
                                                ((Runnable)obj).run();
                                                continue;
                                            }
                                            if (!(obj instanceof LibsProfileLookup)) continue;
                                            ((LibsProfileLookup)obj).onLookup(gameProfile);
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            if (gameProfiles.containsKey(playerName) && gameProfiles.get(playerName) == null) {
                                gameProfiles.remove(playerName);
                                DisguiseUtilities.getAddedByPlugins().remove(playerName);
                            }
                            System.out.print("[LibsDisguises] Error when fetching " + playerName + "'s uuid from mojang: " + e.getMessage());
                        }
                    }
                });
            }
        } else {
            return ReflectionManager.getGameProfile(null, origName);
        }
        if (runnable != null) {
            if (!runnables.containsKey(playerName)) {
                runnables.put(playerName, new ArrayList());
            }
            runnables.get(playerName).add(runnable);
        }
        return null;
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, Runnable runnableIfCantReturn) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, true);
    }

    public static WrappedGameProfile getProfileFromMojang(String playerName, Runnable runnableIfCantReturn, boolean contactMojang) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, contactMojang);
    }

    public static HashSet<UUID> getSelfDisguised() {
        return selfDisguised;
    }

    public static boolean hasGameProfile(String playerName) {
        return DisguiseUtilities.getGameProfile(playerName) != null;
    }

    public static void init(LibsDisguises disguises) {
        libsDisguises = disguises;
    }

    public static boolean isDisguiseInUse(Disguise disguise) {
        return disguise.getEntity() != null && DisguiseUtilities.getDisguises().containsKey(disguise.getEntity().getUniqueId()) && DisguiseUtilities.getDisguises().get(disguise.getEntity().getUniqueId()).contains(disguise);
    }

    public static WrappedGameProfile lookupGameProfile(String playerName) {
        return ReflectionManager.getSkullBlob(ReflectionManager.grabProfileAddUUID(playerName));
    }

    public static void refreshTracker(final TargetedDisguise disguise, String player) {
        block8: {
            if (mainThread != Thread.currentThread()) {
                throw new IllegalStateException("Cannot modify disguises on an async thread");
            }
            if (disguise.getEntity() == null || !disguise.getEntity().isValid()) {
                return;
            }
            try {
                PacketContainer destroyPacket = DisguiseUtilities.getDestroyPacket(disguise.getEntity().getEntityId());
                if (disguise.isDisguiseInUse() && disguise.getEntity() instanceof Player && disguise.getEntity().getName().equalsIgnoreCase(player)) {
                    DisguiseUtilities.removeSelfDisguise((Player)disguise.getEntity());
                    if (disguise.isSelfDisguiseVisible()) {
                        selfDisguised.add(disguise.getEntity().getUniqueId());
                    }
                    ProtocolLibrary.getProtocolManager().sendServerPacket((Player)disguise.getEntity(), destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)libsDisguises, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DisguiseUtilities.sendSelfDisguise((Player)disguise.getEntity(), disguise);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }, 2L);
                    break block8;
                }
                final Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity());
                if (entityTrackerEntry == null) {
                    return;
                }
                Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                Method clear = ReflectionManager.getNmsMethod("EntityTrackerEntry", "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                final Method updatePlayer = ReflectionManager.getNmsMethod("EntityTrackerEntry", "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                for (final Object p : trackedPlayers) {
                    Player pl = (Player)ReflectionManager.getBukkitEntity(p);
                    if (!player.equalsIgnoreCase(pl.getName())) continue;
                    clear.invoke(entityTrackerEntry, p);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(pl, destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)libsDisguises, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                updatePlayer.invoke(entityTrackerEntry, p);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }, 2L);
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void refreshTrackers(Entity entity) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (entity.isValid()) {
            try {
                PacketContainer destroyPacket = DisguiseUtilities.getDestroyPacket(entity.getEntityId());
                final Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(entity);
                if (entityTrackerEntry != null) {
                    Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                    Method clear = ReflectionManager.getNmsMethod("EntityTrackerEntry", "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                    final Method updatePlayer = ReflectionManager.getNmsMethod("EntityTrackerEntry", "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                    trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                    for (final Object p : trackedPlayers) {
                        Player player = (Player)ReflectionManager.getBukkitEntity(p);
                        if (player == entity) continue;
                        clear.invoke(entityTrackerEntry, p);
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, destroyPacket);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)libsDisguises, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    updatePlayer.invoke(entityTrackerEntry, p);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }, 2L);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void refreshTrackers(final TargetedDisguise disguise) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (disguise.getEntity().isValid()) {
            PacketContainer destroyPacket = DisguiseUtilities.getDestroyPacket(disguise.getEntity().getEntityId());
            try {
                Object entityTrackerEntry;
                if (selfDisguised.contains(disguise.getEntity().getUniqueId()) && disguise.isDisguiseInUse()) {
                    DisguiseUtilities.removeSelfDisguise((Player)disguise.getEntity());
                    selfDisguised.add(disguise.getEntity().getUniqueId());
                    ProtocolLibrary.getProtocolManager().sendServerPacket((Player)disguise.getEntity(), destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)libsDisguises, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DisguiseUtilities.sendSelfDisguise((Player)disguise.getEntity(), disguise);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }, 2L);
                }
                if ((entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity())) != null) {
                    Set trackedPlayers = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                    Method clear = ReflectionManager.getNmsMethod("EntityTrackerEntry", "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                    final Method updatePlayer = ReflectionManager.getNmsMethod("EntityTrackerEntry", "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                    trackedPlayers = (Set)new HashSet(trackedPlayers).clone();
                    for (final Object p : trackedPlayers) {
                        Player player = (Player)ReflectionManager.getBukkitEntity(p);
                        if (disguise.getEntity() == player || !disguise.canSee(player)) continue;
                        clear.invoke(entityTrackerEntry, p);
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, destroyPacket);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)libsDisguises, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    updatePlayer.invoke(entityTrackerEntry, p);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }, 2L);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static boolean removeDisguise(TargetedDisguise disguise) {
        UUID entityId = disguise.getEntity().getUniqueId();
        if (DisguiseUtilities.getDisguises().containsKey(entityId) && DisguiseUtilities.getDisguises().get(entityId).remove(disguise)) {
            if (DisguiseUtilities.getDisguises().get(entityId).isEmpty()) {
                DisguiseUtilities.getDisguises().remove(entityId);
            }
            if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS && disguise.isModifyBoundingBox()) {
                DisguiseUtilities.doBoundingBox(disguise);
            }
            return true;
        }
        return false;
    }

    public static void removeGameProfile(String string) {
        gameProfiles.remove(string.toLowerCase());
    }

    public static void removeSelfDisguise(Player player) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (!selfDisguised.contains(player.getUniqueId())) {
            return;
        }
        PacketContainer packet = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Scoreboard scoreboard = player.getScoreboard();
        Team t = scoreboard.getTeam("LDPushing");
        if (t != null) {
            t.removeEntry(player.getName());
        }
        selfDisguised.remove(player.getUniqueId());
        try {
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry((Entity)player);
            if (entityTrackerEntry != null) {
                Object trackedPlayersObj = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
                if (DisguiseUtilities.isHashSet(trackedPlayersObj)) {
                    ((Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry)).remove(ReflectionManager.getNmsEntity((Entity)player));
                } else {
                    ((Map)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayerMap").get(entityTrackerEntry)).remove(ReflectionManager.getNmsEntity((Entity)player));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{player.getEntityId(), WrappedDataWatcher.getEntityWatcher((Entity)player), true}).createPacket(new Object[]{player.getEntityId(), WrappedDataWatcher.getEntityWatcher((Entity)player), true}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        player.updateInventory();
    }

    public static void sendSelfDisguise(final Player player, final TargetedDisguise disguise) {
        if (mainThread != Thread.currentThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        try {
            if (!(disguise.isDisguiseInUse() && player.isValid() && player.isOnline() && disguise.isSelfDisguiseVisible() && disguise.canSee(player))) {
                return;
            }
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry((Entity)player);
            if (entityTrackerEntry == null) {
                Bukkit.getScheduler().runTask((Plugin)libsDisguises, new Runnable(){

                    @Override
                    public void run() {
                        if (DisguiseAPI.getDisguise(player, (Entity)player) == disguise) {
                            DisguiseUtilities.sendSelfDisguise(player, disguise);
                        }
                    }
                });
                return;
            }
            Scoreboard scoreboard = player.getScoreboard();
            Team t = scoreboard.getTeam("LDPushing");
            if (t == null) {
                t = scoreboard.registerNewTeam("LDPushing");
                t.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
            }
            t.addEntry(player.getName());
            Object trackedPlayersObj = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry);
            if (DisguiseUtilities.isHashSet(trackedPlayersObj)) {
                ((Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(entityTrackerEntry)).add(ReflectionManager.getNmsEntity((Entity)player));
            } else {
                ((Map)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayerMap").get(entityTrackerEntry)).put(ReflectionManager.getNmsEntity((Entity)player), true);
            }
            ProtocolManager manager = ProtocolLibrary.getProtocolManager();
            manager.sendServerPacket(player, manager.createPacketConstructor(PacketType.Play.Server.NAMED_ENTITY_SPAWN, new Object[]{player}).createPacket(new Object[]{player}));
            WrappedDataWatcher dataWatcher = WrappedDataWatcher.getEntityWatcher((Entity)player);
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{player.getEntityId(), dataWatcher, true}).createPacket(new Object[]{player.getEntityId(), dataWatcher, true}));
            boolean isMoving = false;
            try {
                Field field = ReflectionManager.getNmsClass("EntityTrackerEntry").getDeclaredField("isMoving");
                field.setAccessible(true);
                isMoving = field.getBoolean(entityTrackerEntry);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (isMoving) {
                Vector velocity = player.getVelocity();
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_VELOCITY, new Object[]{player.getEntityId(), velocity.getX(), velocity.getY(), velocity.getZ()}).createPacket(new Object[]{player.getEntityId(), velocity.getX(), velocity.getY(), velocity.getZ()}));
            }
            if (player.getVehicle() != null && player.getEntityId() > player.getVehicle().getEntityId()) {
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ATTACH_ENTITY, new Object[]{0, player, player.getVehicle()}).createPacket(new Object[]{0, player, player.getVehicle()}));
            } else if (player.getPassenger() != null && player.getEntityId() > player.getPassenger().getEntityId()) {
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ATTACH_ENTITY, new Object[]{0, player.getPassenger(), player}).createPacket(new Object[]{0, player.getPassenger(), player}));
            }
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(player.getInventory().getHelmet())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.CHEST), ReflectionManager.getNmsItem(player.getInventory().getChestplate())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.LEGS), ReflectionManager.getNmsItem(player.getInventory().getLeggings())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.FEET), ReflectionManager.getNmsItem(player.getInventory().getBoots())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.HAND), ReflectionManager.getNmsItem(player.getInventory().getItemInMainHand())}));
            DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(EquipmentSlot.HEAD), ReflectionManager.getNmsItem(new ItemStack(Material.STONE))}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(EquipmentSlot.OFF_HAND), ReflectionManager.getNmsItem(player.getInventory().getItemInOffHand())}));
            Location loc = player.getLocation();
            if (player.isSleeping()) {
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.BED, new Object[]{player, ReflectionManager.getBlockPosition(0, 0, 0)}).createPacket(new Object[]{player, ReflectionManager.getBlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())}));
            }
            for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                Object mobEffect = ReflectionManager.createMobEffect(potionEffect);
                DisguiseUtilities.sendSelfPacket(player, manager.createPacketConstructor(PacketType.Play.Server.ENTITY_EFFECT, new Object[]{player.getEntityId(), mobEffect}).createPacket(new Object[]{player.getEntityId(), mobEffect}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static LibsDisguises getPlugin() {
        return libsDisguises;
    }

    private static void sendSelfPacket(final Player player, PacketContainer packet) {
        PacketContainer[][] transformed = PacketsManager.transformPacket(packet, player, (Entity)player);
        PacketContainer[] packets = transformed == null ? null : transformed[0];
        final PacketContainer[] delayed = transformed == null ? null : transformed[1];
        try {
            if (packets == null) {
                packets = new PacketContainer[]{packet};
            }
            for (PacketContainer p : packets) {
                p = p.deepClone();
                p.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, p, false);
            }
            if (delayed != null && delayed.length > 0) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)libsDisguises, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (PacketContainer packet : delayed) {
                                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
                            }
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void setupFakeDisguise(Disguise disguise) {
        Entity e = disguise.getEntity();
        if (!(e != null && e instanceof Player && DisguiseUtilities.getDisguises().containsKey(e.getUniqueId()) && DisguiseUtilities.getDisguises().get(e.getUniqueId()).contains(disguise))) {
            return;
        }
        Player player = (Player)e;
        if (!((TargetedDisguise)disguise).canSee(player)) {
            return;
        }
        DisguiseUtilities.removeSelfDisguise(player);
        if (!disguise.isSelfDisguiseVisible() || !PacketsManager.isViewDisguisesListenerEnabled() || player.getVehicle() != null) {
            return;
        }
        selfDisguised.add(player.getUniqueId());
        DisguiseUtilities.sendSelfDisguise(player, (TargetedDisguise)disguise);
        if ((disguise.isHidingArmorFromSelf() || disguise.isHidingHeldItemFromSelf()) && PacketsManager.isInventoryListenerEnabled()) {
            player.updateInventory();
        }
    }

    static {
        runnables = new HashMap();
        selfDisguised = new HashSet();
        try {
            Object server = ReflectionManager.getNmsMethod("MinecraftServer", "getServer", new Class[0]).invoke(null, new Object[0]);
            Object world = ((List)server.getClass().getField("worlds").get(server)).get(0);
            Object bedChunk = ReflectionManager.getNmsClass("Chunk").getConstructor(ReflectionManager.getNmsClass("World"), Integer.TYPE, Integer.TYPE).newInstance(world, 0, 0);
            Field cSection = bedChunk.getClass().getDeclaredField("sections");
            cSection.setAccessible(true);
            Object chunkSection = ReflectionManager.getNmsClass("ChunkSection").getConstructor(Integer.TYPE, Boolean.TYPE).newInstance(0, true);
            Object block = ReflectionManager.getNmsClass("Block").getMethod("getById", Integer.TYPE).invoke(null, Material.BED_BLOCK.getId());
            Method fromLegacyData = block.getClass().getMethod("fromLegacyData", Integer.TYPE);
            Method setType = chunkSection.getClass().getMethod("setType", Integer.TYPE, Integer.TYPE, Integer.TYPE, ReflectionManager.getNmsClass("IBlockData"));
            Method setSky = chunkSection.getClass().getMethod("a", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Method setEmitted = chunkSection.getClass().getMethod("b", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            for (BlockFace face : new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH}) {
                int x = 1 + face.getModX();
                int z = 1 + face.getModZ();
                setType.invoke(chunkSection, x, 0, z, fromLegacyData.invoke(block, face.ordinal()));
                setSky.invoke(chunkSection, x, 0, z, 0);
                setEmitted.invoke(chunkSection, x, 0, z, 0);
            }
            Object[] array = (Object[])Array.newInstance(chunkSection.getClass(), 16);
            array[0] = chunkSection;
            cSection.set(bedChunk, array);
            spawnChunk = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.MAP_CHUNK, new Object[]{bedChunk, 65535}).createPacket(new Object[]{bedChunk, 65535});
            Field threadField = ReflectionManager.getNmsField("MinecraftServer", "primaryThread");
            threadField.setAccessible(true);
            mainThread = (Thread)threadField.get(ReflectionManager.getMinecraftServer());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

