/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.google.common.base.Optional;
import java.util.UUID;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagType;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;

public class TameableWatcher
extends AgeableWatcher {
    public TameableWatcher(Disguise disguise) {
        super(disguise);
    }

    public Optional<UUID> getOwner() {
        return this.getValue(FlagType.TAMEABLE_OWNER);
    }

    public boolean isSitting() {
        return this.isTameableFlag(1);
    }

    public boolean isTamed() {
        return this.isTameableFlag(4);
    }

    protected boolean isTameableFlag(int no) {
        return (this.getValue(FlagType.TAMEABLE_META) & no) != 0;
    }

    protected void setTameableFlag(int no, boolean flag) {
        byte value = this.getValue(FlagType.TAMEABLE_META);
        if (flag) {
            this.setValue(FlagType.TAMEABLE_META, (byte)(value | no));
        } else {
            this.setValue(FlagType.TAMEABLE_META, (byte)(value & -(no + 1)));
        }
        this.sendData(FlagType.TAMEABLE_META);
    }

    public void setOwner(UUID owner) {
        this.setValue(FlagType.TAMEABLE_OWNER, Optional.of((Object)owner));
        this.sendData(FlagType.TAMEABLE_OWNER);
    }

    public void setSitting(boolean sitting) {
        this.setTameableFlag(1, sitting);
    }

    public void setTamed(boolean tamed) {
        this.setTameableFlag(4, tamed);
    }
}

