/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import org.bukkit.inventory.ItemStack;

public class MinecartWatcher
extends FlagWatcher {
    public MinecartWatcher(Disguise disguise) {
        super(disguise);
    }

    public ItemStack getBlockInCart() {
        int id = this.getValue(FlagType.MINECART_BLOCK) & 0xFFFF;
        int data = this.getValue(FlagType.MINECART_BLOCK) >> 16;
        return new ItemStack(id, 1, (short)data);
    }

    public int getBlockYOffset() {
        return this.getValue(FlagType.MINECART_BLOCK_Y);
    }

    public boolean isViewBlockInCart() {
        return this.getValue(FlagType.MINECART_BLOCK_VISIBLE);
    }

    public void setBlockInCart(ItemStack item) {
        int id = item.getTypeId();
        short data = item.getDurability();
        this.setValue(FlagType.MINECART_BLOCK, id & 0xFFFF | data << 16);
        this.setValue(FlagType.MINECART_BLOCK_VISIBLE, true);
        this.sendData(FlagType.MINECART_BLOCK);
    }

    public void setBlockOffset(int i) {
        this.setValue(FlagType.MINECART_BLOCK_Y, i);
        this.sendData(FlagType.MINECART_BLOCK_Y);
    }

    public void setViewBlockInCart(boolean viewBlock) {
        this.setValue(FlagType.MINECART_BLOCK_VISIBLE, viewBlock);
        this.sendData(FlagType.MINECART_BLOCK_VISIBLE);
    }
}

