/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import org.bukkit.util.EulerAngle;

public class ArmorStandWatcher
extends LivingWatcher {
    public ArmorStandWatcher(Disguise disguise) {
        super(disguise);
    }

    private boolean getArmorStandFlag(int value) {
        return (this.getValue(FlagType.ARMORSTAND_META) & value) != 0;
    }

    public EulerAngle getBody() {
        return this.getPose(FlagType.ARMORSTAND_BODY);
    }

    public EulerAngle getHead() {
        return this.getPose(FlagType.ARMORSTAND_HEAD);
    }

    public EulerAngle getLeftArm() {
        return this.getPose(FlagType.ARMORSTAND_LEFT_ARM);
    }

    public EulerAngle getLeftLeg() {
        return this.getPose(FlagType.ARMORSTAND_LEFT_LEG);
    }

    private EulerAngle getPose(FlagType<EulerAngle> type) {
        if (!this.hasValue(type)) {
            this.setValue(type, new EulerAngle(0.0, 0.0, 0.0));
        }
        return this.getValue(type);
    }

    public EulerAngle getRightArm() {
        return this.getPose(FlagType.ARMORSTAND_RIGHT_ARM);
    }

    public EulerAngle getRightLeg() {
        return this.getPose(FlagType.ARMORSTAND_RIGHT_LEG);
    }

    public boolean isMarker() {
        return this.getArmorStandFlag(10);
    }

    public boolean isNoBasePlate() {
        return this.getArmorStandFlag(8);
    }

    @Override
    public boolean isNoGravity() {
        return this.getArmorStandFlag(2);
    }

    public boolean isShowArms() {
        return this.getArmorStandFlag(4);
    }

    public boolean isSmall() {
        return this.getArmorStandFlag(1);
    }

    private void setArmorStandFlag(int value, boolean isTrue) {
        byte b1 = this.getValue(FlagType.ARMORSTAND_META);
        b1 = isTrue ? (byte)(b1 | value) : (byte)(b1 & value);
        this.setValue(FlagType.ARMORSTAND_META, b1);
        this.sendData(FlagType.ARMORSTAND_META);
    }

    public void setBody(EulerAngle vector) {
        this.setPose(FlagType.ARMORSTAND_BODY, vector);
    }

    public void setHead(EulerAngle vector) {
        this.setPose(FlagType.ARMORSTAND_HEAD, vector);
    }

    public void setLeftArm(EulerAngle vector) {
        this.setPose(FlagType.ARMORSTAND_LEFT_ARM, vector);
    }

    public void setLeftLeg(EulerAngle vector) {
        this.setPose(FlagType.ARMORSTAND_LEFT_LEG, vector);
    }

    public void setMarker(boolean isMarker) {
        this.setArmorStandFlag(10, isMarker);
        this.sendData(FlagType.ARMORSTAND_META);
    }

    public void setNoBasePlate(boolean noBasePlate) {
        this.setArmorStandFlag(8, noBasePlate);
        this.sendData(FlagType.ARMORSTAND_META);
    }

    @Override
    public void setNoGravity(boolean noGravity) {
        this.setArmorStandFlag(2, noGravity);
        this.sendData(FlagType.ARMORSTAND_META);
    }

    private void setPose(FlagType type, EulerAngle vector) {
        this.setValue(type, vector);
        this.sendData(type);
    }

    public void setRightArm(EulerAngle vector) {
        this.setPose(FlagType.ARMORSTAND_RIGHT_ARM, vector);
    }

    public void setRightLeg(EulerAngle vector) {
        this.setPose(FlagType.ARMORSTAND_RIGHT_LEG, vector);
    }

    public void setShowArms(boolean showArms) {
        this.setArmorStandFlag(4, showArms);
        this.sendData(FlagType.ARMORSTAND_META);
    }

    public void setSmall(boolean isSmall) {
        this.setArmorStandFlag(1, isSmall);
        this.sendData(FlagType.ARMORSTAND_META);
    }
}

