/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerDisguise
extends TargetedDisguise {
    private LibsProfileLookup currentLookup;
    private WrappedGameProfile gameProfile;
    private String playerName;
    private String skinToUse;

    private PlayerDisguise() {
    }

    public PlayerDisguise(Player player) {
        this(ReflectionManager.getGameProfile(player));
    }

    public PlayerDisguise(Player player, Player skinToUse) {
        this(ReflectionManager.getGameProfile(player), ReflectionManager.getGameProfile(skinToUse));
    }

    public PlayerDisguise(String name) {
        this.setName(name);
        this.setSkin(name);
        this.createDisguise(DisguiseType.PLAYER);
    }

    public PlayerDisguise(String name, String skinToUse) {
        this.setName(name);
        this.setSkin(skinToUse);
        this.createDisguise(DisguiseType.PLAYER);
    }

    public PlayerDisguise(WrappedGameProfile gameProfile) {
        this.setName(gameProfile.getName());
        this.gameProfile = gameProfile;
        this.createDisguise(DisguiseType.PLAYER);
    }

    public PlayerDisguise(WrappedGameProfile gameProfile, WrappedGameProfile skinToUse) {
        this.setName(gameProfile.getName());
        this.gameProfile = gameProfile;
        this.setSkin(skinToUse);
        this.createDisguise(DisguiseType.PLAYER);
    }

    @Override
    public PlayerDisguise addPlayer(Player player) {
        return (PlayerDisguise)super.addPlayer(player);
    }

    @Override
    public PlayerDisguise addPlayer(String playername) {
        return (PlayerDisguise)super.addPlayer(playername);
    }

    @Override
    public PlayerDisguise clone() {
        PlayerDisguise disguise = new PlayerDisguise();
        disguise.playerName = this.getName();
        if (disguise.currentLookup == null && disguise.gameProfile != null) {
            disguise.skinToUse = this.getSkin();
            disguise.gameProfile = ReflectionManager.getClonedProfile(this.getGameProfile());
        } else {
            disguise.setSkin(this.getSkin());
        }
        disguise.setReplaceSounds(this.isSoundsReplaced());
        disguise.setViewSelfDisguise(this.isSelfDisguiseVisible());
        disguise.setHearSelfDisguise(this.isSelfDisguiseSoundsReplaced());
        disguise.setHideArmorFromSelf(this.isHidingArmorFromSelf());
        disguise.setHideHeldItemFromSelf(this.isHidingHeldItemFromSelf());
        disguise.setVelocitySent(this.isVelocitySent());
        disguise.setModifyBoundingBox(this.isModifyBoundingBox());
        disguise.setWatcher(this.getWatcher().clone(disguise));
        disguise.createDisguise(DisguiseType.PLAYER);
        return disguise;
    }

    public WrappedGameProfile getGameProfile() {
        if (this.gameProfile == null) {
            this.gameProfile = this.getSkin() != null ? ReflectionManager.getGameProfile(null, this.getName()) : ReflectionManager.getGameProfileWithThisSkin(null, this.getName(), DisguiseUtilities.getProfileFromMojang(this));
        }
        return this.gameProfile;
    }

    public String getName() {
        return this.playerName;
    }

    public String getSkin() {
        return this.skinToUse;
    }

    @Override
    public PlayerWatcher getWatcher() {
        return (PlayerWatcher)super.getWatcher();
    }

    @Override
    public boolean isPlayerDisguise() {
        return true;
    }

    @Override
    public PlayerDisguise removePlayer(Player player) {
        return (PlayerDisguise)super.removePlayer(player);
    }

    @Override
    public PlayerDisguise removePlayer(String playername) {
        return (PlayerDisguise)super.removePlayer(playername);
    }

    @Override
    public PlayerDisguise setDisguiseTarget(TargetedDisguise.TargetType newTargetType) {
        return (PlayerDisguise)super.setDisguiseTarget(newTargetType);
    }

    @Override
    public PlayerDisguise setEntity(Entity entity) {
        return (PlayerDisguise)super.setEntity(entity);
    }

    public void setGameProfile(WrappedGameProfile gameProfile) {
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(null, gameProfile.getName(), gameProfile);
    }

    @Override
    public PlayerDisguise setHearSelfDisguise(boolean hearSelfDisguise) {
        return (PlayerDisguise)super.setHearSelfDisguise(hearSelfDisguise);
    }

    @Override
    public PlayerDisguise setHideArmorFromSelf(boolean hideArmor) {
        return (PlayerDisguise)super.setHideArmorFromSelf(hideArmor);
    }

    @Override
    public PlayerDisguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        return (PlayerDisguise)super.setHideHeldItemFromSelf(hideHeldItem);
    }

    @Override
    public PlayerDisguise setKeepDisguiseOnEntityDespawn(boolean keepDisguise) {
        return (PlayerDisguise)super.setKeepDisguiseOnEntityDespawn(keepDisguise);
    }

    @Override
    public PlayerDisguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        return (PlayerDisguise)super.setKeepDisguiseOnPlayerDeath(keepDisguise);
    }

    @Override
    public PlayerDisguise setKeepDisguiseOnPlayerLogout(boolean keepDisguise) {
        return (PlayerDisguise)super.setKeepDisguiseOnPlayerLogout(keepDisguise);
    }

    @Override
    public PlayerDisguise setModifyBoundingBox(boolean modifyBox) {
        return (PlayerDisguise)super.setModifyBoundingBox(modifyBox);
    }

    private void setName(String name) {
        if (name.length() > 16) {
            name = name.substring(0, 16);
        }
        this.playerName = name;
    }

    @Override
    public PlayerDisguise setReplaceSounds(boolean areSoundsReplaced) {
        return (PlayerDisguise)super.setReplaceSounds(areSoundsReplaced);
    }

    public PlayerDisguise setSkin(String newSkin) {
        this.skinToUse = newSkin;
        if (newSkin == null) {
            this.currentLookup = null;
            this.gameProfile = null;
        } else {
            if (newSkin.length() > 16) {
                this.skinToUse = newSkin.substring(0, 16);
            }
            this.currentLookup = new LibsProfileLookup(){

                @Override
                public void onLookup(WrappedGameProfile gameProfile) {
                    if (PlayerDisguise.this.currentLookup != this || gameProfile == null) {
                        return;
                    }
                    PlayerDisguise.this.setSkin(gameProfile);
                    PlayerDisguise.this.currentLookup = null;
                }
            };
            WrappedGameProfile gameProfile = DisguiseUtilities.getProfileFromMojang(this.skinToUse, this.currentLookup, LibsDisguises.getInstance().getConfig().getBoolean("ContactMojangServers", true));
            if (gameProfile != null) {
                this.setSkin(gameProfile);
            }
        }
        return this;
    }

    public PlayerDisguise setSkin(WrappedGameProfile gameProfile) {
        if (gameProfile == null) {
            this.gameProfile = null;
            this.skinToUse = null;
            return this;
        }
        Validate.notEmpty((String)gameProfile.getName(), (String)"Name must be set");
        this.currentLookup = null;
        this.skinToUse = gameProfile.getName();
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(null, this.getName(), gameProfile);
        if (DisguiseUtilities.isDisguiseInUse(this)) {
            DisguiseUtilities.refreshTrackers(this);
        }
        return this;
    }

    @Override
    public PlayerDisguise setVelocitySent(boolean sendVelocity) {
        return (PlayerDisguise)super.setVelocitySent(sendVelocity);
    }

    @Override
    public PlayerDisguise setViewSelfDisguise(boolean viewSelfDisguise) {
        return (PlayerDisguise)super.setViewSelfDisguise(viewSelfDisguise);
    }

    @Override
    public PlayerDisguise setWatcher(FlagWatcher newWatcher) {
        return (PlayerDisguise)super.setWatcher(newWatcher);
    }

    @Override
    public PlayerDisguise silentlyAddPlayer(String playername) {
        return (PlayerDisguise)super.silentlyAddPlayer(playername);
    }

    @Override
    public PlayerDisguise silentlyRemovePlayer(String playername) {
        return (PlayerDisguise)super.silentlyRemovePlayer(playername);
    }
}

