/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;

public enum DisguiseType {
    AREA_EFFECT_CLOUD(3, 0),
    ARMOR_STAND(78),
    ARROW(60, 0),
    BAT(new int[0]),
    BLAZE(new int[0]),
    BOAT(1),
    CAVE_SPIDER(new int[0]),
    CHICKEN(new int[0]),
    COW(new int[0]),
    CREEPER(new int[0]),
    DONKEY(new int[0]),
    DRAGON_FIREBALL(93),
    DROPPED_ITEM(2, 1),
    EGG(62),
    ELDER_GUARDIAN(new int[0]),
    ENDER_CRYSTAL(51),
    ENDER_DRAGON(new int[0]),
    ENDER_PEARL(65),
    ENDER_SIGNAL(72),
    ENDERMAN(new int[0]),
    ENDERMITE(new int[0]),
    EXPERIENCE_ORB(new int[0]),
    FALLING_BLOCK(70, 1),
    FIREBALL(63),
    FIREWORK(76),
    FISHING_HOOK(90),
    GHAST(new int[0]),
    GIANT(new int[0]),
    GUARDIAN(new int[0]),
    HORSE(new int[0]),
    HUSK(new int[0]),
    IRON_GOLEM(new int[0]),
    ITEM_FRAME(71),
    LEASH_HITCH(77),
    MAGMA_CUBE(new int[0]),
    MINECART(10),
    MINECART_CHEST(10, 1),
    MINECART_COMMAND(10, 6),
    MINECART_FURNACE(10, 2),
    MINECART_HOPPER(10, 5),
    MINECART_MOB_SPAWNER(10, 4),
    MINECART_TNT(10, 3),
    MULE(new int[0]),
    MUSHROOM_COW(new int[0]),
    OCELOT(new int[0]),
    PAINTING(new int[0]),
    PIG(new int[0]),
    PIG_ZOMBIE(new int[0]),
    PLAYER(new int[0]),
    POLAR_BEAR(new int[0]),
    PRIMED_TNT(50),
    RABBIT(new int[0]),
    SHEEP(new int[0]),
    SHULKER(new int[0]),
    SHULKER_BULLET(67),
    SILVERFISH(new int[0]),
    SKELETON(new int[0]),
    SKELETON_HORSE(new int[0]),
    SLIME(new int[0]),
    SMALL_FIREBALL(63),
    SNOWBALL(61),
    SNOWMAN(new int[0]),
    SPECTRAL_ARROW(91),
    SPIDER(new int[0]),
    SPLASH_POTION(73, 0),
    SQUID(new int[0]),
    STRAY(new int[0]),
    THROWN_EXP_BOTTLE(75),
    TIPPED_ARROW(92),
    UNDEAD_HORSE(new int[0]),
    UNKNOWN(new int[0]),
    VILLAGER(new int[0]),
    WITCH(new int[0]),
    WITHER(new int[0]),
    WITHER_SKELETON(new int[0]),
    WITHER_SKULL(66),
    WOLF(new int[0]),
    ZOMBIE(new int[0]),
    ZOMBIE_VILLAGER(new int[0]);

    private EntityType entityType;
    private int objectId = -1;
    private int defaultData = 0;
    private Class<? extends FlagWatcher> watcherClass;

    public static DisguiseType getType(Entity entity) {
        DisguiseType disguiseType = DisguiseType.getType(entity.getType());
        switch (disguiseType) {
            case ZOMBIE: {
                if (!((Zombie)entity).isVillager()) break;
                disguiseType = ZOMBIE_VILLAGER;
                break;
            }
            case HORSE: {
                disguiseType = DisguiseType.valueOf(((Horse)entity).getVariant().name());
                break;
            }
            case SKELETON: {
                if (((Skeleton)entity).getSkeletonType() != Skeleton.SkeletonType.WITHER) break;
                disguiseType = WITHER_SKELETON;
                break;
            }
            case GUARDIAN: {
                if (!((Guardian)entity).isElder()) break;
                disguiseType = ELDER_GUARDIAN;
                break;
            }
        }
        return disguiseType;
    }

    public static DisguiseType getType(EntityType entityType) {
        try {
            return DisguiseType.valueOf(entityType.name().toUpperCase());
        }
        catch (Throwable ex) {
            return UNKNOWN;
        }
    }

    private DisguiseType(int ... ints) {
        block4: for (int i = 0; i < ints.length; ++i) {
            int value = ints[i];
            switch (i) {
                case 0: {
                    this.objectId = value;
                    continue block4;
                }
                case 1: {
                    this.defaultData = value;
                    continue block4;
                }
            }
        }
    }

    public int getDefaultData() {
        return this.defaultData;
    }

    public Class<? extends Entity> getEntityClass() {
        if (this.entityType != null) {
            return this.getEntityType().getEntityClass();
        }
        return Entity.class;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public int getTypeId() {
        return this.getEntityType().getTypeId();
    }

    public Class<? extends FlagWatcher> getWatcherClass() {
        return this.watcherClass;
    }

    public boolean isMisc() {
        return this.getEntityType() != null && !this.getEntityType().isAlive();
    }

    public boolean isMob() {
        return this.getEntityType() != null && this.getEntityType().isAlive() && !this.isPlayer();
    }

    public boolean isPlayer() {
        return this == PLAYER;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    private void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setWatcherClass(Class<? extends FlagWatcher> c) {
        this.watcherClass = c;
    }

    public String toReadable() {
        Object[] split = this.name().split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = ((String)split[i]).substring(0, 1) + ((String)split[i]).substring(1).toLowerCase();
        }
        return StringUtils.join((Object[])split, (String)" ");
    }

    static {
        for (DisguiseType type : DisguiseType.values()) {
            try {
                DisguiseType toUse = type;
                switch (type) {
                    case ITEM_FRAME: {
                        break;
                    }
                    case DONKEY: 
                    case MULE: 
                    case UNDEAD_HORSE: 
                    case SKELETON_HORSE: {
                        toUse = HORSE;
                        break;
                    }
                    case ZOMBIE_VILLAGER: 
                    case HUSK: {
                        toUse = ZOMBIE;
                        break;
                    }
                    case WITHER_SKELETON: 
                    case STRAY: {
                        toUse = SKELETON;
                        break;
                    }
                    case ELDER_GUARDIAN: {
                        toUse = GUARDIAN;
                        break;
                    }
                }
                String name = toUse.name();
                type.setEntityType(EntityType.valueOf((String)name));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

