/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.BatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GuardianWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.HorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SkeletonWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.events.DisguiseEvent;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.PacketsManager;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public abstract class Disguise {
    private boolean disguiseInUse;
    private DisguiseType disguiseType;
    private Entity entity;
    private boolean hearSelfDisguise = DisguiseConfig.isSelfDisguisesSoundsReplaced();
    private boolean hideArmorFromSelf = DisguiseConfig.isHidingArmorFromSelf();
    private boolean hideHeldItemFromSelf = DisguiseConfig.isHidingHeldItemFromSelf();
    private boolean keepDisguiseEntityDespawn = DisguiseConfig.isKeepDisguiseOnEntityDespawn();
    private boolean keepDisguisePlayerDeath = DisguiseConfig.isKeepDisguiseOnPlayerDeath();
    private boolean keepDisguisePlayerLogout = DisguiseConfig.isKeepDisguiseOnPlayerLogout();
    private boolean modifyBoundingBox = DisguiseConfig.isModifyBoundingBox();
    private boolean replaceSounds = DisguiseConfig.isSoundEnabled();
    private BukkitTask task;
    private Runnable velocityRunnable;
    private boolean velocitySent = DisguiseConfig.isVelocitySent();
    private boolean viewSelfDisguise = DisguiseConfig.isViewDisguises();
    private FlagWatcher watcher;
    private boolean showName = false;
    private static List<UUID> viewSelf = new ArrayList<UUID>();

    public abstract Disguise clone();

    protected void createDisguise(DisguiseType newType) {
        boolean alwaysSendVelocity;
        if (this.getWatcher() != null) {
            return;
        }
        if (newType.getEntityType() == null) {
            throw new RuntimeException("DisguiseType " + (Object)((Object)newType) + " was used in a futile attempt to construct a disguise, but this Minecraft version does not have that entity");
        }
        this.disguiseType = newType;
        boolean isAdult = true;
        if (this.isMobDisguise()) {
            isAdult = ((MobDisguise)this).isAdult();
        }
        try {
            this.setWatcher(this.getType().getWatcherClass().getConstructor(Disguise.class).newInstance(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!isAdult) {
            if (this.getWatcher() instanceof AgeableWatcher) {
                ((AgeableWatcher)this.getWatcher()).setBaby(true);
            } else if (this.getWatcher() instanceof ZombieWatcher) {
                ((ZombieWatcher)this.getWatcher()).setBaby(true);
            }
        }
        if (this.getType() == DisguiseType.WITHER_SKELETON) {
            ((SkeletonWatcher)this.getWatcher()).setType(Skeleton.SkeletonType.WITHER);
        } else if (this.getType() == DisguiseType.STRAY) {
            ((SkeletonWatcher)this.getWatcher()).setType(Skeleton.SkeletonType.STRAY);
        } else if (this.getType() == DisguiseType.ZOMBIE_VILLAGER) {
            Villager.Profession profession = null;
            while (profession == null || profession == Villager.Profession.NORMAL || profession == Villager.Profession.HUSK) {
                profession = Villager.Profession.values()[DisguiseUtilities.random.nextInt(Villager.Profession.values().length)];
            }
            ((ZombieWatcher)this.getWatcher()).setProfession(profession);
        } else if (this.getType() == DisguiseType.HUSK) {
            ((ZombieWatcher)this.getWatcher()).setProfession(Villager.Profession.HUSK);
        } else if (this.getType() == DisguiseType.ELDER_GUARDIAN) {
            ((GuardianWatcher)this.getWatcher()).setElder(true);
        } else if (this.getWatcher() instanceof HorseWatcher) {
            try {
                Horse.Variant horseType = Horse.Variant.valueOf((String)this.getType().name());
                ((HorseWatcher)this.getWatcher()).setVariant(horseType);
            }
            catch (Exception horseType) {
                // empty catch block
            }
        }
        switch (this.getType()) {
            case EGG: 
            case ENDER_PEARL: 
            case BAT: 
            case EXPERIENCE_ORB: 
            case FIREBALL: 
            case SMALL_FIREBALL: 
            case SNOWBALL: 
            case SPLASH_POTION: 
            case THROWN_EXP_BOTTLE: 
            case WITHER_SKULL: 
            case FIREWORK: {
                alwaysSendVelocity = true;
                break;
            }
            default: {
                alwaysSendVelocity = false;
            }
        }
        double velocitySpeed = 5.0E-4;
        switch (this.getType()) {
            case FIREWORK: {
                velocitySpeed = -0.04;
                break;
            }
            case WITHER_SKULL: {
                velocitySpeed = 1.0E-6;
                break;
            }
            case ARROW: 
            case TIPPED_ARROW: 
            case SPECTRAL_ARROW: 
            case BOAT: 
            case ENDER_CRYSTAL: 
            case ENDER_DRAGON: 
            case GHAST: 
            case ITEM_FRAME: 
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: 
            case PAINTING: 
            case PLAYER: 
            case SQUID: {
                velocitySpeed = 0.0;
                break;
            }
            case DROPPED_ITEM: 
            case PRIMED_TNT: 
            case WITHER: 
            case FALLING_BLOCK: {
                velocitySpeed = 0.04;
                break;
            }
            case EXPERIENCE_ORB: {
                velocitySpeed = 0.0221;
                break;
            }
            case BAT: 
            case SPIDER: 
            case CAVE_SPIDER: {
                velocitySpeed = 0.004;
                break;
            }
        }
        final double vectorY = velocitySpeed;
        final TargetedDisguise disguise = (TargetedDisguise)this;
        this.velocityRunnable = new Runnable(){
            private int blockX;
            private int blockY;
            private int blockZ;
            private int facing;
            private int deadTicks = 0;
            private int refreshDisguise = 0;

            @Override
            public void run() {
                if (!Disguise.this.getEntity().isValid()) {
                    if (this.deadTicks++ > (Disguise.this.getType() == DisguiseType.ENDER_DRAGON ? 200 : 20)) {
                        this.deadTicks = 0;
                        if (Disguise.this.isRemoveDisguiseOnDeath()) {
                            Disguise.this.removeDisguise();
                        } else {
                            Disguise.this.entity = null;
                            Disguise.this.watcher = Disguise.this.getWatcher().clone(disguise);
                            Disguise.this.task.cancel();
                            Disguise.this.task = null;
                        }
                    }
                } else {
                    this.deadTicks = 0;
                    if (Disguise.this.getType() == DisguiseType.FIREWORK) {
                        ++this.refreshDisguise;
                        if (this.refreshDisguise % 40 == 0) {
                            this.refreshDisguise = 0;
                            DisguiseUtilities.refreshTrackers(disguise);
                        }
                    }
                    if (Disguise.this.getType() == DisguiseType.ITEM_FRAME) {
                        Location loc = Disguise.this.getEntity().getLocation();
                        int newFacing = ((int)loc.getYaw() + 720 + 45) / 90 % 4;
                        if (loc.getBlockX() != this.blockX || loc.getBlockY() != this.blockY || loc.getBlockZ() != this.blockZ || newFacing != this.facing) {
                            this.blockX = loc.getBlockX();
                            this.blockY = loc.getBlockY();
                            this.blockZ = loc.getBlockZ();
                            this.facing = newFacing;
                            DisguiseUtilities.refreshTrackers(disguise);
                        }
                    }
                    if (Disguise.this.isModifyBoundingBox()) {
                        DisguiseUtilities.doBoundingBox(disguise);
                    }
                    if (Disguise.this.getType() == DisguiseType.BAT && !((BatWatcher)Disguise.this.getWatcher()).isHanging()) {
                        return;
                    }
                    if (Disguise.this.isVelocitySent() && vectorY != 0.0 && (alwaysSendVelocity || !Disguise.this.getEntity().isOnGround())) {
                        Vector vector = Disguise.this.getEntity().getVelocity();
                        if (!(vector.getY() == 0.0 || vector.getY() < 0.0 && alwaysSendVelocity && Disguise.this.getEntity().isOnGround())) {
                            return;
                        }
                        if (Disguise.this.getType() != DisguiseType.EXPERIENCE_ORB || !Disguise.this.getEntity().isOnGround()) {
                            PacketContainer lookPacket = null;
                            if (Disguise.this.getType() == DisguiseType.WITHER_SKULL && DisguiseConfig.isWitherSkullPacketsEnabled()) {
                                lookPacket = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
                                StructureModifier mods = lookPacket.getModifier();
                                lookPacket.getIntegers().write(0, (Object)Disguise.this.getEntity().getEntityId());
                                Location loc = Disguise.this.getEntity().getLocation();
                                mods.write(4, (Object)PacketsManager.getYaw(Disguise.this.getType(), Disguise.this.getEntity().getType(), (byte)Math.floor(loc.getYaw() * 256.0f / 360.0f)));
                                mods.write(5, (Object)PacketsManager.getPitch(Disguise.this.getType(), DisguiseType.getType(Disguise.this.getEntity().getType()), (byte)Math.floor(loc.getPitch() * 256.0f / 360.0f)));
                                if (Disguise.this.isSelfDisguiseVisible() && Disguise.this.getEntity() instanceof Player) {
                                    PacketContainer selfLookPacket = lookPacket.shallowClone();
                                    selfLookPacket.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                                    try {
                                        ProtocolLibrary.getProtocolManager().sendServerPacket((Player)Disguise.this.getEntity(), selfLookPacket, false);
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            try {
                                PacketContainer velocityPacket = new PacketContainer(PacketType.Play.Server.ENTITY_VELOCITY);
                                StructureModifier mods = velocityPacket.getIntegers();
                                mods.write(1, (Object)((int)(vector.getX() * 8000.0)));
                                mods.write(3, (Object)((int)(vector.getZ() * 8000.0)));
                                for (Player player : DisguiseUtilities.getPerverts(disguise)) {
                                    if (Disguise.this.getEntity() == player) {
                                        if (!Disguise.this.isSelfDisguiseVisible()) continue;
                                        mods.write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                                    } else {
                                        mods.write(0, (Object)Disguise.this.getEntity().getEntityId());
                                    }
                                    mods.write(2, (Object)((int)(8000.0 * (vectorY * ReflectionManager.getPing(player)) * 0.069)));
                                    if (lookPacket != null && player != Disguise.this.getEntity()) {
                                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, lookPacket, false);
                                    }
                                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, velocityPacket.shallowClone(), false);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (Disguise.this.getType() == DisguiseType.EXPERIENCE_ORB) {
                        PacketContainer packet = new PacketContainer(PacketType.Play.Server.REL_ENTITY_MOVE);
                        packet.getIntegers().write(0, (Object)Disguise.this.getEntity().getEntityId());
                        try {
                            for (Player player : DisguiseUtilities.getPerverts(disguise)) {
                                if (Disguise.this.getEntity() != player) {
                                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
                                    continue;
                                }
                                if (!Disguise.this.isSelfDisguiseVisible()) continue;
                                PacketContainer selfPacket = packet.shallowClone();
                                selfPacket.getModifier().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                                try {
                                    ProtocolLibrary.getProtocolManager().sendServerPacket((Player)Disguise.this.getEntity(), selfPacket, false);
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
    }

    public Entity getEntity() {
        return this.entity;
    }

    public DisguiseType getType() {
        return this.disguiseType;
    }

    public FlagWatcher getWatcher() {
        return this.watcher;
    }

    public boolean isDisguiseInUse() {
        return this.disguiseInUse;
    }

    public boolean isHidingArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    public boolean isHidingHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    public boolean isKeepDisguiseOnEntityDespawn() {
        return this.keepDisguiseEntityDespawn;
    }

    public boolean isKeepDisguiseOnPlayerDeath() {
        return this.keepDisguisePlayerDeath;
    }

    public boolean isKeepDisguiseOnPlayerLogout() {
        return this.keepDisguisePlayerLogout;
    }

    public boolean isMiscDisguise() {
        return false;
    }

    public boolean isMobDisguise() {
        return false;
    }

    public boolean isModifyBoundingBox() {
        return this.modifyBoundingBox;
    }

    public boolean isPlayerDisguise() {
        return false;
    }

    public boolean isRemoveDisguiseOnDeath() {
        return this.getEntity() == null || (this.getEntity() instanceof Player ? (!((Player)this.getEntity()).isOnline() ? !this.isKeepDisguiseOnPlayerLogout() : !this.isKeepDisguiseOnPlayerDeath()) : !this.isKeepDisguiseOnEntityDespawn() || this.getEntity().isDead());
    }

    public boolean isSelfDisguiseSoundsReplaced() {
        return this.hearSelfDisguise;
    }

    public boolean isSelfDisguiseVisible() {
        return this.viewSelfDisguise;
    }

    public boolean isSoundsReplaced() {
        return this.replaceSounds;
    }

    public boolean isVelocitySent() {
        return this.velocitySent;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public boolean removeDisguise() {
        if (this.disguiseInUse) {
            UndisguiseEvent event = new UndisguiseEvent(this.entity, this);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.disguiseInUse = false;
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
                HashMap<UUID, HashSet<TargetedDisguise>> disguises = DisguiseUtilities.getDisguises();
                if (this.getEntity() != null) {
                    if (DisguiseUtilities.removeDisguise((TargetedDisguise)this)) {
                        if (this.getEntity() instanceof Player) {
                            DisguiseUtilities.removeSelfDisguise((Player)this.getEntity());
                        }
                        if (this.getEntity().isValid()) {
                            DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
                        } else {
                            DisguiseUtilities.destroyEntity((TargetedDisguise)this);
                        }
                    }
                } else {
                    HashMap<Integer, HashSet<TargetedDisguise>> future = DisguiseUtilities.getFutureDisguises();
                    Iterator<Integer> itel = DisguiseUtilities.getFutureDisguises().keySet().iterator();
                    while (itel.hasNext()) {
                        int id = itel.next();
                        if (!future.get(id).remove(this) || !future.get(id).isEmpty()) continue;
                        itel.remove();
                    }
                }
                if (this.isPlayerDisguise()) {
                    String name = ((PlayerDisguise)this).getName();
                    if (!DisguiseUtilities.getAddedByPlugins().contains(name.toLowerCase())) {
                        for (HashSet<TargetedDisguise> disguise : disguises.values()) {
                            for (Disguise disguise2 : disguise) {
                                if (!disguise2.isPlayerDisguise() || !((PlayerDisguise)disguise2).getName().equals(name)) continue;
                                return true;
                            }
                        }
                        DisguiseUtilities.getGameProfiles().remove(name.toLowerCase());
                    }
                }
                return true;
            }
        }
        return false;
    }

    public Disguise setEntity(Entity entity) {
        if (this.getEntity() != null) {
            if (this.getEntity() == entity) {
                return this;
            }
            throw new RuntimeException("This disguise is already in use! Try .clone()");
        }
        if (this.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
            throw new RuntimeException("Cannot disguise a living entity with a misc disguise. Reenable MiscDisguisesForLiving in the config to do this");
        }
        this.entity = entity;
        this.setupWatcher();
        return this;
    }

    public Disguise setShowName(boolean showName) {
        this.showName = showName;
        return this;
    }

    public Disguise setHearSelfDisguise(boolean hearSelfDisguise) {
        this.hearSelfDisguise = hearSelfDisguise;
        return this;
    }

    public Disguise setHideArmorFromSelf(boolean hideArmor) {
        this.hideArmorFromSelf = hideArmor;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public Disguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        this.hideHeldItemFromSelf = hideHeldItem;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public Disguise setKeepDisguiseOnEntityDespawn(boolean keepDisguise) {
        this.keepDisguiseEntityDespawn = keepDisguise;
        return this;
    }

    public Disguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        this.keepDisguisePlayerDeath = keepDisguise;
        return this;
    }

    public Disguise setKeepDisguiseOnPlayerLogout(boolean keepDisguise) {
        this.keepDisguisePlayerLogout = keepDisguise;
        return this;
    }

    public Disguise setModifyBoundingBox(boolean modifyBox) {
        if (((TargetedDisguise)this).getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) {
            throw new RuntimeException("Cannot modify the bounding box of a disguise which is not TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS");
        }
        if (this.isModifyBoundingBox() != modifyBox) {
            this.modifyBoundingBox = modifyBox;
            if (DisguiseUtilities.isDisguiseInUse(this)) {
                DisguiseUtilities.doBoundingBox((TargetedDisguise)this);
            }
        }
        return this;
    }

    public Disguise setReplaceSounds(boolean areSoundsReplaced) {
        this.replaceSounds = areSoundsReplaced;
        return this;
    }

    private void setupWatcher() {
        ArrayList<FlagType> disguiseFlags = FlagType.getFlags(this.getType().getWatcherClass());
        ArrayList<FlagType> entityFlags = FlagType.getFlags(DisguiseType.getType(this.getEntity().getType()).getWatcherClass());
        for (FlagType flag : entityFlags) {
            if (disguiseFlags.contains(flag)) continue;
            FlagType backup = null;
            for (FlagType flagType : disguiseFlags) {
                if (flagType.getIndex() != flag.getIndex()) continue;
                backup = flagType;
            }
            this.getWatcher().setBackupValue(flag, backup == null ? null : backup.getDefault());
        }
        this.getWatcher().setNoGravity(true);
    }

    public Disguise setVelocitySent(boolean sendVelocity) {
        this.velocitySent = sendVelocity;
        return this;
    }

    public Disguise setViewSelfDisguise(boolean viewSelfDisguise) {
        if (this.isSelfDisguiseVisible() != viewSelfDisguise) {
            this.viewSelfDisguise = viewSelfDisguise;
            if (this.getEntity() != null && this.getEntity() instanceof Player && DisguiseAPI.getDisguise((Player)this.getEntity(), this.getEntity()) == this) {
                if (this.isSelfDisguiseVisible()) {
                    DisguiseUtilities.setupFakeDisguise(this);
                } else {
                    DisguiseUtilities.removeSelfDisguise((Player)this.getEntity());
                }
            }
        }
        return this;
    }

    public Disguise setWatcher(FlagWatcher newWatcher) {
        if (!this.getType().getWatcherClass().isInstance(newWatcher)) {
            throw new IllegalArgumentException(newWatcher.getClass().getSimpleName() + " is not a instance of " + this.getType().getWatcherClass().getSimpleName() + " for DisguiseType " + this.getType().name());
        }
        this.watcher = newWatcher;
        if (this.getEntity() != null) {
            this.setupWatcher();
        }
        return this;
    }

    public boolean startDisguise() {
        if (!this.isDisguiseInUse()) {
            if (this.getEntity() == null) {
                throw new RuntimeException("No entity is assigned to this disguise!");
            }
            DisguiseEvent event = new DisguiseEvent(this.entity, this);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.disguiseInUse = true;
                this.task = Bukkit.getScheduler().runTaskTimer((Plugin)LibsDisguises.getInstance(), this.velocityRunnable, 1L, 1L);
                DisguiseUtilities.addDisguise(this.entity.getUniqueId(), (TargetedDisguise)this);
                if (this.isSelfDisguiseVisible() && this.getEntity() instanceof Player) {
                    DisguiseUtilities.removeSelfDisguise((Player)this.getEntity());
                }
                DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        DisguiseUtilities.setupFakeDisguise(Disguise.this);
                    }
                }, 2L);
                return true;
            }
        }
        return false;
    }

    public boolean stopDisguise() {
        return this.removeDisguise();
    }

    public static List<UUID> getViewSelf() {
        return viewSelf;
    }
}

