/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.RabbitType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.potion.PotionEffectType;

public abstract class BaseDisguiseCommand
implements CommandExecutor {
    protected ArrayList<String> getAllowedDisguises(HashMap<DisguiseType, HashMap<ArrayList<String>, Boolean>> hashMap) {
        ArrayList<String> allowedDisguises = new ArrayList<String>();
        for (DisguiseType type : hashMap.keySet()) {
            allowedDisguises.add(type.toReadable().replace(" ", "_"));
        }
        Collections.sort(allowedDisguises, String.CASE_INSENSITIVE_ORDER);
        return allowedDisguises;
    }

    protected HashMap<DisguiseType, HashMap<ArrayList<String>, Boolean>> getPermissions(CommandSender sender) {
        return this.getPermissions(sender, "libsdisguises." + this.getClass().getSimpleName().replace("Command", "").toLowerCase() + ".");
    }

    protected HashMap<String, Boolean> getDisguiseOptions(CommandSender sender, DisguiseType type) {
        switch (type) {
            case PLAYER: 
            case FALLING_BLOCK: 
            case PAINTING: 
            case SPLASH_POTION: 
            case FISHING_HOOK: 
            case DROPPED_ITEM: {
                HashMap<String, Boolean> returns = new HashMap<String, Boolean>();
                String beginning = "libsdisguises.options." + this.getClass().getSimpleName().toLowerCase().replace("command", "") + ".";
                for (PermissionAttachmentInfo permission : sender.getEffectivePermissions()) {
                    String[] split;
                    String lowerPerm = permission.getPermission().toLowerCase();
                    if (!lowerPerm.startsWith(beginning) || (split = lowerPerm.substring(beginning.length()).split("\\.")).length <= 1 || !split[0].replace("_", "").equals(type.name().toLowerCase().replace("_", ""))) continue;
                    for (int i = 1; i < split.length; ++i) {
                        returns.put(split[i], permission.getValue());
                    }
                }
                return returns;
            }
        }
        return new HashMap<String, Boolean>();
    }

    protected Method[] getDisguiseWatcherMethods(Class<? extends FlagWatcher> watcherClass) {
        Method[] methods = watcherClass.getMethods();
        methods = Arrays.copyOf(methods, methods.length + 4);
        int i = 4;
        for (String methodName : new String[]{"setViewSelfDisguise", "setHideHeldItemFromSelf", "setHideArmorFromSelf", "setHearSelfDisguise"}) {
            try {
                methods[methods.length - i--] = Disguise.class.getMethod(methodName, Boolean.TYPE);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return methods;
    }

    protected HashMap<DisguiseType, HashMap<ArrayList<String>, Boolean>> getPermissions(CommandSender sender, String permissionNode) {
        Class<? extends Entity> entityClass;
        DisguiseType dType;
        String disguiseType;
        HashMap<DisguiseType, HashMap> singleDisguises = new HashMap<DisguiseType, HashMap>();
        HashMap<DisguiseType, HashMap> rangeDisguises = new HashMap<DisguiseType, HashMap>();
        HashMap<String, Boolean> perms = new HashMap<String, Boolean>();
        for (PermissionAttachmentInfo permission : sender.getEffectivePermissions()) {
            String perm = permission.getPermission().toLowerCase();
            if (!perm.startsWith(permissionNode) || perms.containsKey(perm) && permission.getValue()) continue;
            perms.put(perm, permission.getValue());
        }
        if (!perms.containsKey(permissionNode + "*") && sender.hasPermission(permissionNode + "*")) {
            perms.put(permissionNode + "*", true);
        }
        if (!perms.containsKey(permissionNode + "*.*") && sender.hasPermission(permissionNode + "*.*")) {
            perms.put(permissionNode + "*.*", true);
        }
        for (String perm : perms.keySet()) {
            if (!((Boolean)perms.get(perm)).booleanValue()) continue;
            perm = perm.substring(permissionNode.length());
            disguiseType = perm.split("\\.")[0];
            dType = null;
            for (DisguiseType t : DisguiseType.values()) {
                if (!t.name().replace("_", "").equalsIgnoreCase(disguiseType.replace("_", ""))) continue;
                dType = t;
                break;
            }
            if (dType != null) {
                HashMap list;
                if (singleDisguises.containsKey((Object)dType)) {
                    list = (HashMap)singleDisguises.get((Object)dType);
                } else {
                    list = new HashMap();
                    singleDisguises.put(dType, list);
                }
                HashMap<ArrayList<String>, Boolean> map1 = this.getOptions(perm);
                list.put(map1.keySet().iterator().next(), map1.values().iterator().next());
                continue;
            }
            for (DisguiseType type : DisguiseType.values()) {
                HashMap list;
                HashMap<ArrayList<String>, Boolean> options = null;
                entityClass = type.getEntityClass();
                if (disguiseType.equals("mob")) {
                    if (type.isMob()) {
                        options = this.getOptions(perm);
                    }
                } else if (disguiseType.equals("animal") || disguiseType.equals("animals")) {
                    if (Animals.class.isAssignableFrom(entityClass)) {
                        options = this.getOptions(perm);
                    }
                } else if (disguiseType.equals("monster") || disguiseType.equals("monsters")) {
                    if (Monster.class.isAssignableFrom(entityClass)) {
                        options = this.getOptions(perm);
                    }
                } else if (disguiseType.equals("misc")) {
                    if (type.isMisc()) {
                        options = this.getOptions(perm);
                    }
                } else if (disguiseType.equals("ageable")) {
                    if (Ageable.class.isAssignableFrom(entityClass)) {
                        options = this.getOptions(perm);
                    }
                } else if (disguiseType.equals("*")) {
                    options = this.getOptions(perm);
                }
                if (options == null) continue;
                if (rangeDisguises.containsKey((Object)type)) {
                    list = (HashMap)rangeDisguises.get((Object)type);
                } else {
                    list = new HashMap();
                    rangeDisguises.put(type, list);
                }
                HashMap<ArrayList<String>, Boolean> map1 = this.getOptions(perm);
                list.put(map1.keySet().iterator().next(), map1.values().iterator().next());
            }
        }
        for (String perm : perms.keySet()) {
            if (((Boolean)perms.get(perm)).booleanValue()) continue;
            perm = perm.substring(permissionNode.length());
            disguiseType = perm.split("\\.")[0];
            dType = null;
            for (DisguiseType t : DisguiseType.values()) {
                if (!t.name().replace("_", "").equalsIgnoreCase(disguiseType.replace("_", ""))) continue;
                dType = t;
                break;
            }
            if (dType != null) {
                singleDisguises.remove((Object)dType);
                rangeDisguises.remove((Object)dType);
                continue;
            }
            for (DisguiseType type : DisguiseType.values()) {
                boolean foundHim = false;
                entityClass = type.getEntityClass();
                switch (disguiseType) {
                    case "mob": {
                        if (!type.isMob()) break;
                        foundHim = true;
                        break;
                    }
                    case "animal": 
                    case "animals": {
                        if (!Animals.class.isAssignableFrom(entityClass)) break;
                        foundHim = true;
                        break;
                    }
                    case "monster": 
                    case "monsters": {
                        if (!Monster.class.isAssignableFrom(entityClass)) break;
                        foundHim = true;
                        break;
                    }
                    case "misc": {
                        if (!type.isMisc()) break;
                        foundHim = true;
                        break;
                    }
                    case "ageable": {
                        if (!Ageable.class.isAssignableFrom(entityClass)) break;
                        foundHim = true;
                        break;
                    }
                    case "*": {
                        foundHim = true;
                    }
                }
                if (!foundHim) continue;
                rangeDisguises.remove((Object)type);
            }
        }
        HashMap<DisguiseType, HashMap<ArrayList<String>, Boolean>> map = new HashMap<DisguiseType, HashMap<ArrayList<String>, Boolean>>();
        for (DisguiseType type : DisguiseType.values()) {
            HashMap temp = new HashMap();
            if (singleDisguises.containsKey((Object)type)) {
                temp.putAll((Map)singleDisguises.get((Object)type));
            }
            if (rangeDisguises.containsKey((Object)type)) {
                temp.putAll((Map)rangeDisguises.get((Object)type));
            }
            if (temp.isEmpty()) continue;
            map.put(type, temp);
        }
        return map;
    }

    private HashMap<ArrayList<String>, Boolean> getOptions(String perm) {
        ArrayList<String> list = new ArrayList<String>();
        boolean isRemove = true;
        String[] split = perm.split("\\.");
        for (int i = 1; i < split.length; ++i) {
            String option = split[i];
            boolean value = option.startsWith("-");
            if (value) {
                option = option.substring(1);
                isRemove = false;
            }
            if (option.equals("baby")) {
                option = "setbaby";
            }
            list.add(option);
        }
        HashMap<ArrayList<String>, Boolean> options = new HashMap<ArrayList<String>, Boolean>();
        options.put(list, isRemove);
        return options;
    }

    protected boolean isDouble(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean isNumeric(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Disguise parseDisguise(CommandSender sender, String[] args, HashMap<DisguiseType, HashMap<ArrayList<String>, Boolean>> map) throws DisguiseParseException, IllegalAccessException, InvocationTargetException {
        HashMap<ArrayList<String>, Boolean> optionPermissions;
        if (map.isEmpty()) {
            throw new DisguiseParseException(ChatColor.RED + "You are forbidden to use this command.");
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, map);
            throw new DisguiseParseException();
        }
        int toSkip = 1;
        ArrayList<String> usedOptions = new ArrayList<String>();
        Disguise disguise = null;
        if (args[0].startsWith("@")) {
            if (!sender.hasPermission("libsdisguises.disguise.disguiseclone")) throw new DisguiseParseException(ChatColor.RED + "You do not have perimssion to use disguise references!");
            disguise = DisguiseUtilities.getClonedDisguise(args[0].toLowerCase());
            if (disguise == null) {
                throw new DisguiseParseException(ChatColor.RED + "Cannot find a disguise under the reference " + args[0]);
            }
            optionPermissions = map.containsKey((Object)disguise.getType()) ? map.get((Object)disguise.getType()) : new HashMap();
        } else {
            DisguiseType disguiseType = null;
            if (args[0].equalsIgnoreCase("p")) {
                disguiseType = DisguiseType.PLAYER;
            } else {
                for (DisguiseType type : DisguiseType.values()) {
                    if (!args[0].equalsIgnoreCase(type.name()) && !args[0].equalsIgnoreCase(type.name().replace("_", ""))) continue;
                    disguiseType = type;
                    break;
                }
            }
            if (disguiseType == null) {
                throw new DisguiseParseException(ChatColor.RED + "Error! The disguise " + ChatColor.GREEN + args[0] + ChatColor.RED + " doesn't exist!");
            }
            if (disguiseType.isUnknown()) {
                throw new DisguiseParseException(ChatColor.RED + "Error! You cannot disguise as " + ChatColor.GREEN + "Unknown!");
            }
            if (disguiseType.getEntityType() == null) {
                throw new DisguiseParseException(ChatColor.RED + "Error! This version of minecraft does not have that disguise!");
            }
            if (!map.containsKey((Object)disguiseType)) {
                throw new DisguiseParseException(ChatColor.RED + "You are forbidden to use this disguise.");
            }
            optionPermissions = map.get((Object)disguiseType);
            HashMap<String, Boolean> disguiseOptions = this.getDisguiseOptions(sender, disguiseType);
            if (disguiseType.isPlayer()) {
                if (args.length == 1) {
                    throw new DisguiseParseException(ChatColor.RED + "Error! You need to give a player name!");
                }
                if (!(disguiseOptions.isEmpty() || disguiseOptions.containsKey(args[1].toLowerCase()) && disguiseOptions.get(args[1].toLowerCase()).booleanValue())) {
                    throw new DisguiseParseException(ChatColor.RED + "Error! You don't have permission to use that name!");
                }
                args[1] = args[1].replace("\\_", " ");
                disguise = new PlayerDisguise(ChatColor.translateAlternateColorCodes((char)'&', (String)args[1]));
                ++toSkip;
            } else if (disguiseType.isMob()) {
                boolean adult = true;
                if (args.length > 1 && (args[1].equalsIgnoreCase("baby") || args[1].equalsIgnoreCase("adult"))) {
                    usedOptions.add("setbaby");
                    this.doCheck(optionPermissions, usedOptions);
                    adult = args[1].equalsIgnoreCase("adult");
                    ++toSkip;
                }
                disguise = new MobDisguise(disguiseType, adult);
            } else if (disguiseType.isMisc()) {
                int miscId = -1;
                int miscData = -1;
                String secondArg = null;
                if (args.length > 1) {
                    if (args[1].contains(":")) {
                        String[] split = args[1].split(":");
                        if (this.isNumeric(split[1])) {
                            secondArg = split[1];
                        }
                        args[1] = split[0];
                    }
                    if (this.isNumeric(args[1])) {
                        miscId = Integer.parseInt(args[1]);
                    } else if (disguiseType == DisguiseType.FALLING_BLOCK || disguiseType == DisguiseType.DROPPED_ITEM) {
                        for (Material mat : Material.values()) {
                            if (!mat.name().replace("_", "").equalsIgnoreCase(args[1].replace("_", ""))) continue;
                            miscId = mat.getId();
                            break;
                        }
                    }
                    if (miscId != -1) {
                        switch (disguiseType) {
                            case FALLING_BLOCK: 
                            case PAINTING: 
                            case SPLASH_POTION: 
                            case FISHING_HOOK: 
                            case DROPPED_ITEM: 
                            case ARROW: 
                            case TIPPED_ARROW: 
                            case SPECTRAL_ARROW: 
                            case SMALL_FIREBALL: 
                            case FIREBALL: 
                            case WITHER_SKULL: {
                                break;
                            }
                            default: {
                                throw new DisguiseParseException(ChatColor.RED + "Error! " + disguiseType.toReadable() + " doesn't know what to do with " + args[1] + "!");
                            }
                        }
                        ++toSkip;
                        if (args.length > 2 && secondArg == null && this.isNumeric(args[2])) {
                            secondArg = args[2];
                            ++toSkip;
                        }
                        if (secondArg != null) {
                            if (disguiseType != DisguiseType.FALLING_BLOCK && disguiseType != DisguiseType.DROPPED_ITEM) {
                                throw new DisguiseParseException(ChatColor.RED + "Error! Only the disguises " + DisguiseType.FALLING_BLOCK.toReadable() + " and " + DisguiseType.DROPPED_ITEM.toReadable() + " uses a second number!");
                            }
                            miscData = Integer.parseInt(secondArg);
                        }
                    }
                }
                if (!disguiseOptions.isEmpty() && miscId != -1) {
                    String toCheck = "" + miscId;
                    if (miscData == 0 || miscData == -1) {
                        if (!disguiseOptions.containsKey(toCheck) || !disguiseOptions.get(toCheck).booleanValue()) {
                            toCheck = toCheck + ":0";
                        }
                    } else {
                        toCheck = toCheck + ":" + miscData;
                    }
                    if (!disguiseOptions.containsKey(toCheck) || !disguiseOptions.get(toCheck).booleanValue()) {
                        throw new DisguiseParseException(ChatColor.RED + "Error! You do not have permission to use the parameter " + toCheck + " on the " + disguiseType.toReadable() + " disguise!");
                    }
                }
                if (miscId != -1) {
                    if (disguiseType == DisguiseType.FALLING_BLOCK) {
                        usedOptions.add("setblock");
                        this.doCheck(optionPermissions, usedOptions);
                    } else if (disguiseType == DisguiseType.PAINTING) {
                        usedOptions.add("setpainting");
                        this.doCheck(optionPermissions, usedOptions);
                    } else if (disguiseType == DisguiseType.SPLASH_POTION) {
                        usedOptions.add("setpotionid");
                        this.doCheck(optionPermissions, usedOptions);
                    }
                }
                disguise = new MiscDisguise(disguiseType, miscId, miscData);
            }
        }
        String[] newArgs = new String[args.length - toSkip];
        System.arraycopy(args, toSkip, newArgs, 0, args.length - toSkip);
        args = newArgs;
        Method[] methods = this.getDisguiseWatcherMethods(disguise.getWatcher().getClass());
        for (int i = 0; i < args.length; i += 2) {
            void var14_17;
            String methodName = args[i];
            String valueString = args.length - 1 == i ? null : args[i + 1];
            Method methodToUse = null;
            Object var14_16 = null;
            DisguiseParseException storedEx = null;
            int c = 0;
            while (c < methods.length) {
                try {
                    Map.Entry<Method, Integer> entry = this.getMethod(methods, methodName, c);
                    if (entry == null) break;
                    methodToUse = entry.getKey();
                    c = entry.getValue();
                    methodName = methodToUse.getName();
                    Class<?>[] types = methodToUse.getParameterTypes();
                    Class<?> param = types[0];
                    if (valueString != null) {
                        if (Integer.TYPE == param) {
                            if (!this.isNumeric(valueString)) throw this.parseToException("number", valueString, methodName);
                            Integer n = Integer.parseInt(valueString);
                        } else {
                            if (WrappedGameProfile.class == param && valueString.length() > 20) {
                                try {
                                    Map response = (Map)new Gson().fromJson(valueString, Map.class);
                                    String id = (String)response.get("id");
                                    if (!id.contains("-")) {
                                        id = Pattern.compile("([0-9a-fA-F]{8})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]+)").matcher(id).replaceFirst("$1-$2-$3-$4-$5");
                                    }
                                    WrappedGameProfile gameProfile = new WrappedGameProfile(UUID.fromString(id), (String)response.get("name"));
                                    if (response.containsKey("properties")) {
                                        ArrayList properties = (ArrayList)response.get("properties");
                                        for (Map s : properties) {
                                            String gName = null;
                                            String gValue = null;
                                            String gSigned = null;
                                            if (s.containsKey("name")) {
                                                gName = (String)s.get("name");
                                            }
                                            if (s.containsKey("value")) {
                                                gValue = (String)s.get("value");
                                            }
                                            if (s.containsKey("signature")) {
                                                gSigned = (String)s.get("signature");
                                            }
                                            gameProfile.getProperties().put((Object)gName, (Object)new WrappedSignedProperty(gName, gValue, gSigned));
                                        }
                                    }
                                    WrappedGameProfile wrappedGameProfile = gameProfile;
                                }
                                catch (Exception ex) {
                                    throw this.parseToException("gameprofile", valueString, methodName);
                                }
                            }
                            if (Float.TYPE == param || Double.TYPE == param) {
                                if (!this.isDouble(valueString)) throw this.parseToException("number.0", valueString, methodName);
                                float obj = Float.parseFloat(valueString);
                                if (param == Float.TYPE) {
                                    Float f = Float.valueOf(obj);
                                } else if (param == Double.TYPE) {
                                    Double d = obj;
                                }
                            } else if (param == String.class) {
                                if (methodName.equalsIgnoreCase("setskin") && valueString.length() > 20) continue;
                                String string = ChatColor.translateAlternateColorCodes((char)'&', (String)valueString);
                            } else {
                                if (param == AnimalColor.class) {
                                    try {
                                        AnimalColor animalColor = AnimalColor.valueOf(valueString.toUpperCase());
                                    }
                                    catch (Exception ex) {
                                        throw this.parseToException("animal color", valueString, methodName);
                                    }
                                }
                                if (param == ItemStack.class) {
                                    try {
                                        ItemStack itemStack = this.parseToItemstack(valueString);
                                    }
                                    catch (Exception ex) {
                                        throw new DisguiseParseException(String.format(ex.getMessage(), methodName));
                                    }
                                }
                                if (param == ItemStack[].class) {
                                    ItemStack[] items = new ItemStack[4];
                                    String[] split = valueString.split(",");
                                    if (split.length != 4) throw this.parseToException("item ID,ID,ID,ID" + ChatColor.RED + " or " + ChatColor.GREEN + "ID:Data,ID:Data,ID:Data,ID:Data combo", valueString, methodName);
                                    for (int a = 0; a < 4; ++a) {
                                        try {
                                            items[a] = this.parseToItemstack(split[a]);
                                            continue;
                                        }
                                        catch (Exception ex) {
                                            throw this.parseToException("item ID,ID,ID,ID" + ChatColor.RED + " or " + ChatColor.GREEN + "ID:Data,ID:Data,ID:Data,ID:Data combo", valueString, methodName);
                                        }
                                    }
                                    ItemStack[] itemStackArray = items;
                                } else if (param.getSimpleName().equals("Color")) {
                                    Object object = this.callValueOf(param, valueString, methodName, "a horse color");
                                } else if (param.getSimpleName().equals("Style")) {
                                    Object object = this.callValueOf(param, valueString, methodName, "a horse style");
                                } else if (param.getSimpleName().equals("Profession")) {
                                    Object object = this.callValueOf(param, valueString, methodName, "a villager profession");
                                } else if (param.getSimpleName().equals("Art")) {
                                    Object object = this.callValueOf(param, valueString, methodName, "a painting art");
                                } else if (param.getSimpleName().equals("Type")) {
                                    Object object = this.callValueOf(param, valueString, methodName, "a ocelot type");
                                } else {
                                    if (param == PotionEffectType.class) {
                                        try {
                                            PotionEffectType potionType = PotionEffectType.getByName((String)valueString.toUpperCase());
                                            if (potionType == null && this.isNumeric(valueString)) {
                                                potionType = PotionEffectType.getById((int)Integer.parseInt(valueString));
                                            }
                                            if (potionType == null) {
                                                throw new DisguiseParseException();
                                            }
                                            PotionEffectType potionEffectType = potionType;
                                        }
                                        catch (Exception ex) {
                                            throw this.parseToException("a potioneffect type", valueString, methodName);
                                        }
                                    }
                                    if (param == int[].class) {
                                        String[] split = valueString.split(",");
                                        int[] values = new int[split.length];
                                        for (int b = 0; b < values.length; ++b) {
                                            try {
                                                values[b] = Integer.parseInt(split[b]);
                                                continue;
                                            }
                                            catch (NumberFormatException ex) {
                                                throw this.parseToException("Number,Number,Number...", valueString, methodName);
                                            }
                                        }
                                        int[] nArray = values;
                                    } else {
                                        if (param == BlockFace.class) {
                                            try {
                                                BlockFace face = BlockFace.valueOf((String)valueString.toUpperCase());
                                                if (face.ordinal() > 4) {
                                                    throw new DisguiseParseException();
                                                }
                                                BlockFace blockFace = face;
                                            }
                                            catch (Exception ex) {
                                                throw this.parseToException("a direction (north, east, south, west, up)", valueString, methodName);
                                            }
                                        }
                                        if (param == RabbitType.class) {
                                            try {
                                                for (RabbitType type : RabbitType.values()) {
                                                    if (!type.name().replace("_", "").equalsIgnoreCase(valueString.replace("_", "").replace(" ", ""))) continue;
                                                    RabbitType rabbitType = type;
                                                    break;
                                                }
                                                if (var14_17 == null) {
                                                    throw new Exception();
                                                }
                                            }
                                            catch (Exception ex) {
                                                throw this.parseToException("rabbit type (white, brown, patches...)", valueString, methodName);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (var14_17 == null && Boolean.TYPE == param) {
                        if (valueString == null) {
                            Boolean bl = true;
                            --i;
                        } else if (valueString.equalsIgnoreCase("true")) {
                            Boolean bl = true;
                        } else if (valueString.equalsIgnoreCase("false")) {
                            Boolean bl = false;
                        } else {
                            if (this.getMethod(methods, valueString, 0) == null) {
                                throw this.parseToException("true/false", valueString, methodName);
                            }
                            Boolean bl = true;
                            --i;
                        }
                    }
                    if (var14_17 == null) continue;
                    break;
                }
                catch (DisguiseParseException ex) {
                    storedEx = ex;
                    methodToUse = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    methodToUse = null;
                }
            }
            if (methodToUse == null) {
                if (storedEx == null) throw new DisguiseParseException(ChatColor.RED + "Cannot find the option " + methodName);
                throw storedEx;
            }
            if (var14_17 == null) {
                throw new DisguiseParseException(ChatColor.RED + "No value was given for the option " + methodName);
            }
            if (!usedOptions.contains(methodName.toLowerCase())) {
                usedOptions.add(methodName.toLowerCase());
            }
            this.doCheck(optionPermissions, usedOptions);
            if (FlagWatcher.class.isAssignableFrom(methodToUse.getDeclaringClass())) {
                methodToUse.invoke((Object)disguise.getWatcher(), var14_17);
                continue;
            }
            methodToUse.invoke((Object)disguise, var14_17);
        }
        return disguise;
    }

    private Map.Entry<Method, Integer> getMethod(Method[] methods, String methodName, int toStart) {
        for (int i = toStart; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getName().startsWith("get") || !method.getName().equalsIgnoreCase(methodName) || method.getAnnotation(Deprecated.class) != null || method.getParameterTypes().length != 1) continue;
            return new AbstractMap.SimpleEntry<Method, Integer>(method, ++i);
        }
        return null;
    }

    private Object callValueOf(Class<?> param, String valueString, String methodName, String description) throws DisguiseParseException {
        Object value;
        try {
            value = param.getMethod("valueOf", String.class).invoke(null, valueString.toUpperCase());
        }
        catch (Exception ex) {
            throw this.parseToException(description, valueString, methodName);
        }
        return value;
    }

    private boolean passesCheck(HashMap<ArrayList<String>, Boolean> map1, ArrayList<String> usedOptions) {
        boolean hasPermission = false;
        for (ArrayList<String> list : map1.keySet()) {
            boolean myPerms = true;
            for (String option : usedOptions) {
                if (map1.get(list).booleanValue() && list.contains("*") || list.contains(option) == map1.get(list).booleanValue()) continue;
                myPerms = false;
                break;
            }
            if (!myPerms) continue;
            hasPermission = true;
        }
        return hasPermission;
    }

    private void doCheck(HashMap<ArrayList<String>, Boolean> optionPermissions, ArrayList<String> usedOptions) throws DisguiseParseException {
        if (!this.passesCheck(optionPermissions, usedOptions)) {
            throw new DisguiseParseException(ChatColor.RED + "You do not have the permission to use the option " + usedOptions.get(usedOptions.size() - 1));
        }
    }

    private DisguiseParseException parseToException(String expectedValue, String receivedInstead, String methodName) {
        return new DisguiseParseException(ChatColor.RED + "Expected " + ChatColor.GREEN + expectedValue + ChatColor.RED + ", received " + ChatColor.GREEN + receivedInstead + ChatColor.RED + " instead for " + ChatColor.GREEN + methodName);
    }

    private ItemStack parseToItemstack(String string) throws Exception {
        String[] split = string.split(":", -1);
        if (this.isNumeric(split[0])) {
            int itemId = Integer.parseInt(split[0]);
            short itemDura = 0;
            if (split.length > 1) {
                if (this.isNumeric(split[1])) {
                    itemDura = Short.parseShort(split[1]);
                } else {
                    throw this.parseToException("item ID:Durability combo", string, "%s");
                }
            }
            return new ItemStack(itemId, 1, itemDura);
        }
        if (split.length == 1) {
            throw this.parseToException("item ID", string, "%s");
        }
        throw this.parseToException("item ID:Durability combo", string, "%s");
    }

    protected abstract void sendCommandUsage(CommandSender var1, HashMap<DisguiseType, HashMap<ArrayList<String>, Boolean>> var2);

    public class DisguiseParseException
    extends Exception {
        private static final long serialVersionUID = 1276971370793124510L;

        public DisguiseParseException() {
        }

        public DisguiseParseException(String string) {
            super(string);
        }
    }
}

