/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.io.IOException;
import java.lang.reflect.Field;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.DisguiseListener;
import me.libraryaddict.disguise.commands.CloneDisguiseCommand;
import me.libraryaddict.disguise.commands.DisguiseCommand;
import me.libraryaddict.disguise.commands.DisguiseViewSelf;
import me.libraryaddict.disguise.commands.EntityDisguiseCommand;
import me.libraryaddict.disguise.commands.HelpDisguiseCommand;
import me.libraryaddict.disguise.commands.LibsDisguisesCommand;
import me.libraryaddict.disguise.commands.PlayerDisguiseCommand;
import me.libraryaddict.disguise.commands.RadiusDisguiseCommand;
import me.libraryaddict.disguise.commands.UndisguiseCommand;
import me.libraryaddict.disguise.commands.UndisguiseEntityCommand;
import me.libraryaddict.disguise.commands.UndisguisePlayerCommand;
import me.libraryaddict.disguise.commands.UndisguiseRadiusCommand;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GuardianWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.HorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SkeletonWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SpiderWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TNTWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseSound;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.Metrics;
import me.libraryaddict.disguise.utilities.PacketsManager;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Zombie;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LibsDisguises
extends JavaPlugin {
    private static LibsDisguises instance;
    private DisguiseListener listener;

    public void onEnable() {
        this.getLogger().info("Discovered MC version: " + ReflectionManager.getBukkitVersion());
        this.saveDefaultConfig();
        PacketsManager.init(this);
        DisguiseUtilities.init(this);
        DisguiseConfig.initConfig((ConfigurationSection)this.getConfig());
        PacketsManager.addPacketListeners();
        this.listener = new DisguiseListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)this);
        this.getCommand("disguise").setExecutor((CommandExecutor)new DisguiseCommand());
        this.getCommand("undisguise").setExecutor((CommandExecutor)new UndisguiseCommand());
        this.getCommand("disguiseplayer").setExecutor((CommandExecutor)new PlayerDisguiseCommand());
        this.getCommand("undisguiseplayer").setExecutor((CommandExecutor)new UndisguisePlayerCommand());
        this.getCommand("undisguiseentity").setExecutor((CommandExecutor)new UndisguiseEntityCommand());
        this.getCommand("disguiseentity").setExecutor((CommandExecutor)new EntityDisguiseCommand());
        this.getCommand("disguiseradius").setExecutor((CommandExecutor)new RadiusDisguiseCommand(this.getConfig().getInt("DisguiseRadiusMax")));
        this.getCommand("undisguiseradius").setExecutor((CommandExecutor)new UndisguiseRadiusCommand(this.getConfig().getInt("UndisguiseRadiusMax")));
        this.getCommand("disguisehelp").setExecutor((CommandExecutor)new HelpDisguiseCommand());
        this.getCommand("disguiseclone").setExecutor((CommandExecutor)new CloneDisguiseCommand());
        this.getCommand("libsdisguises").setExecutor((CommandExecutor)new LibsDisguisesCommand());
        this.getCommand("disguiseviewself").setExecutor((CommandExecutor)new DisguiseViewSelf());
        this.registerValues();
        instance = this;
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reload() {
        HandlerList.unregisterAll((Listener)this.listener);
        this.reloadConfig();
        DisguiseConfig.initConfig((ConfigurationSection)this.getConfig());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerValues() {
        DisguiseType[] arr$ = DisguiseType.values();
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block43: {
                Class watcherClass;
                DisguiseType disguiseType;
                block44: {
                    if (i$ >= len$) {
                        return;
                    }
                    disguiseType = arr$[i$];
                    if (disguiseType.getEntityType() == null) break block43;
                    watcherClass = null;
                    try {
                        switch (disguiseType) {
                            case SPECTRAL_ARROW: {
                                watcherClass = ArrowWatcher.class;
                                break;
                            }
                            case PRIMED_TNT: {
                                watcherClass = TNTWatcher.class;
                                break;
                            }
                            case MINECART_CHEST: 
                            case MINECART_COMMAND: 
                            case MINECART_FURNACE: 
                            case MINECART_HOPPER: 
                            case MINECART_MOB_SPAWNER: 
                            case MINECART_TNT: {
                                watcherClass = MinecartWatcher.class;
                                break;
                            }
                            case SPIDER: 
                            case CAVE_SPIDER: {
                                watcherClass = SpiderWatcher.class;
                                break;
                            }
                            case DONKEY: 
                            case MULE: 
                            case UNDEAD_HORSE: 
                            case SKELETON_HORSE: {
                                watcherClass = HorseWatcher.class;
                                break;
                            }
                            case ZOMBIE_VILLAGER: 
                            case PIG_ZOMBIE: 
                            case HUSK: {
                                watcherClass = ZombieWatcher.class;
                                break;
                            }
                            case MAGMA_CUBE: {
                                watcherClass = SlimeWatcher.class;
                                break;
                            }
                            case ELDER_GUARDIAN: {
                                watcherClass = GuardianWatcher.class;
                                break;
                            }
                            case WITHER_SKELETON: 
                            case STRAY: {
                                watcherClass = SkeletonWatcher.class;
                                break;
                            }
                            default: {
                                watcherClass = Class.forName("me.libraryaddict.disguise.disguisetypes.watchers." + this.toReadable(disguiseType.name()) + "Watcher");
                                break;
                            }
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        Class entityClass = disguiseType.getEntityType().getEntityClass();
                        if (entityClass != null) {
                            watcherClass = Tameable.class.isAssignableFrom(entityClass) ? TameableWatcher.class : (Ageable.class.isAssignableFrom(entityClass) ? AgeableWatcher.class : (Creature.class.isAssignableFrom(entityClass) ? InsentientWatcher.class : (LivingEntity.class.isAssignableFrom(entityClass) ? LivingWatcher.class : FlagWatcher.class)));
                        }
                        watcherClass = FlagWatcher.class;
                    }
                    if (watcherClass != null) break block44;
                    System.err.println("Error loading " + disguiseType.name() + ", FlagWatcher not assigned");
                    break block43;
                }
                disguiseType.setWatcherClass(watcherClass);
                if (DisguiseValues.getDisguiseValues(disguiseType) == null) {
                    String nmsEntityName = this.toReadable(disguiseType.name());
                    switch (disguiseType) {
                        case DONKEY: 
                        case MULE: 
                        case UNDEAD_HORSE: 
                        case SKELETON_HORSE: 
                        case ZOMBIE_VILLAGER: 
                        case HUSK: 
                        case WITHER_SKELETON: 
                        case STRAY: {
                            break block43;
                        }
                        case PRIMED_TNT: {
                            nmsEntityName = "TNTPrimed";
                            break;
                        }
                        case MINECART_TNT: {
                            nmsEntityName = "MinecartTNT";
                            break;
                        }
                        case MINECART: {
                            nmsEntityName = "MinecartRideable";
                            break;
                        }
                        case FIREWORK: {
                            nmsEntityName = "Fireworks";
                            break;
                        }
                        case SPLASH_POTION: {
                            nmsEntityName = "Potion";
                            break;
                        }
                        case GIANT: {
                            nmsEntityName = "GiantZombie";
                            break;
                        }
                        case DROPPED_ITEM: {
                            nmsEntityName = "Item";
                            break;
                        }
                        case FIREBALL: {
                            nmsEntityName = "LargeFireball";
                            break;
                        }
                        case LEASH_HITCH: {
                            nmsEntityName = "Leash";
                            break;
                        }
                        case ELDER_GUARDIAN: {
                            nmsEntityName = "Guardian";
                            break;
                        }
                        case SPECTRAL_ARROW: 
                        case ARROW: {
                            nmsEntityName = "TippedArrow";
                        }
                    }
                    try {
                        if (nmsEntityName.equalsIgnoreCase("Unknown")) {
                            DisguiseValues disguiseValues = new DisguiseValues(disguiseType, null, 0, 0.0);
                            disguiseValues.setAdultBox(new FakeBoundingBox(0.0, 0.0, 0.0));
                            DisguiseSound sound = DisguiseSound.getType(disguiseType.name());
                            if (sound != null) {
                                sound.setDamageAndIdleSoundVolume(1.0f);
                            }
                            break block43;
                        }
                        Object nmsEntity = ReflectionManager.createEntityInstance(nmsEntityName);
                        if (nmsEntity == null) {
                            this.getLogger().warning("Entity not found! (" + nmsEntityName + ")");
                        } else {
                            Float soundStrength;
                            Entity bukkitEntity = ReflectionManager.getBukkitEntity(nmsEntity);
                            int entitySize = 0;
                            for (Field field : ReflectionManager.getNmsClass("Entity").getFields()) {
                                if (!field.getType().getName().equals("EnumEntitySize")) continue;
                                Enum enumEntitySize = (Enum)field.get(nmsEntity);
                                entitySize = enumEntitySize.ordinal();
                                break;
                            }
                            DisguiseValues disguiseValues = new DisguiseValues(disguiseType, nmsEntity.getClass(), entitySize, bukkitEntity instanceof Damageable ? ((Damageable)bukkitEntity).getMaxHealth() : 0.0);
                            WrappedDataWatcher watcher = WrappedDataWatcher.getEntityWatcher((Entity)bukkitEntity);
                            for (WrappedWatchableObject watch : watcher.getWatchableObjects()) {
                                FlagType flagType = FlagType.getFlag(watcherClass, watch.getIndex());
                                if (flagType != null) continue;
                                System.err.println("Error finding the FlagType for " + disguiseType.name() + "! Index " + watch.getIndex() + " can't be found!");
                                System.err.println("Value is " + watch.getRawValue() + " (" + watch.getRawValue().getClass() + ") (" + nmsEntity.getClass() + ") & " + watcherClass.getSimpleName());
                                System.err.println("Lib's Disguises will continue to load, but this will not work properly!");
                            }
                            DisguiseSound sound = DisguiseSound.getType(disguiseType.name());
                            if (sound != null && (soundStrength = ReflectionManager.getSoundModifier(nmsEntity)) != null) {
                                sound.setDamageAndIdleSoundVolume(soundStrength.floatValue());
                            }
                            disguiseValues.setAdultBox(ReflectionManager.getBoundingBox(bukkitEntity));
                            if (bukkitEntity instanceof Ageable) {
                                ((Ageable)bukkitEntity).setBaby();
                                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
                            } else if (bukkitEntity instanceof Zombie) {
                                ((Zombie)bukkitEntity).setBaby(true);
                                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
                            }
                            disguiseValues.setEntitySize(ReflectionManager.getSize(bukkitEntity));
                        }
                    }
                    catch (FieldAccessException | IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                        System.out.print("[LibsDisguises] Uh oh! Trouble while making values for the disguise " + disguiseType.name() + "!");
                        System.out.print("[LibsDisguises] Before reporting this error, please make sure you are using the latest version of LibsDisguises and ProtocolLib.");
                        System.out.print("[LibsDisguises] Development builds are available at (ProtocolLib) http://ci.dmulloy2.net/job/ProtocolLib/ and (LibsDisguises) http://server.o2gaming.com:8080/job/LibsDisguises%201.9+/");
                        ex.printStackTrace();
                    }
                }
            }
            ++i$;
        }
    }

    private String toReadable(String string) {
        StringBuilder builder = new StringBuilder();
        for (String s : string.split("_")) {
            builder.append(s.substring(0, 1)).append(s.substring(1).toLowerCase());
        }
        return builder.toString();
    }

    public DisguiseListener getListener() {
        return this.listener;
    }

    public static LibsDisguises getInstance() {
        return instance;
    }
}

