/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerClientInteract;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerInventory;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerMain;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerSounds;
import me.libraryaddict.disguise.utilities.packetlisteners.PacketListenerViewDisguises;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PacketsManager {
    private static PacketListener clientInteractEntityListener;
    private static PacketListener inventoryListener;
    private static boolean inventoryModifierEnabled;
    private static LibsDisguises libsDisguises;
    private static PacketListener mainListener;
    private static PacketListener soundsListener;
    private static boolean soundsListenerEnabled;
    private static PacketListener viewDisguisesListener;
    private static boolean viewDisguisesListenerEnabled;

    public static void addPacketListeners() {
        clientInteractEntityListener = new PacketListenerClientInteract(libsDisguises);
        ProtocolLibrary.getProtocolManager().addPacketListener(clientInteractEntityListener);
        PacketsManager.setupMainPacketsListener();
    }

    public static PacketContainer[][] constructSpawnPackets(Player observer, Disguise disguise, Entity disguisedEntity) {
        StructureModifier mods;
        if (disguise.getEntity() == null) {
            disguise.setEntity(disguisedEntity);
        }
        ArrayList<PacketContainer> packets = new ArrayList<PacketContainer>();
        if (DisguiseConfig.isEquipmentPacketsEnabled()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack itemstack = disguise.getWatcher().getItemStack(slot);
                if (itemstack == null || itemstack.getType() == Material.AIR) continue;
                ItemStack item = null;
                if (disguisedEntity instanceof LivingEntity) {
                    item = ReflectionManager.getEquipment(slot, disguisedEntity);
                }
                if (item != null && item.getType() != Material.AIR) continue;
                PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
                StructureModifier mods2 = packet.getModifier();
                mods2.write(0, (Object)disguisedEntity.getEntityId());
                mods2.write(1, (Object)ReflectionManager.createEnumItemSlot(slot));
                mods2.write(2, ReflectionManager.getNmsItem(itemstack));
                packets.add(packet);
            }
        }
        if (DisguiseConfig.isMiscDisguisesForLivingEnabled() && disguise.getWatcher() instanceof LivingWatcher) {
            ArrayList<WrappedAttribute> attributes = new ArrayList<WrappedAttribute>();
            WrappedAttribute.Builder builder = WrappedAttribute.newBuilder().attributeKey("generic.maxHealth");
            if (((LivingWatcher)disguise.getWatcher()).isMaxHealthSet()) {
                builder.baseValue(((LivingWatcher)disguise.getWatcher()).getMaxHealth());
            } else if (DisguiseConfig.isMaxHealthDeterminedByDisguisedEntity() && disguisedEntity instanceof Damageable) {
                builder.baseValue(((Damageable)disguisedEntity).getMaxHealth());
            } else {
                builder.baseValue(DisguiseValues.getDisguiseValues(disguise.getType()).getMaxHealth());
            }
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            builder.packet(packet);
            attributes.add(builder.build());
            packet.getIntegers().write(0, (Object)disguisedEntity.getEntityId());
            packet.getAttributeCollectionModifier().write(0, attributes);
            packets.add(packet);
        }
        PacketContainer[] spawnPackets = new PacketContainer[2 + packets.size()];
        PacketContainer[] delayedPackets = new PacketContainer[]{};
        for (int i = 0; i < packets.size(); ++i) {
            spawnPackets[i + 2] = (PacketContainer)packets.get(i);
        }
        Location loc = disguisedEntity.getLocation().clone().add(0.0, PacketsManager.getYModifier(disguisedEntity, disguise), 0.0);
        byte yaw = (byte)(loc.getYaw() * 256.0f / 360.0f);
        byte pitch = (byte)(loc.getPitch() * 256.0f / 360.0f);
        if (DisguiseConfig.isMovementPacketsEnabled()) {
            yaw = PacketsManager.getYaw(disguise.getType(), disguisedEntity.getType(), yaw);
            pitch = PacketsManager.getPitch(disguise.getType(), DisguiseType.getType(disguisedEntity.getType()), pitch);
        }
        if (disguise.getType() == DisguiseType.EXPERIENCE_ORB) {
            spawnPackets[0] = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB);
            mods = spawnPackets[0].getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)loc.getX());
            mods.write(2, (Object)(loc.getY() + 0.06));
            mods.write(3, (Object)loc.getZ());
            mods.write(4, (Object)1);
        } else if (disguise.getType() == DisguiseType.PAINTING) {
            spawnPackets[0] = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_PAINTING);
            mods = spawnPackets[0].getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)disguisedEntity.getUniqueId());
            mods.write(2, ReflectionManager.getBlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
            mods.write(3, (Object)ReflectionManager.getEnumDirection((int)loc.getYaw() % 4));
            int id = ((MiscDisguise)disguise).getData();
            mods.write(4, (Object)ReflectionManager.getEnumArt(Art.values()[id]));
            spawnPackets[1] = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
            mods = spawnPackets[1].getModifier();
            mods.write(0, (Object)disguisedEntity.getEntityId());
            mods.write(1, (Object)loc.getX());
            mods.write(2, (Object)loc.getY());
            mods.write(3, (Object)loc.getZ());
            mods.write(4, (Object)yaw);
            mods.write(5, (Object)pitch);
        } else if (disguise.getType().isPlayer()) {
            PacketContainer[] newPackets;
            PlayerDisguise playerDisguise = (PlayerDisguise)disguise;
            String name = playerDisguise.getName();
            int entityId = disguisedEntity.getEntityId();
            boolean removeName = false;
            if (!DisguiseUtilities.hasGameProfile(name)) {
                removeName = !DisguiseUtilities.getAddedByPlugins().contains(name);
            }
            WrappedGameProfile gameProfile = playerDisguise.getGameProfile();
            if (removeName) {
                DisguiseUtilities.getAddedByPlugins().remove(name);
            }
            spawnPackets[0] = new PacketContainer(PacketType.Play.Server.NAMED_ENTITY_SPAWN);
            spawnPackets[0].getIntegers().write(0, (Object)entityId);
            spawnPackets[0].getModifier().write(1, (Object)gameProfile.getUUID());
            spawnPackets[0].getDoubles().write(0, (Object)loc.getX());
            spawnPackets[0].getDoubles().write(1, (Object)loc.getY());
            spawnPackets[0].getDoubles().write(2, (Object)loc.getZ());
            spawnPackets[0].getBytes().write(0, (Object)((byte)(loc.getYaw() * 256.0f / 360.0f)));
            spawnPackets[0].getBytes().write(1, (Object)((byte)(loc.getPitch() * 256.0f / 360.0f)));
            spawnPackets[0].getDataWatcherModifier().write(0, (Object)PacketsManager.createDataWatcher(WrappedDataWatcher.getEntityWatcher((Entity)disguisedEntity), disguise.getWatcher()));
            if (DisguiseConfig.isBedPacketsEnabled() && ((PlayerWatcher)disguise.getWatcher()).isSleeping()) {
                newPackets = new PacketContainer[spawnPackets.length + 1];
                System.arraycopy(spawnPackets, 1, newPackets, 2, spawnPackets.length - 1);
                newPackets[0] = spawnPackets[0];
                spawnPackets = newPackets;
                PacketContainer[] bedPackets = DisguiseUtilities.getBedPackets(loc.clone().subtract(0.0, PacketsManager.getYModifier(disguisedEntity, disguise), 0.0), observer.getLocation(), (PlayerDisguise)disguise);
                System.arraycopy(bedPackets, 0, spawnPackets, 1, 2);
            }
            newPackets = new ArrayList();
            newPackets.add(null);
            for (PacketContainer spawnPacket : spawnPackets) {
                if (spawnPacket == null) continue;
                newPackets.add(spawnPacket);
            }
            spawnPackets = newPackets.toArray(new PacketContainer[newPackets.size()]);
            spawnPackets[0] = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            spawnPackets[0].getModifier().write(0, (Object)ReflectionManager.getEnumPlayerInfoAction(0));
            ArrayList<Object> playerList = new ArrayList<Object>();
            playerList.add(ReflectionManager.getPlayerInfoData(spawnPackets[0].getHandle(), playerDisguise.getGameProfile()));
            spawnPackets[0].getModifier().write(1, playerList);
            PacketContainer delayedPacket = spawnPackets[0].shallowClone();
            delayedPacket.getModifier().write(0, (Object)ReflectionManager.getEnumPlayerInfoAction(4));
            delayedPackets = new PacketContainer[]{delayedPacket};
        } else if (disguise.getType().isMob() || disguise.getType() == DisguiseType.ARMOR_STAND) {
            Vector vec = disguisedEntity.getVelocity();
            spawnPackets[0] = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
            StructureModifier mods3 = spawnPackets[0].getModifier();
            mods3.write(0, (Object)disguisedEntity.getEntityId());
            mods3.write(1, (Object)UUID.randomUUID());
            mods3.write(2, (Object)disguise.getType().getTypeId());
            double d1 = 3.9;
            double d2 = vec.getX();
            double d3 = vec.getY();
            double d4 = vec.getZ();
            if (d2 < -d1) {
                d2 = -d1;
            }
            if (d3 < -d1) {
                d3 = -d1;
            }
            if (d4 < -d1) {
                d4 = -d1;
            }
            if (d2 > d1) {
                d2 = d1;
            }
            if (d3 > d1) {
                d3 = d1;
            }
            if (d4 > d1) {
                d4 = d1;
            }
            mods3.write(3, (Object)loc.getX());
            mods3.write(4, (Object)loc.getY());
            mods3.write(5, (Object)loc.getZ());
            mods3.write(6, (Object)((int)(d2 * 8000.0)));
            mods3.write(7, (Object)((int)(d3 * 8000.0)));
            mods3.write(8, (Object)((int)(d4 * 8000.0)));
            mods3.write(9, (Object)yaw);
            mods3.write(10, (Object)pitch);
            spawnPackets[0].getDataWatcherModifier().write(0, (Object)PacketsManager.createDataWatcher(WrappedDataWatcher.getEntityWatcher((Entity)disguisedEntity), disguise.getWatcher()));
        } else if (disguise.getType().isMisc()) {
            int objectId = disguise.getType().getObjectId();
            int data = ((MiscDisguise)disguise).getData();
            if (disguise.getType() == DisguiseType.FALLING_BLOCK) {
                data = ReflectionManager.getCombinedId(((MiscDisguise)disguise).getId(), data);
            } else if (disguise.getType() == DisguiseType.FISHING_HOOK && data == 0) {
                data = disguisedEntity.getEntityId();
            } else if (disguise.getType() == DisguiseType.ITEM_FRAME) {
                data = ((int)loc.getYaw() % 360 + 720 + 45) / 90 % 4;
            }
            Object nmsEntity = ReflectionManager.getNmsEntity(disguisedEntity);
            spawnPackets[0] = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.SPAWN_ENTITY, new Object[]{nmsEntity, objectId, data}).createPacket(new Object[]{nmsEntity, objectId, data});
            spawnPackets[0].getModifier().write(8, (Object)pitch);
            spawnPackets[0].getModifier().write(9, (Object)yaw);
            if (disguise.getType() == DisguiseType.ITEM_FRAME) {
                if (data % 2 == 0) {
                    spawnPackets[0].getModifier().write(4, (Object)(loc.getZ() + (double)(data == 0 ? -1 : 1)));
                } else {
                    spawnPackets[0].getModifier().write(2, (Object)(loc.getX() + (double)(data == 3 ? -1 : 1)));
                }
            }
        }
        if (spawnPackets[1] == null || disguise.isPlayerDisguise()) {
            int entry;
            int n = entry = spawnPackets[1] == null ? 1 : 0;
            if (entry == 0) {
                entry = spawnPackets.length;
                spawnPackets = Arrays.copyOf(spawnPackets, spawnPackets.length + 1);
            }
            spawnPackets[entry] = new PacketContainer(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
            StructureModifier mods4 = spawnPackets[entry].getModifier();
            mods4.write(0, (Object)disguisedEntity.getEntityId());
            mods4.write(1, (Object)yaw);
        }
        return new PacketContainer[][]{spawnPackets, delayedPackets};
    }

    private static WrappedDataWatcher createDataWatcher(WrappedDataWatcher watcher, FlagWatcher flagWatcher) {
        WrappedDataWatcher newWatcher = new WrappedDataWatcher();
        try {
            List<WrappedWatchableObject> list = DisguiseConfig.isMetadataPacketsEnabled() ? flagWatcher.convert(watcher.getWatchableObjects()) : flagWatcher.getWatchableObjects();
            for (WrappedWatchableObject watchableObject : list) {
                if (watchableObject == null || watchableObject.getValue() == null || WrappedDataWatcher.Registry.get(watchableObject.getValue().getClass()) == null) continue;
                WrappedDataWatcher.WrappedDataWatcherObject obj = new WrappedDataWatcher.WrappedDataWatcherObject(watchableObject.getIndex(), WrappedDataWatcher.Registry.get(watchableObject.getValue().getClass()));
                newWatcher.setObject(obj, watchableObject.getValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newWatcher;
    }

    public static byte getPitch(DisguiseType disguiseType, DisguiseType entityType, byte value) {
        switch (disguiseType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                value = -value;
                break;
            }
        }
        switch (entityType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                value = -value;
                break;
            }
        }
        return value;
    }

    public static byte getYaw(DisguiseType disguiseType, EntityType entityType, byte value) {
        switch (disguiseType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                value = (byte)(value + 64);
                break;
            }
            case ENDER_DRAGON: {
                value = (byte)(value - 128);
                break;
            }
            case WITHER_SKULL: {
                value = (byte)(value - 128);
                break;
            }
            case ARROW: 
            case TIPPED_ARROW: 
            case SPECTRAL_ARROW: {
                value = -value;
                break;
            }
            case PAINTING: 
            case ITEM_FRAME: {
                value = (byte)(-(value + 128));
                break;
            }
            default: {
                if (!disguiseType.isMisc() || disguiseType == DisguiseType.ARMOR_STAND) break;
                value = (byte)(value - 64);
            }
        }
        switch (entityType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                value = (byte)(value - 64);
                break;
            }
            case ENDER_DRAGON: 
            case WITHER_SKULL: {
                value = (byte)(value + 128);
                break;
            }
            case ARROW: {
                value = -value;
                break;
            }
            case PAINTING: 
            case ITEM_FRAME: {
                value = (byte)(-(value - 128));
                break;
            }
            default: {
                if (entityType.isAlive()) break;
                value = (byte)(value + 64);
            }
        }
        return value;
    }

    public static double getYModifier(Entity entity, Disguise disguise) {
        double yMod = 0.0;
        if (!(disguise.getType() == DisguiseType.PLAYER && ((PlayerWatcher)disguise.getWatcher()).isSleeping() || entity.getType() != EntityType.DROPPED_ITEM)) {
            yMod -= 0.13;
        }
        switch (disguise.getType()) {
            case BAT: {
                if (entity instanceof LivingEntity) {
                    return yMod + ((LivingEntity)entity).getEyeHeight();
                }
            }
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                switch (entity.getType()) {
                    case MINECART: 
                    case MINECART_CHEST: 
                    case MINECART_FURNACE: 
                    case MINECART_HOPPER: 
                    case MINECART_MOB_SPAWNER: 
                    case MINECART_TNT: {
                        return yMod;
                    }
                }
                return yMod + 0.4;
            }
            case WITHER_SKULL: 
            case TIPPED_ARROW: 
            case SPECTRAL_ARROW: 
            case PAINTING: 
            case BOAT: 
            case EGG: 
            case ENDER_PEARL: 
            case ENDER_SIGNAL: 
            case FIREWORK: 
            case SMALL_FIREBALL: 
            case SNOWBALL: 
            case SPLASH_POTION: 
            case THROWN_EXP_BOTTLE: {
                return yMod + 0.7;
            }
            case PLAYER: {
                if (!DisguiseConfig.isBedPacketsEnabled() || !((PlayerWatcher)disguise.getWatcher()).isSleeping()) break;
                return yMod + 0.35;
            }
            case DROPPED_ITEM: {
                return yMod + 0.13;
            }
        }
        return yMod;
    }

    public static void init(LibsDisguises plugin) {
        libsDisguises = plugin;
        soundsListener = new PacketListenerSounds(libsDisguises);
        viewDisguisesListener = new PacketListenerViewDisguises(libsDisguises);
        inventoryListener = new PacketListenerInventory(libsDisguises);
    }

    public static boolean isHearDisguisesEnabled() {
        return soundsListenerEnabled;
    }

    public static boolean isInventoryListenerEnabled() {
        return inventoryModifierEnabled;
    }

    public static boolean isViewDisguisesListenerEnabled() {
        return viewDisguisesListenerEnabled;
    }

    public static void setHearDisguisesListener(boolean enabled) {
        if (soundsListenerEnabled != enabled) {
            soundsListenerEnabled = enabled;
            if (soundsListenerEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(soundsListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(soundsListener);
            }
        }
    }

    public static void setInventoryListenerEnabled(boolean enabled) {
        if (inventoryModifierEnabled != enabled) {
            inventoryModifierEnabled = enabled;
            if (inventoryModifierEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(inventoryListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(inventoryListener);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
                if (disguise == null || !viewDisguisesListenerEnabled || !disguise.isSelfDisguiseVisible() || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) continue;
                player.updateInventory();
            }
        }
    }

    public static void setupMainPacketsListener() {
        if (clientInteractEntityListener != null) {
            if (mainListener != null) {
                ProtocolLibrary.getProtocolManager().removePacketListener(mainListener);
            }
            ArrayList<PacketType> packetsToListen = new ArrayList<PacketType>();
            packetsToListen.add(PacketType.Play.Server.NAMED_ENTITY_SPAWN);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
            packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY_PAINTING);
            packetsToListen.add(PacketType.Play.Server.ENTITY_METADATA);
            if (DisguiseConfig.isCollectPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.COLLECT);
            }
            if (DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
                packetsToListen.add(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            }
            if (DisguiseConfig.isBedPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.BED);
            }
            if (DisguiseConfig.isMovementPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ENTITY_LOOK);
                packetsToListen.add(PacketType.Play.Server.REL_ENTITY_MOVE_LOOK);
                packetsToListen.add(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
                packetsToListen.add(PacketType.Play.Server.ENTITY_TELEPORT);
                packetsToListen.add(PacketType.Play.Server.REL_ENTITY_MOVE);
            }
            if (DisguiseConfig.isEquipmentPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ENTITY_EQUIPMENT);
            }
            if (DisguiseConfig.isAnimationPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ANIMATION);
            }
            if (DisguiseConfig.isEntityStatusPacketsEnabled()) {
                packetsToListen.add(PacketType.Play.Server.ENTITY_STATUS);
            }
            mainListener = new PacketListenerMain(libsDisguises, packetsToListen);
            ProtocolLibrary.getProtocolManager().addPacketListener(mainListener);
        }
    }

    public static void setViewDisguisesListener(boolean enabled) {
        if (viewDisguisesListenerEnabled != enabled) {
            viewDisguisesListenerEnabled = enabled;
            if (viewDisguisesListenerEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(viewDisguisesListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(viewDisguisesListener);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
                if (disguise == null || !disguise.isSelfDisguiseVisible()) continue;
                if (enabled) {
                    DisguiseUtilities.setupFakeDisguise(disguise);
                } else {
                    DisguiseUtilities.removeSelfDisguise(player);
                }
                if (!inventoryModifierEnabled || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) continue;
                player.updateInventory();
            }
        }
    }

    public static PacketContainer[][] transformPacket(PacketContainer sentPacket, Player observer, Entity entity) {
        PacketContainer[][] packetContainerArray;
        PacketContainer[] packets = null;
        PacketContainer[] delayedPackets = new PacketContainer[]{};
        try {
            Disguise disguise = DisguiseAPI.getDisguise(observer, entity);
            if (disguise != null) {
                packets = new PacketContainer[]{sentPacket};
                if (sentPacket.getType() == PacketType.Play.Server.UPDATE_ATTRIBUTES) {
                    if (disguise.isMiscDisguise()) {
                        packets = new PacketContainer[]{};
                    } else {
                        ArrayList<WrappedAttribute> attributes = new ArrayList<WrappedAttribute>();
                        for (WrappedAttribute attribute : (List)sentPacket.getAttributeCollectionModifier().read(0)) {
                            WrappedAttribute.Builder builder;
                            if (!attribute.getAttributeKey().equals("generic.maxHealth")) continue;
                            packets[0] = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
                            if (((LivingWatcher)disguise.getWatcher()).isMaxHealthSet()) {
                                builder = WrappedAttribute.newBuilder();
                                builder.attributeKey("generic.maxHealth");
                                builder.baseValue(((LivingWatcher)disguise.getWatcher()).getMaxHealth());
                            } else if (DisguiseConfig.isMaxHealthDeterminedByDisguisedEntity()) {
                                builder = WrappedAttribute.newBuilder((WrappedAttribute)attribute);
                            } else {
                                builder = WrappedAttribute.newBuilder();
                                builder.attributeKey("generic.maxHealth");
                                builder.baseValue(DisguiseValues.getDisguiseValues(disguise.getType()).getMaxHealth());
                            }
                            builder.packet(packets[0]);
                            attributes.add(builder.build());
                            break;
                        }
                        if (!attributes.isEmpty()) {
                            packets[0].getIntegers().write(0, (Object)entity.getEntityId());
                            packets[0].getAttributeCollectionModifier().write(0, attributes);
                        } else {
                            packets = new PacketContainer[]{};
                        }
                    }
                } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_METADATA) {
                    if (DisguiseConfig.isMetadataPacketsEnabled() && !PacketsManager.isStaticMetadataDisguiseType(disguise)) {
                        List<WrappedWatchableObject> watchableObjects = disguise.getWatcher().convert((List)packets[0].getWatchableCollectionModifier().read(0));
                        packets[0] = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
                        StructureModifier newMods = packets[0].getModifier();
                        newMods.write(0, (Object)entity.getEntityId());
                        packets[0].getWatchableCollectionModifier().write(0, watchableObjects);
                    } else {
                        packets = new PacketContainer[]{};
                    }
                } else if (sentPacket.getType() == PacketType.Play.Server.NAMED_ENTITY_SPAWN || sentPacket.getType() == PacketType.Play.Server.SPAWN_ENTITY_LIVING || sentPacket.getType() == PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB || sentPacket.getType() == PacketType.Play.Server.SPAWN_ENTITY || sentPacket.getType() == PacketType.Play.Server.SPAWN_ENTITY_PAINTING) {
                    PacketContainer[][] spawnPackets = PacketsManager.constructSpawnPackets(observer, disguise, entity);
                    packets = spawnPackets[0];
                    delayedPackets = spawnPackets[1];
                } else if (sentPacket.getType() == PacketType.Play.Server.ANIMATION) {
                    if (disguise.getType().isMisc() || (Integer)packets[0].getIntegers().read(1) == 2 && (!disguise.getType().isPlayer() || DisguiseConfig.isBedPacketsEnabled() && ((PlayerWatcher)disguise.getWatcher()).isSleeping())) {
                        packets = new PacketContainer[]{};
                    }
                } else if (sentPacket.getType() == PacketType.Play.Server.COLLECT) {
                    if (disguise.getType().isMisc()) {
                        packets = new PacketContainer[]{};
                    } else if (DisguiseConfig.isBedPacketsEnabled() && disguise.getType().isPlayer() && ((PlayerWatcher)disguise.getWatcher()).isSleeping()) {
                        PacketContainer newPacket = new PacketContainer(PacketType.Play.Server.ANIMATION);
                        StructureModifier mods = newPacket.getIntegers();
                        mods.write(0, (Object)disguise.getEntity().getEntityId());
                        mods.write(1, (Object)3);
                        packets = new PacketContainer[]{newPacket, sentPacket};
                    }
                } else if (sentPacket.getType() == PacketType.Play.Server.REL_ENTITY_MOVE_LOOK || sentPacket.getType() == PacketType.Play.Server.ENTITY_LOOK || sentPacket.getType() == PacketType.Play.Server.ENTITY_TELEPORT || sentPacket.getType() == PacketType.Play.Server.REL_ENTITY_MOVE) {
                    if (!(disguise.getType() != DisguiseType.RABBIT || sentPacket.getType() != PacketType.Play.Server.REL_ENTITY_MOVE && sentPacket.getType() != PacketType.Play.Server.REL_ENTITY_MOVE_LOOK || !entity.getMetadata("LibsRabbitHop").isEmpty() && System.currentTimeMillis() - ((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).asLong() >= 100L && System.currentTimeMillis() - ((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).asLong() <= 500L)) {
                        if (entity.getMetadata("LibsRabbitHop").isEmpty() || System.currentTimeMillis() - ((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).asLong() > 500L) {
                            entity.removeMetadata("LibsRabbitHop", (Plugin)libsDisguises);
                            entity.setMetadata("LibsRabbitHop", (MetadataValue)new FixedMetadataValue((Plugin)libsDisguises, (Object)System.currentTimeMillis()));
                        }
                        packets = Arrays.copyOf(packets, packets.length + 1);
                        packets[1] = new PacketContainer(PacketType.Play.Server.ENTITY_STATUS);
                        packets[1].getIntegers().write(0, (Object)entity.getEntityId());
                        packets[1].getBytes().write(0, (Object)1);
                    }
                    if (sentPacket.getType() == PacketType.Play.Server.ENTITY_LOOK && disguise.getType() == DisguiseType.WITHER_SKULL) {
                        packets = new PacketContainer[]{};
                    } else if (sentPacket.getType() != PacketType.Play.Server.REL_ENTITY_MOVE) {
                        packets[0] = sentPacket.shallowClone();
                        StructureModifier bytes = packets[0].getBytes();
                        byte yawValue = (Byte)bytes.read(0);
                        byte pitchValue = (Byte)bytes.read(1);
                        bytes.write(0, (Object)PacketsManager.getYaw(disguise.getType(), entity.getType(), yawValue));
                        bytes.write(1, (Object)PacketsManager.getPitch(disguise.getType(), DisguiseType.getType(entity.getType()), pitchValue));
                        if (sentPacket.getType() == PacketType.Play.Server.ENTITY_TELEPORT && disguise.getType() == DisguiseType.ITEM_FRAME) {
                            double y;
                            StructureModifier doubles = packets[0].getDoubles();
                            Location loc = entity.getLocation();
                            double data = (loc.getYaw() % 360.0f + 720.0f + 45.0f) / 90.0f % 4.0f;
                            if (data % 2.0 == 0.0) {
                                if (data % 2.0 == 0.0) {
                                    doubles.write(3, (Object)loc.getZ());
                                } else {
                                    doubles.write(1, (Object)loc.getZ());
                                }
                            }
                            if ((y = PacketsManager.getYModifier(entity, disguise)) != 0.0) {
                                doubles.write(2, (Object)((Double)doubles.read(2) + y));
                            }
                        }
                    }
                } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_EQUIPMENT) {
                    ItemStack heldItem;
                    EquipmentSlot slot = ReflectionManager.createEquipmentSlot(packets[0].getModifier().read(1));
                    ItemStack itemStack = disguise.getWatcher().getItemStack(slot);
                    if (itemStack != null) {
                        packets[0] = packets[0].shallowClone();
                        packets[0].getModifier().write(2, itemStack.getTypeId() == 0 ? null : ReflectionManager.getNmsItem(itemStack));
                    }
                    if (disguise.getWatcher().isRightClicking() && slot == EquipmentSlot.HAND && (heldItem = (ItemStack)packets[0].getItemModifier().read(0)) != null && heldItem.getType() != Material.AIR) {
                        List<WrappedWatchableObject> list = new ArrayList<WrappedWatchableObject>();
                        if (DisguiseConfig.isMetadataPacketsEnabled() && !PacketsManager.isStaticMetadataDisguiseType(disguise)) {
                            WrappedWatchableObject watch = ReflectionManager.createWatchable(0, WrappedDataWatcher.getEntityWatcher((Entity)entity).getByte(0));
                            list.add(watch);
                            list = disguise.getWatcher().convert(list);
                        } else {
                            for (WrappedWatchableObject obj : disguise.getWatcher().getWatchableObjects()) {
                                if (obj.getIndex() != 0) continue;
                                list.add(obj);
                                break;
                            }
                        }
                        PacketContainer packetBlock = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
                        packetBlock.getModifier().write(0, (Object)entity.getEntityId());
                        packetBlock.getWatchableCollectionModifier().write(0, list);
                        PacketContainer packetUnblock = packetBlock.deepClone();
                        for (WrappedWatchableObject watcher : (List)packetUnblock.getWatchableCollectionModifier().read(0)) {
                            watcher.setValue((Object)((byte)((Byte)watcher.getValue() & 0xFFFFFFEF)));
                        }
                        packets = new PacketContainer[]{packetUnblock, packets[0], packetBlock};
                    }
                } else if (sentPacket.getType() == PacketType.Play.Server.BED) {
                    if (!disguise.getType().isPlayer()) {
                        packets = new PacketContainer[]{};
                    }
                } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_STATUS) {
                    if ((Byte)packets[0].getBytes().read(0) == 3) {
                        packets = new PacketContainer[]{};
                    }
                } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_HEAD_ROTATION) {
                    if (disguise.getType().isPlayer() && entity.getType() != EntityType.PLAYER) {
                        Location loc = entity.getLocation();
                        byte pitch = PacketsManager.getPitch(disguise.getType(), DisguiseType.getType(entity.getType()), (byte)(loc.getPitch() * 256.0f / 360.0f));
                        byte yaw = PacketsManager.getYaw(disguise.getType(), entity.getType(), (Byte)sentPacket.getBytes().read(0));
                        PacketContainer rotation = new PacketContainer(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
                        StructureModifier mods = rotation.getModifier();
                        mods.write(0, (Object)entity.getEntityId());
                        mods.write(1, (Object)yaw);
                        PacketContainer look = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
                        look.getIntegers().write(0, (Object)entity.getEntityId());
                        look.getBytes().write(0, (Object)yaw);
                        look.getBytes().write(1, (Object)pitch);
                        packets = new PacketContainer[]{look, rotation};
                    }
                } else {
                    packets = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (packets == null) {
            packetContainerArray = null;
        } else {
            PacketContainer[][] packetContainerArrayArray = new PacketContainer[2][];
            packetContainerArrayArray[0] = packets;
            packetContainerArray = packetContainerArrayArray;
            packetContainerArrayArray[1] = delayedPackets;
        }
        return packetContainerArray;
    }

    public static boolean isStaticMetadataDisguiseType(Disguise disguise) {
        return false;
    }
}

