/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.google.common.base.Optional;
import java.util.UUID;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagType;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.Material;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

public class HorseWatcher
extends AgeableWatcher {
    public HorseWatcher(Disguise disguise) {
        super(disguise);
        this.setStyle(Horse.Style.values()[DisguiseUtilities.random.nextInt(Horse.Style.values().length)]);
        this.setColor(Horse.Color.values()[DisguiseUtilities.random.nextInt(Horse.Color.values().length)]);
    }

    public Horse.Variant getVariant() {
        return Horse.Variant.values()[this.getValue(FlagType.HORSE_VARIANT)];
    }

    public void setVariant(Horse.Variant variant) {
        this.setVariant(variant.ordinal());
    }

    public void setVariant(int variant) {
        if (variant < 0 || variant > 4) {
            variant = 0;
        }
        this.setValue(FlagType.HORSE_VARIANT, variant);
        this.sendData(FlagType.HORSE_VARIANT);
    }

    public Horse.Color getColor() {
        return Horse.Color.values()[this.getValue(FlagType.HORSE_COLOR) & 0xFF];
    }

    public ItemStack getHorseArmor() {
        int horseValue = this.getHorseArmorAsInt();
        switch (horseValue) {
            case 1: {
                return new ItemStack(Material.IRON_BARDING);
            }
            case 2: {
                return new ItemStack(Material.GOLD_BARDING);
            }
            case 3: {
                return new ItemStack(Material.DIAMOND_BARDING);
            }
        }
        return null;
    }

    protected int getHorseArmorAsInt() {
        return this.getValue(FlagType.HORSE_ARMOR);
    }

    public Optional<UUID> getOwner() {
        return this.getValue(FlagType.HORSE_OWNER);
    }

    public Horse.Style getStyle() {
        return Horse.Style.values()[this.getValue(FlagType.HORSE_COLOR) >>> 8];
    }

    public boolean hasChest() {
        return this.isHorseFlag(8);
    }

    public boolean isBreedable() {
        return this.isHorseFlag(16);
    }

    public boolean isGrazing() {
        return this.isHorseFlag(32);
    }

    public boolean isMouthOpen() {
        return this.isHorseFlag(128);
    }

    public boolean isRearing() {
        return this.isHorseFlag(64);
    }

    public boolean isSaddled() {
        return this.isHorseFlag(4);
    }

    public boolean isTamed() {
        return this.isHorseFlag(2);
    }

    private boolean isHorseFlag(int i) {
        return (this.getHorseFlag() & i) != 0;
    }

    private byte getHorseFlag() {
        return this.getValue(FlagType.HORSE_META);
    }

    public void setCanBreed(boolean breed) {
        this.setHorseFlag(16, breed);
    }

    public void setCarryingChest(boolean chest) {
        this.setHorseFlag(8, chest);
    }

    public void setColor(Horse.Color color) {
        this.setValue(FlagType.HORSE_COLOR, color.ordinal() & 0xFF | this.getStyle().ordinal() << 8);
        this.sendData(FlagType.HORSE_COLOR);
    }

    private void setHorseFlag(int i, boolean flag) {
        byte j = this.getValue(FlagType.HORSE_META);
        if (flag) {
            this.setValue(FlagType.HORSE_META, (byte)(j | i));
        } else {
            this.setValue(FlagType.HORSE_META, (byte)(j & ~i));
        }
        this.sendData(FlagType.HORSE_META);
    }

    public void setGrazing(boolean grazing) {
        this.setHorseFlag(32, grazing);
    }

    protected void setHorseArmor(int armor) {
        this.setValue(FlagType.HORSE_ARMOR, armor);
        this.sendData(FlagType.HORSE_ARMOR);
    }

    public void setHorseArmor(ItemStack item) {
        int value = 0;
        if (item != null) {
            Material mat = item.getType();
            if (mat == Material.IRON_BARDING) {
                value = 1;
            } else if (mat == Material.GOLD_BARDING) {
                value = 2;
            } else if (mat == Material.DIAMOND_BARDING) {
                value = 3;
            }
        }
        this.setHorseArmor(value);
    }

    public void setMouthOpen(boolean mouthOpen) {
        this.setHorseFlag(128, mouthOpen);
    }

    public void setOwner(UUID uuid) {
        this.setValue(FlagType.HORSE_OWNER, Optional.of((Object)uuid));
        this.sendData(FlagType.HORSE_OWNER);
    }

    public void setRearing(boolean rear) {
        this.setHorseFlag(64, rear);
    }

    public void setSaddled(boolean saddled) {
        this.setHorseFlag(4, saddled);
    }

    public void setStyle(Horse.Style style) {
        this.setValue(FlagType.HORSE_COLOR, this.getColor().ordinal() & 0xFF | style.ordinal() << 8);
        this.sendData(FlagType.HORSE_COLOR);
    }

    public void setTamed(boolean tamed) {
        this.setHorseFlag(2, tamed);
    }
}

