/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.entity.Player;

public abstract class TargetedDisguise
extends Disguise {
    private List<String> disguiseViewers = new ArrayList<String>();
    private TargetType targetType = TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS;

    public TargetedDisguise addPlayer(Player player) {
        this.addPlayer(player.getName());
        return this;
    }

    public TargetedDisguise addPlayer(String playername) {
        if (!this.disguiseViewers.contains(playername)) {
            this.disguiseViewers.add(playername);
            if (DisguiseAPI.isDisguiseInUse(this)) {
                DisguiseUtilities.checkConflicts(this, playername);
                DisguiseUtilities.refreshTracker(this, playername);
            }
        }
        return this;
    }

    public boolean canSee(Player player) {
        return this.canSee(player.getName());
    }

    public boolean canSee(String playername) {
        boolean hasPlayer = this.disguiseViewers.contains(playername);
        if (this.targetType == TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) {
            return !hasPlayer;
        }
        return hasPlayer;
    }

    public TargetType getDisguiseTarget() {
        return this.targetType;
    }

    public List<String> getObservers() {
        return Collections.unmodifiableList(this.disguiseViewers);
    }

    public TargetedDisguise removePlayer(Player player) {
        this.removePlayer(player.getName());
        return this;
    }

    public TargetedDisguise removePlayer(String playername) {
        if (this.disguiseViewers.contains(playername)) {
            this.disguiseViewers.remove(playername);
            if (DisguiseAPI.isDisguiseInUse(this)) {
                DisguiseUtilities.checkConflicts(this, playername);
                DisguiseUtilities.refreshTracker(this, playername);
            }
        }
        return this;
    }

    public TargetedDisguise setDisguiseTarget(TargetType newTargetType) {
        if (DisguiseUtilities.isDisguiseInUse(this)) {
            throw new RuntimeException("Cannot set the disguise target after the entity has been disguised");
        }
        this.targetType = newTargetType;
        return this;
    }

    public TargetedDisguise silentlyAddPlayer(String playername) {
        if (!this.disguiseViewers.contains(playername)) {
            this.disguiseViewers.add(playername);
        }
        return this;
    }

    public TargetedDisguise silentlyRemovePlayer(String playername) {
        if (this.disguiseViewers.contains(playername)) {
            this.disguiseViewers.remove(playername);
        }
        return this;
    }

    public static enum TargetType {
        HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS,
        SHOW_TO_EVERYONE_BUT_THESE_PLAYERS;

    }
}

