/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagType;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.PacketsManager;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FlagWatcher {
    private boolean _addEntityAnimations = DisguiseConfig.isEntityAnimationsAdded();
    private HashMap<Integer, Object> _backupEntityValues = new HashMap();
    private TargetedDisguise _disguise;
    private HashMap<Integer, Object> _entityValues = new HashMap();
    private EntityEquipment _equipment;
    private boolean _hasDied;
    private HashSet<Integer> _modifiedEntityAnimations = new HashSet();
    private List<WrappedWatchableObject> _watchableObjects;

    public FlagWatcher(Disguise disguise) {
        this._disguise = (TargetedDisguise)disguise;
        this._equipment = ReflectionManager.createEntityEquipment(disguise.getEntity());
    }

    private byte addEntityAnimations(byte originalValue, byte entityValue) {
        byte valueByte = originalValue;
        for (int i = 0; i < 6; ++i) {
            if ((entityValue & 1 << i) == 0 || this._modifiedEntityAnimations.contains(i)) continue;
            valueByte = (byte)(valueByte | 1 << i);
        }
        originalValue = valueByte;
        return originalValue;
    }

    public FlagWatcher clone(Disguise owningDisguise) {
        FlagWatcher cloned;
        try {
            cloned = (FlagWatcher)this.getClass().getConstructor(Disguise.class).newInstance(this.getDisguise());
        }
        catch (Exception e) {
            e.printStackTrace();
            cloned = new FlagWatcher(this.getDisguise());
        }
        cloned._entityValues = (HashMap)this._entityValues.clone();
        cloned._equipment = ReflectionManager.createEntityEquipment(cloned.getDisguise().getEntity());
        cloned._modifiedEntityAnimations = (HashSet)this._modifiedEntityAnimations.clone();
        cloned._addEntityAnimations = this._addEntityAnimations;
        return cloned;
    }

    public List<WrappedWatchableObject> convert(List<WrappedWatchableObject> list) {
        ArrayList<WrappedWatchableObject> newList = new ArrayList<WrappedWatchableObject>();
        HashSet<Integer> sentValues = new HashSet<Integer>();
        boolean sendAllCustom = false;
        for (WrappedWatchableObject watch : list) {
            boolean isDirty;
            int id = watch.getIndex();
            sentValues.add(id);
            if (id == 1) {
                sendAllCustom = true;
            }
            Object value = null;
            if (this._entityValues.containsKey(id)) {
                if (this._entityValues.get(id) == null) continue;
                value = this._entityValues.get(id);
            } else if (this._backupEntityValues.containsKey(id)) {
                if (this._backupEntityValues.get(id) == null) continue;
                value = this._backupEntityValues.get(id);
            }
            if (value != null) {
                if (this.isEntityAnimationsAdded() && id == 0) {
                    value = this.addEntityAnimations((Byte)value, (Byte)watch.getValue());
                }
                isDirty = watch.getDirtyState();
                watch = ReflectionManager.createWatchable(id, value);
                if (watch == null) continue;
                if (!isDirty) {
                    watch.setDirtyState(false);
                }
            } else {
                isDirty = watch.getDirtyState();
                if ((watch = ReflectionManager.createWatchable(id, watch.getValue())) == null) continue;
                if (!isDirty) {
                    watch.setDirtyState(false);
                }
            }
            newList.add(watch);
        }
        if (sendAllCustom) {
            for (Integer id : this._entityValues.keySet()) {
                WrappedWatchableObject watch;
                Object value;
                if (sentValues.contains(id) || (value = this._entityValues.get(id)) == null || (watch = ReflectionManager.createWatchable(id, value)) == null) continue;
                newList.add(watch);
            }
        }
        if (this.getDisguise().isSelfDisguiseVisible() && this.getDisguise().getEntity() != null && this.getDisguise().getEntity() instanceof Player) {
            for (WrappedWatchableObject watch : newList) {
                Object value;
                if (watch.getIndex() != 6 || (value = watch.getValue()) == null || !(value instanceof Float)) continue;
                float newHealth = ((Float)value).floatValue();
                if (newHealth > 0.0f && this._hasDied) {
                    this._hasDied = false;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DisguiseUtilities.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DisguiseUtilities.sendSelfDisguise((Player)FlagWatcher.this.getDisguise().getEntity(), FlagWatcher.this._disguise);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }, 2L);
                    continue;
                }
                if (!(newHealth <= 0.0f) || this._hasDied) continue;
                this._hasDied = true;
            }
        }
        return newList;
    }

    public ItemStack[] getArmor() {
        ItemStack[] armor = new ItemStack[4];
        System.arraycopy(armor, 0, armor, 0, 4);
        return armor;
    }

    public String getCustomName() {
        return this.getValue(FlagType.ENTITY_CUSTOM_NAME);
    }

    protected TargetedDisguise getDisguise() {
        return this._disguise;
    }

    private boolean getEntityFlag(int byteValue) {
        return (this.getValue(FlagType.ENTITY_META) & 1 << byteValue) != 0;
    }

    public EntityEquipment getEquipment() {
        return this._equipment;
    }

    public ItemStack getItemInMainHand() {
        if (this._equipment == null) {
            return null;
        }
        return this._equipment.getItemInMainHand();
    }

    public ItemStack getItemInOffHand() {
        if (this._equipment == null) {
            return null;
        }
        return this._equipment.getItemInOffHand();
    }

    public ItemStack getItemStack(EquipmentSlot slot) {
        if (this._equipment == null) {
            return null;
        }
        switch (slot) {
            case CHEST: {
                return this._equipment.getChestplate();
            }
            case FEET: {
                return this._equipment.getBoots();
            }
            case HAND: {
                return this._equipment.getItemInMainHand();
            }
            case HEAD: {
                return this._equipment.getHelmet();
            }
            case LEGS: {
                return this._equipment.getLeggings();
            }
            case OFF_HAND: {
                return this._equipment.getItemInOffHand();
            }
        }
        return null;
    }

    protected <Y> Y getValue(FlagType<Y> flagType) {
        if (this._entityValues.containsKey(flagType.getIndex())) {
            return (Y)this._entityValues.get(flagType.getIndex());
        }
        return flagType.getDefault();
    }

    public List<WrappedWatchableObject> getWatchableObjects() {
        if (this._watchableObjects == null) {
            this.rebuildWatchableObjects();
        }
        return this._watchableObjects;
    }

    public boolean hasCustomName() {
        return this.getCustomName() != null;
    }

    protected boolean hasValue(FlagType no) {
        return this._entityValues.containsKey(no.getIndex());
    }

    public boolean isBurning() {
        return this.getEntityFlag(0);
    }

    public boolean isCustomNameVisible() {
        return this.getValue(FlagType.ENTITY_CUSTOM_NAME_VISIBLE);
    }

    public boolean isEntityAnimationsAdded() {
        return this._addEntityAnimations;
    }

    public boolean isFlyingWithElytra() {
        return this.getEntityFlag(7);
    }

    public boolean isGlowing() {
        return this.getEntityFlag(6);
    }

    public boolean isInvisible() {
        return this.getEntityFlag(5);
    }

    public boolean isNoGravity() {
        return this.getValue(FlagType.ENTITY_NO_GRAVITY);
    }

    public boolean isRightClicking() {
        return this.getEntityFlag(4);
    }

    public boolean isSneaking() {
        return this.getEntityFlag(1);
    }

    public boolean isSprinting() {
        return this.getEntityFlag(3);
    }

    public void rebuildWatchableObjects() {
        this._watchableObjects = new ArrayList<WrappedWatchableObject>();
        for (int i = 0; i <= 31; ++i) {
            WrappedWatchableObject watchable = null;
            if (this._entityValues.containsKey(i) && this._entityValues.get(i) != null) {
                watchable = ReflectionManager.createWatchable(i, this._entityValues.get(i));
            } else {
                if (!this._backupEntityValues.containsKey(i) || this._backupEntityValues.get(i) == null) continue;
                watchable = ReflectionManager.createWatchable(i, this._backupEntityValues.get(i));
            }
            if (watchable == null) continue;
            this._watchableObjects.add(watchable);
        }
    }

    protected void sendData(FlagType ... dataValues) {
        if (!DisguiseAPI.isDisguiseInUse(this.getDisguise()) || this.getDisguise().getWatcher() != this) {
            return;
        }
        ArrayList<WrappedWatchableObject> list = new ArrayList<WrappedWatchableObject>();
        for (FlagType data : dataValues) {
            WrappedWatchableObject watch;
            if (!this._entityValues.containsKey(data.getIndex()) || this._entityValues.get(data.getIndex()) == null) continue;
            Object value = this._entityValues.get(data.getIndex());
            if (this.isEntityAnimationsAdded() && DisguiseConfig.isMetadataPacketsEnabled() && data == FlagType.ENTITY_META && !PacketsManager.isStaticMetadataDisguiseType(this._disguise)) {
                value = this.addEntityAnimations((Byte)value, WrappedDataWatcher.getEntityWatcher((Entity)this._disguise.getEntity()).getByte(0));
            }
            if ((watch = ReflectionManager.createWatchable(data.getIndex(), value)) == null) continue;
            list.add(watch);
        }
        if (!list.isEmpty()) {
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
            StructureModifier mods = packet.getModifier();
            mods.write(0, (Object)this.getDisguise().getEntity().getEntityId());
            packet.getWatchableCollectionModifier().write(0, list);
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                try {
                    if (player == this.getDisguise().getEntity()) {
                        PacketContainer temp = packet.shallowClone();
                        temp.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, temp);
                        continue;
                    }
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setAddEntityAnimations(boolean isEntityAnimationsAdded) {
        this._addEntityAnimations = isEntityAnimationsAdded;
    }

    public void setArmor(ItemStack[] itemstack) {
        this.setItemStack(EquipmentSlot.HEAD, itemstack[0]);
        this.setItemStack(EquipmentSlot.CHEST, itemstack[1]);
        this.setItemStack(EquipmentSlot.LEGS, itemstack[2]);
        this.setItemStack(EquipmentSlot.FEET, itemstack[3]);
    }

    protected void setBackupValue(FlagType no, Object value) {
        this._backupEntityValues.put(no.getIndex(), value);
    }

    public void setBurning(boolean setBurning) {
        this.setEntityFlag(0, setBurning);
        this.sendData(FlagType.ENTITY_META);
    }

    public void setCustomName(String name) {
        if (name != null && name.length() > 64) {
            name = name.substring(0, 64);
        }
        this.setValue(FlagType.ENTITY_CUSTOM_NAME, name);
        this.sendData(FlagType.ENTITY_CUSTOM_NAME);
    }

    public void setCustomNameVisible(boolean display) {
        this.setValue(FlagType.ENTITY_CUSTOM_NAME_VISIBLE, display);
        this.sendData(FlagType.ENTITY_CUSTOM_NAME_VISIBLE);
    }

    private void setEntityFlag(int byteValue, boolean flag) {
        this._modifiedEntityAnimations.add(byteValue);
        byte b0 = this.getValue(FlagType.ENTITY_META);
        if (flag) {
            this.setValue(FlagType.ENTITY_META, (byte)(b0 | 1 << byteValue));
        } else {
            this.setValue(FlagType.ENTITY_META, (byte)(b0 & ~(1 << byteValue)));
        }
    }

    public void setFlyingWithElytra(boolean flying) {
        this.setEntityFlag(7, flying);
        this.sendData(FlagType.ENTITY_META);
    }

    public void setGlowing(boolean glowing) {
        this.setEntityFlag(6, glowing);
        this.sendData(FlagType.ENTITY_META);
    }

    public void setInvisible(boolean setInvis) {
        this.setEntityFlag(5, setInvis);
        this.sendData(FlagType.ENTITY_META);
    }

    @Deprecated
    public void setItemInHand(ItemStack itemstack) {
        this.setItemInMainHand(itemstack);
    }

    public void setItemInMainHand(ItemStack itemstack) {
        this.setItemStack(EquipmentSlot.HAND, itemstack);
    }

    public void setItemInOffHand(ItemStack itemstack) {
        this.setItemStack(EquipmentSlot.OFF_HAND, itemstack);
    }

    private void setItemStack(EntityEquipment equipment, EquipmentSlot slot, ItemStack itemStack) {
        if (equipment == null) {
            return;
        }
        switch (slot) {
            case CHEST: {
                equipment.setChestplate(itemStack);
                break;
            }
            case FEET: {
                equipment.setBoots(itemStack);
                break;
            }
            case HAND: {
                equipment.setItemInMainHand(itemStack);
                break;
            }
            case HEAD: {
                equipment.setHelmet(itemStack);
                break;
            }
            case LEGS: {
                equipment.setLeggings(itemStack);
                break;
            }
            case OFF_HAND: {
                equipment.setItemInOffHand(itemStack);
            }
        }
    }

    public void setItemStack(EquipmentSlot slot, ItemStack itemStack) {
        if (this._equipment == null) {
            return;
        }
        if (itemStack == null && this.getDisguise().getEntity() instanceof LivingEntity) {
            EntityEquipment equipment = ((LivingEntity)this.getDisguise().getEntity()).getEquipment();
            this.setItemStack(equipment, slot, itemStack);
        }
        Object itemToSend = null;
        if (itemStack != null && itemStack.getTypeId() != 0) {
            itemToSend = ReflectionManager.getNmsItem(itemStack);
        }
        this.setItemStack(this._equipment, slot, itemStack);
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
            StructureModifier mods = packet.getModifier();
            mods.write(0, (Object)this.getDisguise().getEntity().getEntityId());
            mods.write(1, (Object)ReflectionManager.createEnumItemSlot(slot));
            mods.write(2, itemToSend);
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setNoGravity(boolean noGravity) {
        this.setValue(FlagType.ENTITY_NO_GRAVITY, noGravity);
        this.sendData(FlagType.ENTITY_NO_GRAVITY);
    }

    public void setRightClicking(boolean setRightClicking) {
        this.setEntityFlag(4, setRightClicking);
        this.sendData(FlagType.ENTITY_META);
    }

    public void setSneaking(boolean setSneaking) {
        this.setEntityFlag(1, setSneaking);
        this.sendData(FlagType.ENTITY_META);
    }

    public void setSprinting(boolean setSprinting) {
        this.setEntityFlag(3, setSprinting);
        this.sendData(FlagType.ENTITY_META);
    }

    protected <Y> void setValue(FlagType<Y> id, Y value) {
        this._entityValues.put(id.getIndex(), value);
        if (!DisguiseConfig.isMetadataPacketsEnabled()) {
            this.rebuildWatchableObjects();
        }
    }
}

