/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import me.libraryaddict.disguise.commands.BaseDisguiseCommand;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.RabbitType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class HelpDisguiseCommand
extends BaseDisguiseCommand {
    private ArrayList<EnumHelp> enumHelp = new ArrayList();

    public HelpDisguiseCommand() {
        try {
            this.enumHelp.add(new EnumHelp("AnimalColor", "Animal colors", ChatColor.RED + "/disguisehelp AnimalColors " + ChatColor.GREEN + "- View all the colors you can use for a animal color", AnimalColor.values()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.enumHelp.add(new EnumHelp("Art", "Arts", ChatColor.RED + "/disguisehelp Art " + ChatColor.GREEN + "- View all the painting arts you can use on a painting disguise", (Enum[])Class.forName("org.bukkit.Art").getEnumConstants()));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.enumHelp.add(new EnumHelp("HorseColor", "Horse colors", ChatColor.RED + "/disguisehelp HorseColors " + ChatColor.GREEN + "- View all the colors you can use for a horses color", (Enum[])Class.forName("org.bukkit.entity.Horse$Color").getEnumConstants()));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.enumHelp.add(new EnumHelp("HorseStyle", "Horse styles", ChatColor.RED + "/disguisehelp HorseStyles " + ChatColor.GREEN + "- View all the styles you can use for a horses style", (Enum[])Class.forName("org.bukkit.entity.Horse$Style").getEnumConstants()));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.enumHelp.add(new EnumHelp("OcelotType", "Ocelot types", ChatColor.RED + "/disguisehelp OcelotTypes " + ChatColor.GREEN + "- View all the ocelot types you can use for ocelots", (Enum[])Class.forName("org.bukkit.entity.Ocelot$Type").getEnumConstants()));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            ArrayList<String> enumReturns = new ArrayList<String>();
            for (PotionEffectType potionType : PotionEffectType.values()) {
                if (potionType == null) continue;
                enumReturns.add(this.toReadable(potionType.getName()) + ChatColor.RED + "(" + ChatColor.GREEN + potionType.getId() + ChatColor.RED + ")");
            }
            this.enumHelp.add(new EnumHelp("PotionEffect", "PotionEffect", ChatColor.RED + "/disguisehelp PotionEffect " + ChatColor.GREEN + "- View all the potion effects you can set", enumReturns.toArray(new String[enumReturns.size()])));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.enumHelp.add(new EnumHelp("Profession", "Villager professions", ChatColor.RED + "/disguisehelp Professions " + ChatColor.GREEN + "- View all the professions you can set on a villager", (Enum[])Class.forName("org.bukkit.entity.Villager$Profession").getEnumConstants()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enumHelp.add(new EnumHelp("Direction", "Directions", ChatColor.RED + "/disguisehelp Directions " + ChatColor.GREEN + "- View the five directions usable on player setsleeping disguise", (Enum[])Arrays.copyOf(BlockFace.values(), 5)));
        this.enumHelp.add(new EnumHelp("RabbitType", "RabbitType", ChatColor.RED + "/disguisehelp RabbitType " + ChatColor.GREEN + "View the kinds of rabbits you can turn into", RabbitType.values()));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        for (String node : new String[]{"disguise", "disguiseradius", "disguiseentity", "disguiseplayer"}) {
            HashMap<DisguiseType, HashMap<ArrayList<String>, Boolean>> permMap = this.getPermissions(sender, "libsdisguises." + node + ".");
            if (permMap.isEmpty()) continue;
            if (args.length == 0) {
                this.sendCommandUsage(sender, null);
                return true;
            }
            EnumHelp help = null;
            for (EnumHelp s : this.enumHelp) {
                if (!args[0].equalsIgnoreCase(s.getEnumName()) && !args[0].equalsIgnoreCase(s.getEnumName() + "s")) continue;
                help = s;
                break;
            }
            if (help != null) {
                sender.sendMessage(ChatColor.RED + help.getReadableEnum() + ": " + ChatColor.GREEN + StringUtils.join((Object[])help.getEnums(), (String)(ChatColor.RED + ", " + ChatColor.GREEN)));
                return true;
            }
            DisguiseType type = null;
            for (DisguiseType disguiseType : DisguiseType.values()) {
                if (!args[0].equalsIgnoreCase(disguiseType.name()) && !disguiseType.name().replace("_", "").equalsIgnoreCase(args[0])) continue;
                type = disguiseType;
                break;
            }
            if (type == null) {
                sender.sendMessage(ChatColor.RED + "Cannot find the disguise " + args[0]);
                return true;
            }
            if (!permMap.containsKey((Object)type)) {
                sender.sendMessage(ChatColor.RED + "You do not have permission for that disguise!");
                return true;
            }
            ArrayList<String> methods = new ArrayList<String>();
            HashMap<String, ChatColor> map = new HashMap<String, ChatColor>();
            Class<? extends FlagWatcher> watcher = type.getWatcherClass();
            int ignored = 0;
            try {
                for (Method method : this.getDisguiseWatcherMethods(watcher)) {
                    if (method.getName().startsWith("get") || method.getParameterTypes().length != 1 || method.getAnnotation(Deprecated.class) != null) continue;
                    if (args.length < 2 || !args[1].equalsIgnoreCase("show")) {
                        boolean allowed = false;
                        for (ArrayList<String> key : permMap.get((Object)type).keySet()) {
                            if (permMap.get((Object)type).get(key).booleanValue()) {
                                if (!key.contains("*") && !key.contains(method.getName().toLowerCase())) continue;
                                allowed = true;
                                break;
                            }
                            if (key.contains(method.getName().toLowerCase())) continue;
                            allowed = true;
                            break;
                        }
                        if (!allowed) {
                            ++ignored;
                            continue;
                        }
                    }
                    Class<?> c = method.getParameterTypes()[0];
                    String valueType = null;
                    if (c == String.class) {
                        valueType = "String";
                    } else if (Boolean.TYPE == c) {
                        valueType = "True/False";
                    } else if (Integer.TYPE == c) {
                        valueType = "Number";
                    } else if (Float.TYPE == c || Double.TYPE == c) {
                        valueType = "Decimal";
                    } else if (AnimalColor.class == c) {
                        valueType = "Color";
                    } else if (ItemStack.class == c) {
                        valueType = "Item (id:damage)";
                    } else if (ItemStack[].class == c) {
                        valueType = "4 items (id:damage,id,...)";
                    } else if (c.getSimpleName().equals("Style")) {
                        valueType = "Horse Style";
                    } else if (c.getSimpleName().equals("Color")) {
                        valueType = "Horse Color";
                    } else if (c.getSimpleName().equals("Type")) {
                        valueType = "Ocelot type";
                    } else if (c.getSimpleName().equals("Profession")) {
                        valueType = "Villager Profession";
                    } else if (PotionEffectType.class == c) {
                        valueType = "Potion effect";
                    } else if (c == int[].class) {
                        valueType = "number,number,number...";
                    } else if (c == BlockFace.class) {
                        valueType = "direction";
                    } else if (c == RabbitType.class) {
                        valueType = "rabbit type";
                    } else if (c == BlockPosition.class) {
                        valueType = "three numbers";
                    } else if (c == WrappedGameProfile.class) {
                        valueType = "gameprofile";
                    }
                    if (valueType == null) continue;
                    ChatColor methodColor = ChatColor.YELLOW;
                    Class<?> declaring = method.getDeclaringClass();
                    if (declaring == LivingWatcher.class) {
                        methodColor = ChatColor.AQUA;
                    } else if (!FlagWatcher.class.isAssignableFrom(declaring) || declaring == FlagWatcher.class) {
                        methodColor = ChatColor.GRAY;
                    }
                    String str = method.getName() + ChatColor.DARK_RED + "(" + ChatColor.GREEN + valueType + ChatColor.DARK_RED + ")";
                    map.put(str, methodColor);
                    methods.add(str);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Collections.sort(methods, String.CASE_INSENSITIVE_ORDER);
            for (int i = 0; i < methods.size(); ++i) {
                methods.set(i, map.get(methods.get(i)) + (String)methods.get(i));
            }
            if (methods.isEmpty()) {
                methods.add(ChatColor.RED + "No options with permission to use");
            }
            sender.sendMessage(ChatColor.DARK_RED + type.toReadable() + " options: " + StringUtils.join(methods, (String)(ChatColor.DARK_RED + ", ")));
            if (ignored > 0) {
                sender.sendMessage(ChatColor.RED + "Ignored " + ignored + " options you do not have permission to view. Add 'show' to view unusable options.");
            }
            return true;
        }
        sender.sendMessage(ChatColor.RED + "You are forbidden to use this command.");
        return true;
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseType, HashMap<ArrayList<String>, Boolean>> map) {
        sender.sendMessage(ChatColor.RED + "/disguisehelp <DisguiseType> " + ChatColor.GREEN + "- View the options you can set on a disguise. Add 'show' to reveal the options you don't have permission to use");
        for (EnumHelp s : this.enumHelp) {
            sender.sendMessage(s.getEnumDescription());
        }
    }

    public String toReadable(String string) {
        Object[] split = string.split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = ((String)split[i]).substring(0, 1) + ((String)split[i]).substring(1).toLowerCase();
        }
        return StringUtils.join((Object[])split, (String)"_");
    }

    private class EnumHelp {
        private String enumDescription;
        private String enumName;
        private String[] enums;
        private String readableEnum;

        public EnumHelp(String enumName, String enumReadable, String enumDescription, Enum[] enums) {
            String[] strings = new String[enums.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = HelpDisguiseCommand.this.toReadable(enums[i].name());
            }
            this.enumName = enumName;
            this.enumDescription = enumDescription;
            this.enums = strings;
            this.readableEnum = enumReadable;
        }

        public EnumHelp(String enumName, String enumReadable, String enumDescription, String[] enums) {
            this.enumName = enumName;
            this.enumDescription = enumDescription;
            this.enums = enums;
            this.readableEnum = enumReadable;
        }

        public String getEnumDescription() {
            return this.enumDescription;
        }

        public String getEnumName() {
            return this.enumName;
        }

        public String[] getEnums() {
            return this.enums;
        }

        public String getReadableEnum() {
            return this.readableEnum;
        }
    }
}

