/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.util.ArrayList;
import java.util.HashMap;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.BaseDisguiseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseCommand
extends BaseDisguiseCommand {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Disguise disguise;
        if (sender.getName().equals("CONSOLE")) {
            sender.sendMessage(ChatColor.RED + "You may not use this command from the console!");
            return true;
        }
        try {
            disguise = this.parseDisguise(sender, args, this.getPermissions(sender));
        }
        catch (BaseDisguiseCommand.DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        if (DisguiseConfig.isNameOfPlayerShownAboveDisguise() && disguise.getWatcher() instanceof LivingWatcher) {
            disguise.getWatcher().setCustomName(((Player)sender).getDisplayName());
            if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                disguise.getWatcher().setCustomNameVisible(true);
            }
        }
        DisguiseAPI.disguiseToAll((Entity)((Player)sender), disguise);
        if (disguise.isDisguiseInUse()) {
            sender.sendMessage(ChatColor.RED + "Now disguised as a " + disguise.getType().toReadable());
        } else {
            sender.sendMessage(ChatColor.RED + "Failed to disguise as a " + disguise.getType().toReadable());
        }
        return true;
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, HashMap<DisguiseType, HashMap<ArrayList<String>, Boolean>> map) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(map);
        sender.sendMessage(ChatColor.DARK_GREEN + "Choose a disguise to become the disguise!");
        sender.sendMessage(ChatColor.DARK_GREEN + "You can use the disguises: " + ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN)));
        if (allowedDisguises.contains("player")) {
            sender.sendMessage(ChatColor.DARK_GREEN + "/disguise player <Name>");
        }
        sender.sendMessage(ChatColor.DARK_GREEN + "/disguise <DisguiseType> <Baby>");
        if (allowedDisguises.contains("dropped_item") || allowedDisguises.contains("falling_block")) {
            sender.sendMessage(ChatColor.DARK_GREEN + "/disguiseplayer <Dropped_Item/Falling_Block> <Id> <Durability>");
        }
    }
}

