/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.ReflectionManager;
import me.libraryaddict.disguise.utilities.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class DisguiseListener
implements Listener {
    private String currentVersion;
    private HashMap<String, Boolean[]> disguiseClone = new HashMap();
    private HashMap<String, Disguise> disguiseEntity = new HashMap();
    private HashMap<String, BukkitRunnable> disguiseRunnable = new HashMap();
    private String latestVersion;
    private LibsDisguises plugin;
    private BukkitTask updaterTask;

    public DisguiseListener(LibsDisguises libsDisguises) {
        this.plugin = libsDisguises;
        if (this.plugin.getConfig().getBoolean("NotifyUpdate")) {
            this.currentVersion = this.plugin.getDescription().getVersion();
            this.updaterTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        UpdateChecker updateChecker = new UpdateChecker();
                        updateChecker.checkUpdate("v" + DisguiseListener.this.currentVersion);
                        DisguiseListener.this.latestVersion = updateChecker.getLatestVersion();
                        if (DisguiseListener.this.latestVersion == null) {
                            return;
                        }
                        DisguiseListener.this.latestVersion = "v" + DisguiseListener.this.latestVersion;
                        Bukkit.getScheduler().runTask((Plugin)DisguiseListener.this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                for (Player p : Bukkit.getOnlinePlayers()) {
                                    if (!p.hasPermission(DisguiseConfig.getUpdateNotificationPermission())) continue;
                                    p.sendMessage(String.format(DisguiseConfig.getUpdateMessage(), DisguiseListener.this.currentVersion, DisguiseListener.this.latestVersion));
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        System.out.print(String.format("[LibsDisguises] Failed to check for update: %s", ex.getMessage()));
                    }
                }
            }, 0L, 432000L);
        }
    }

    public void cleanup() {
        for (BukkitRunnable r : this.disguiseRunnable.values()) {
            r.cancel();
        }
        for (Disguise d : this.disguiseEntity.values()) {
            d.removeDisguise();
        }
        this.disguiseClone.clear();
        this.updaterTask.cancel();
    }

    private void checkPlayerCanBlowDisguise(Player entity) {
        Disguise[] disguises = DisguiseAPI.getDisguises((Entity)entity);
        if (disguises.length > 0) {
            DisguiseAPI.undisguiseToAll((Entity)entity);
            if (DisguiseConfig.getDisguiseBlownMessage().length() > 0) {
                entity.sendMessage(DisguiseConfig.getDisguiseBlownMessage());
            }
        }
    }

    private void chunkMove(Player player, Location newLoc, Location oldLoc) {
        try {
            for (PacketContainer packet : DisguiseUtilities.getBedChunkPacket(newLoc, oldLoc)) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
            }
            if (newLoc != null) {
                for (HashSet<TargetedDisguise> list : DisguiseUtilities.getDisguises().values()) {
                    for (TargetedDisguise disguise : list) {
                        if (disguise.getEntity() == null || !disguise.isPlayerDisguise() || !disguise.canSee(player) || !((PlayerDisguise)disguise).getWatcher().isSleeping() || !DisguiseUtilities.getPerverts(disguise).contains(player)) continue;
                        PacketContainer[] packets = DisguiseUtilities.getBedPackets(disguise.getEntity() == player ? newLoc : disguise.getEntity().getLocation(), newLoc, (PlayerDisguise)disguise);
                        if (disguise.getEntity() == player) {
                            for (PacketContainer packet : packets) {
                                packet.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                            }
                        }
                        for (PacketContainer packet : packets) {
                            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                        }
                    }
                }
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent event) {
        if (DisguiseConfig.isDisguiseBlownOnAttack()) {
            if (event.getEntity() instanceof Player) {
                this.checkPlayerCanBlowDisguise((Player)event.getEntity());
            }
            if (event.getDamager() instanceof Player) {
                this.checkPlayerCanBlowDisguise((Player)event.getDamager());
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        if (this.latestVersion != null && p.hasPermission(DisguiseConfig.getUpdateNotificationPermission())) {
            p.sendMessage(String.format(DisguiseConfig.getUpdateMessage(), this.currentVersion, this.latestVersion));
        }
        if (DisguiseConfig.isBedPacketsEnabled()) {
            this.chunkMove(p, p.getLocation(), null);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        Disguise disguise;
        Location from;
        if (DisguiseConfig.isBedPacketsEnabled()) {
            Location to = event.getTo();
            from = event.getFrom();
            if (DisguiseUtilities.getChunkCord(to.getBlockX()) != DisguiseUtilities.getChunkCord(from.getBlockX()) || DisguiseUtilities.getChunkCord(to.getBlockZ()) != DisguiseUtilities.getChunkCord(from.getBlockZ())) {
                this.chunkMove(event.getPlayer(), to, from);
            }
        }
        if (DisguiseConfig.isStopShulkerDisguisesFromMoving() && (disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer())) != null && disguise.getType() == DisguiseType.SHULKER) {
            from = event.getFrom();
            Location to = event.getTo();
            to.setX(from.getX());
            to.setZ(from.getZ());
            event.setTo(to);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        ReflectionManager.removePlayer(event.getPlayer());
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Disguise[] disguises;
        for (Disguise disguise : disguises = DisguiseAPI.getDisguises((Entity)event.getPlayer())) {
            if (!disguise.isRemoveDisguiseOnDeath()) continue;
            disguise.removeDisguise();
        }
        if (DisguiseConfig.isBedPacketsEnabled()) {
            final Player player = event.getPlayer();
            this.chunkMove(event.getPlayer(), null, player.getLocation());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    DisguiseListener.this.chunkMove(player, player.getLocation(), null);
                }
            });
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEntityEvent event) {
        if (this.disguiseEntity.containsKey(event.getPlayer().getName()) || this.disguiseClone.containsKey(event.getPlayer().getName())) {
            Player p = event.getPlayer();
            event.setCancelled(true);
            this.disguiseRunnable.remove(p.getName()).cancel();
            Entity entity = event.getRightClicked();
            String entityName = entity instanceof Player && !this.disguiseClone.containsKey(p.getName()) ? entity.getName() : DisguiseType.getType(entity).toReadable();
            if (this.disguiseClone.containsKey(p.getName())) {
                Boolean[] options = this.disguiseClone.remove(p.getName());
                Disguise disguise = DisguiseAPI.getDisguise(p, entity);
                disguise = disguise == null ? DisguiseAPI.constructDisguise(entity, options[0], options[1], options[2]) : disguise.clone();
                char[] alphabet = "abcdefghijklmnopqrstuvwxyz".toCharArray();
                String reference = null;
                int referenceLength = Math.max(2, (int)Math.ceil((0.1 + (double)DisguiseConfig.getMaxClonedDisguises()) / 26.0));
                int attempts = 0;
                while (reference == null && attempts++ < 1000) {
                    reference = "@";
                    for (int i = 0; i < referenceLength; ++i) {
                        reference = reference + alphabet[DisguiseUtilities.random.nextInt(alphabet.length)];
                    }
                    if (DisguiseUtilities.getClonedDisguise(reference) == null) continue;
                    reference = null;
                }
                if (reference != null && DisguiseUtilities.addClonedDisguise(reference, disguise)) {
                    p.sendMessage(ChatColor.RED + "Constructed a " + entityName + " disguise! Your reference is " + reference);
                    p.sendMessage(ChatColor.RED + "Example usage: /disguise " + reference);
                } else {
                    p.sendMessage(ChatColor.RED + "Failed to store the reference due to lack of size. Please set this in the config");
                }
            } else if (this.disguiseEntity.containsKey(p.getName())) {
                Disguise disguise = this.disguiseEntity.remove(p.getName());
                if (disguise != null) {
                    if (disguise.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
                        p.sendMessage(ChatColor.RED + "Can't disguise a living entity as a misc disguise. This has been disabled in the config!");
                    } else {
                        if (entity instanceof Player && DisguiseConfig.isNameOfPlayerShownAboveDisguise() && disguise.getWatcher() instanceof LivingWatcher) {
                            disguise.getWatcher().setCustomName(((Player)entity).getDisplayName());
                            if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                                disguise.getWatcher().setCustomNameVisible(true);
                            }
                        }
                        DisguiseAPI.disguiseToAll(entity, disguise);
                        String disguiseName = "a ";
                        disguiseName = disguise instanceof PlayerDisguise ? "the player " + ((PlayerDisguise)disguise).getName() : disguiseName + disguise.getType().toReadable();
                        if (disguise.isDisguiseInUse()) {
                            p.sendMessage(ChatColor.RED + "Disguised " + (entity instanceof Player ? "" : "the ") + entityName + " as " + disguiseName + "!");
                        } else {
                            p.sendMessage(ChatColor.RED + "Failed to disguise " + (entity instanceof Player ? "" : "the ") + entityName + " as " + disguiseName + "!");
                        }
                    }
                } else if (DisguiseAPI.isDisguised(entity)) {
                    DisguiseAPI.undisguiseToAll(entity);
                    p.sendMessage(ChatColor.RED + "Undisguised " + (entity instanceof Player ? "" : "the ") + entityName);
                } else {
                    p.sendMessage(ChatColor.RED + (entity instanceof Player ? "" : "the") + entityName + " isn't disguised!");
                }
            }
        }
    }

    @EventHandler
    public void onTarget(EntityTargetEvent event) {
        if (DisguiseConfig.isMonstersIgnoreDisguises() && event.getTarget() != null && event.getTarget() instanceof Player && DisguiseAPI.isDisguised(event.getTarget())) {
            switch (event.getReason()) {
                case TARGET_ATTACKED_ENTITY: 
                case TARGET_ATTACKED_OWNER: 
                case OWNER_ATTACKED_TARGET: 
                case CUSTOM: {
                    break;
                }
                default: {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent event) {
        final Player player = event.getPlayer();
        Location to = event.getTo();
        Location from = event.getFrom();
        if (DisguiseConfig.isBedPacketsEnabled() && (DisguiseUtilities.getChunkCord(to.getBlockX()) != DisguiseUtilities.getChunkCord(from.getBlockX()) || DisguiseUtilities.getChunkCord(to.getBlockZ()) != DisguiseUtilities.getChunkCord(from.getBlockZ()))) {
            this.chunkMove(player, null, from);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    DisguiseListener.this.chunkMove(player, player.getLocation(), null);
                }
            });
        }
        if (!DisguiseAPI.isDisguised((Entity)player)) {
            return;
        }
        if (DisguiseConfig.isUndisguiseOnWorldChange() && to.getWorld() != null && from.getWorld() != null && to.getWorld() != from.getWorld()) {
            for (Disguise disguise : DisguiseAPI.getDisguises((Entity)event.getPlayer())) {
                disguise.removeDisguise();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (event.getEntered() instanceof Player && DisguiseAPI.isDisguised((Player)event.getEntered(), event.getEntered())) {
            DisguiseUtilities.removeSelfDisguise((Player)event.getEntered());
            ((Player)event.getEntered()).updateInventory();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleLeave(VehicleExitEvent event) {
        Disguise disguise;
        if (event.getExited() instanceof Player && (disguise = DisguiseAPI.getDisguise((Player)event.getExited(), (Entity)event.getExited())) != null) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    DisguiseUtilities.setupFakeDisguise(disguise);
                    ((Player)disguise.getEntity()).updateInventory();
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldSwitch(PlayerChangedWorldEvent event) {
        if (DisguiseConfig.isBedPacketsEnabled()) {
            this.chunkMove(event.getPlayer(), event.getPlayer().getLocation(), null);
        }
        if (!DisguiseAPI.isDisguised((Entity)event.getPlayer())) {
            return;
        }
        if (DisguiseConfig.isUndisguiseOnWorldChange()) {
            for (Disguise disguise : DisguiseAPI.getDisguises((Entity)event.getPlayer())) {
                disguise.removeDisguise();
            }
        } else {
            boolean viewSelfToggled = DisguiseAPI.isViewSelfToggled((Entity)event.getPlayer());
            if (viewSelfToggled) {
                final Disguise disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer());
                disguise.setViewSelfDisguise(false);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        disguise.setViewSelfDisguise(true);
                    }
                }, 20L);
            }
        }
    }

    public void setDisguiseClone(final String player, Boolean[] options) {
        if (this.disguiseRunnable.containsKey(player)) {
            BukkitRunnable run = this.disguiseRunnable.remove(player);
            run.cancel();
            run.run();
        }
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                DisguiseListener.this.disguiseClone.remove(player);
                DisguiseListener.this.disguiseRunnable.remove(player);
            }
        };
        runnable.runTaskLater((Plugin)this.plugin, (long)(20 * DisguiseConfig.getDisguiseCloneExpire()));
        this.disguiseRunnable.put(player, runnable);
        this.disguiseClone.put(player, options);
    }

    public void setDisguiseEntity(final String player, Disguise disguise) {
        if (this.disguiseRunnable.containsKey(player)) {
            BukkitRunnable run = this.disguiseRunnable.remove(player);
            run.cancel();
            run.run();
        }
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                DisguiseListener.this.disguiseEntity.remove(player);
                DisguiseListener.this.disguiseRunnable.remove(player);
            }
        };
        runnable.runTaskLater((Plugin)this.plugin, (long)(20 * DisguiseConfig.getDisguiseEntityExpire()));
        this.disguiseRunnable.put(player, runnable);
        this.disguiseEntity.put(player, disguise);
    }
}

