/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import me.libraryaddict.disguise.utilities.PacketsManager;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class DisguiseConfig {
    private static boolean animationEnabled;
    private static boolean bedEnabled;
    private static boolean blowDisguisesOnAttack;
    private static boolean collectEnabled;
    private static boolean colorizeSheep;
    private static boolean colorizeWolf;
    private static String disguiseBlownMessage;
    private static int disguiseCloneExpire;
    private static int disguiseEntityExpire;
    private static boolean entityAnimationsAdded;
    private static boolean entityStatusEnabled;
    private static boolean equipmentEnabled;
    private static boolean hearSelfDisguise;
    private static boolean viewSelfDisguise;
    private static boolean hidingArmor;
    private static boolean hidingHeldItem;
    private static boolean keepDisguiseEntityDespawn;
    private static boolean keepDisguisePlayerDeath;
    private static boolean keepDisguisePlayerLogout;
    private static int maxClonedDisguises;
    private static boolean maxHealthIsDisguisedEntity;
    private static boolean miscDisguisesForLivingEnabled;
    private static boolean modifyBoundingBox;
    private static boolean movementEnabled;
    private static boolean sendsEntityMetadata;
    private static boolean sendVelocity;
    private static boolean showNameAboveHead;
    private static boolean showNameAboveHeadAlwaysVisible;
    private static boolean targetDisguises;
    private static boolean undisguiseSwitchWorlds;
    private static boolean stopShulkerDisguisesFromMoving;
    private static String updateMessage;
    private static String updateNotificationPermission;
    private static boolean witherSkullEnabled;

    public static String getDisguiseBlownMessage() {
        return disguiseBlownMessage;
    }

    public static int getDisguiseCloneExpire() {
        return disguiseCloneExpire;
    }

    public static int getDisguiseEntityExpire() {
        return disguiseEntityExpire;
    }

    public static int getMaxClonedDisguises() {
        return maxClonedDisguises;
    }

    public static String getUpdateMessage() {
        return updateMessage;
    }

    public static String getUpdateNotificationPermission() {
        return updateNotificationPermission;
    }

    public static void initConfig(ConfigurationSection config) {
        DisguiseConfig.setSoundsEnabled(config.getBoolean("DisguiseSounds"));
        DisguiseConfig.setVelocitySent(config.getBoolean("SendVelocity"));
        DisguiseConfig.setViewDisguises(config.getBoolean("ViewSelfDisguises"));
        PacketsManager.setViewDisguisesListener(true);
        DisguiseConfig.setHearSelfDisguise(config.getBoolean("HearSelfDisguise"));
        DisguiseConfig.setHideArmorFromSelf(config.getBoolean("RemoveArmor"));
        DisguiseConfig.setHideHeldItemFromSelf(config.getBoolean("RemoveHeldItem"));
        DisguiseConfig.setAddEntityAnimations(config.getBoolean("AddEntityAnimations"));
        DisguiseConfig.setNameOfPlayerShownAboveDisguise(config.getBoolean("ShowNamesAboveDisguises"));
        DisguiseConfig.setNameAboveHeadAlwaysVisible(config.getBoolean("NameAboveHeadAlwaysVisible"));
        DisguiseConfig.setModifyBoundingBox(config.getBoolean("ModifyBoundingBox"));
        DisguiseConfig.setMonstersIgnoreDisguises(config.getBoolean("MonstersIgnoreDisguises"));
        DisguiseConfig.setDisguiseBlownOnAttack(config.getBoolean("BlowDisguises"));
        DisguiseConfig.setDisguiseBlownMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("BlownDisguiseMessage")));
        DisguiseConfig.setKeepDisguiseOnPlayerDeath(config.getBoolean("KeepDisguises.PlayerDeath"));
        DisguiseConfig.setKeepDisguiseOnPlayerLogout(config.getBoolean("KeepDisguises.PlayerLogout"));
        DisguiseConfig.setKeepDisguiseOnEntityDespawn(config.getBoolean("KeepDisguises.EntityDespawn"));
        DisguiseConfig.setMiscDisguisesForLivingEnabled(config.getBoolean("MiscDisguisesForLiving"));
        DisguiseConfig.setMovementPacketsEnabled(config.getBoolean("PacketsEnabled.Movement"));
        DisguiseConfig.setWitherSkullPacketsEnabled(config.getBoolean("PacketsEnabled.WitherSkull"));
        DisguiseConfig.setEquipmentPacketsEnabled(config.getBoolean("PacketsEnabled.Equipment"));
        DisguiseConfig.setAnimationPacketsEnabled(config.getBoolean("PacketsEnabled.Animation"));
        DisguiseConfig.setBedPacketsEnabled(config.getBoolean("PacketsEnabled.Bed"));
        DisguiseConfig.setEntityStatusPacketsEnabled(config.getBoolean("PacketsEnabled.EntityStatus"));
        DisguiseConfig.setCollectPacketsEnabled(config.getBoolean("PacketsEnabled.Collect"));
        DisguiseConfig.setMetadataPacketsEnabled(config.getBoolean("PacketsEnabled.Metadata"));
        DisguiseConfig.setMaxHealthDeterminedByDisguisedEntity(config.getBoolean("MaxHealthDeterminedByEntity"));
        DisguiseConfig.setDisguiseEntityExpire(config.getInt("DisguiseEntityExpire"));
        DisguiseConfig.setDisguiseCloneExpire(config.getInt("DisguiseCloneExpire"));
        DisguiseConfig.setMaxClonedDisguises(config.getInt("DisguiseCloneSize"));
        DisguiseConfig.setSheepDyeable(config.getBoolean("DyeableSheep"));
        DisguiseConfig.setWolfDyeable(config.getBoolean("DyeableWolf"));
        DisguiseConfig.setUndisguiseOnWorldChange(config.getBoolean("UndisguiseOnWorldChange"));
        DisguiseConfig.setUpdateNotificationPermission(config.getString("Permission"));
        DisguiseConfig.setStopShulkerDisguisesFromMoving(config.getBoolean("StopShulkerDisguisesFromMoving", true));
    }

    public static boolean isAnimationPacketsEnabled() {
        return animationEnabled;
    }

    public static boolean isBedPacketsEnabled() {
        return bedEnabled;
    }

    public static boolean isCollectPacketsEnabled() {
        return collectEnabled;
    }

    public static boolean isDisguiseBlownOnAttack() {
        return blowDisguisesOnAttack;
    }

    public static boolean isEntityAnimationsAdded() {
        return entityAnimationsAdded;
    }

    public static boolean isEntityStatusPacketsEnabled() {
        return entityStatusEnabled;
    }

    public static boolean isEquipmentPacketsEnabled() {
        return equipmentEnabled;
    }

    public static boolean isHidingArmorFromSelf() {
        return hidingArmor;
    }

    public static boolean isHidingHeldItemFromSelf() {
        return hidingHeldItem;
    }

    public static boolean isKeepDisguiseOnEntityDespawn() {
        return keepDisguiseEntityDespawn;
    }

    public static boolean isKeepDisguiseOnPlayerDeath() {
        return keepDisguisePlayerDeath;
    }

    public static boolean isKeepDisguiseOnPlayerLogout() {
        return keepDisguisePlayerLogout;
    }

    public static boolean isMaxHealthDeterminedByDisguisedEntity() {
        return maxHealthIsDisguisedEntity;
    }

    public static boolean isMetadataPacketsEnabled() {
        return sendsEntityMetadata;
    }

    public static boolean isMiscDisguisesForLivingEnabled() {
        return miscDisguisesForLivingEnabled;
    }

    public static boolean isModifyBoundingBox() {
        return modifyBoundingBox;
    }

    public static boolean isMonstersIgnoreDisguises() {
        return targetDisguises;
    }

    public static boolean isMovementPacketsEnabled() {
        return movementEnabled;
    }

    public static boolean isNameAboveHeadAlwaysVisible() {
        return showNameAboveHeadAlwaysVisible;
    }

    public static boolean isNameOfPlayerShownAboveDisguise() {
        return showNameAboveHead;
    }

    public static boolean isSelfDisguisesSoundsReplaced() {
        return hearSelfDisguise;
    }

    public static boolean isSheepDyeable() {
        return colorizeSheep;
    }

    public static boolean isSoundEnabled() {
        return PacketsManager.isHearDisguisesEnabled();
    }

    public static boolean isUndisguiseOnWorldChange() {
        return undisguiseSwitchWorlds;
    }

    public static boolean isVelocitySent() {
        return sendVelocity;
    }

    public static boolean isViewDisguises() {
        return viewSelfDisguise;
    }

    public static boolean isWitherSkullPacketsEnabled() {
        return witherSkullEnabled;
    }

    public static boolean isWolfDyeable() {
        return colorizeWolf;
    }

    public static void setAddEntityAnimations(boolean isEntityAnimationsAdded) {
        entityAnimationsAdded = isEntityAnimationsAdded;
    }

    public static void setAnimationPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isAnimationPacketsEnabled()) {
            animationEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setBedPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isBedPacketsEnabled()) {
            bedEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setCollectPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isCollectPacketsEnabled()) {
            collectEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setDisguiseBlownMessage(String newMessage) {
        disguiseBlownMessage = newMessage;
    }

    public static void setDisguiseBlownOnAttack(boolean blowDisguise) {
        blowDisguisesOnAttack = blowDisguise;
    }

    public static void setDisguiseCloneExpire(int newExpires) {
        disguiseCloneExpire = newExpires;
    }

    public static void setDisguiseEntityExpire(int newExpires) {
        disguiseEntityExpire = newExpires;
    }

    public static void setEntityStatusPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isEntityStatusPacketsEnabled()) {
            entityStatusEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setEquipmentPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isEquipmentPacketsEnabled()) {
            equipmentEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setHearSelfDisguise(boolean replaceSound) {
        if (hearSelfDisguise != replaceSound) {
            hearSelfDisguise = replaceSound;
        }
    }

    public static void setHideArmorFromSelf(boolean hideArmor) {
        if (hidingArmor != hideArmor) {
            hidingArmor = hideArmor;
            PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
        }
    }

    public static void setHideHeldItemFromSelf(boolean hideHelditem) {
        if (hidingHeldItem != hideHelditem) {
            hidingHeldItem = hideHelditem;
            PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
        }
    }

    public static void setKeepDisguiseOnEntityDespawn(boolean keepDisguise) {
        keepDisguiseEntityDespawn = keepDisguise;
    }

    public static void setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        keepDisguisePlayerDeath = keepDisguise;
    }

    public static void setKeepDisguiseOnPlayerLogout(boolean keepDisguise) {
        keepDisguisePlayerLogout = keepDisguise;
    }

    public static void setMaxClonedDisguises(int newMax) {
        maxClonedDisguises = newMax;
    }

    public static void setMaxHealthDeterminedByDisguisedEntity(boolean isDetermined) {
        maxHealthIsDisguisedEntity = isDetermined;
    }

    public static void setMetadataPacketsEnabled(boolean enabled) {
        sendsEntityMetadata = enabled;
    }

    public static void setMiscDisguisesForLivingEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            miscDisguisesForLivingEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setModifyBoundingBox(boolean modifyBounding) {
        modifyBoundingBox = modifyBounding;
    }

    public static void setMonstersIgnoreDisguises(boolean ignore) {
        targetDisguises = ignore;
    }

    public static void setMovementPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isMovementPacketsEnabled()) {
            movementEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setNameAboveHeadAlwaysVisible(boolean alwaysVisible) {
        showNameAboveHeadAlwaysVisible = alwaysVisible;
    }

    public static void setNameOfPlayerShownAboveDisguise(boolean showNames) {
        showNameAboveHead = showNames;
    }

    public static void setSheepDyeable(boolean color) {
        colorizeSheep = color;
    }

    public static void setSoundsEnabled(boolean isSoundsEnabled) {
        PacketsManager.setHearDisguisesListener(isSoundsEnabled);
    }

    public static void setUndisguiseOnWorldChange(boolean isUndisguise) {
        undisguiseSwitchWorlds = isUndisguise;
    }

    public static void setUpdateMessage(String newMessage) {
        updateMessage = newMessage;
    }

    public static void setUpdateNotificationPermission(String newPermission) {
        updateNotificationPermission = newPermission;
    }

    public static void setStopShulkerDisguisesFromMoving(boolean stopShulkerDisguisesFromMoving) {
        DisguiseConfig.stopShulkerDisguisesFromMoving = stopShulkerDisguisesFromMoving;
    }

    public static boolean isStopShulkerDisguisesFromMoving() {
        return stopShulkerDisguisesFromMoving;
    }

    public static void setVelocitySent(boolean sendVelocityPackets) {
        sendVelocity = sendVelocityPackets;
    }

    public static void setViewDisguises(boolean seeOwnDisguise) {
        viewSelfDisguise = seeOwnDisguise;
    }

    public static void setWitherSkullPacketsEnabled(boolean enabled) {
        witherSkullEnabled = enabled;
    }

    public static void setWolfDyeable(boolean color) {
        colorizeWolf = color;
    }

    private DisguiseConfig() {
    }

    static {
        updateMessage = ChatColor.RED + "[LibsDisguises] " + ChatColor.DARK_RED + "There is a update ready to be downloaded! You are using " + ChatColor.RED + "v%s" + ChatColor.DARK_RED + ", the new version is " + ChatColor.RED + "%s" + ChatColor.DARK_RED + "!";
    }
}

