/*
 * Decompiled with CFR 0.152.
 */
package com.lukegb.mojo.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.log.ScmLogDispatcher;
import org.codehaus.plexus.util.StringUtils;

public class GitDescribeMojo
extends AbstractMojo {
    private ScmLogDispatcher logger = new ScmLogDispatcher();
    private MavenProject project;
    private File scmDirectory;
    private String outputPostfix;
    private String outputPrefix;
    private String failOutput;

    private void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().debug((CharSequence)"Provider message:");
            this.getLog().debug((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().debug((CharSequence)"Command output:");
            this.getLog().debug((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException("Command failed." + StringUtils.defaultString((Object)result.getProviderMessage()));
        }
    }

    public void execute() throws MojoExecutionException {
        try {
            String previousDescribe = this.getDescribeProperty();
            if (previousDescribe == null) {
                String describe = this.getDescriber();
                this.getLog().info((CharSequence)("Setting Git Describe: " + describe));
                this.setDescribeProperty(describe);
            }
        }
        catch (ScmException e) {
            throw new MojoExecutionException("SCM Exception", (Exception)((Object)e));
        }
    }

    protected String getDescriber() throws ScmException, MojoExecutionException {
        String[] commandtwo;
        String[] command;
        String line;
        if (this.outputPrefix == null) {
            this.outputPrefix = "";
        }
        if (this.outputPostfix == null) {
            this.outputPostfix = "";
        }
        if ((line = this.commandExecutor(command = new String[]{"git", "describe"})) == null && (line = this.commandExecutor(commandtwo = new String[]{"git", "log", "--pretty=format:\"%h\""})) == null) {
            line = this.failOutput;
        }
        return this.outputPrefix + line + this.outputPostfix;
    }

    private String commandExecutor(String[] command) {
        try {
            Process p = new ProcessBuilder(command).directory(this.scmDirectory).start();
            InputStream is = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            return line;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getDescribeProperty() {
        return this.getProperty("describer");
    }

    protected String getProperty(String property) {
        return this.project.getProperties().getProperty(property);
    }

    private void setDescribeProperty(String describer) {
        this.setProperty("describe", describer);
    }

    private void setProperty(String property, String value) {
        if (value != null) {
            this.project.getProperties().put(property, value);
        }
    }
}

